/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.GraphClusterer;
import edu.uci.ics.jung.algorithms.cluster.VertexClusterSet;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.PredicateUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class BicomponentClusterer
implements GraphClusterer {
    protected Map dfs_num;
    protected Map high;
    protected Map parents;
    protected Stack stack;
    protected int converse_depth;

    public ClusterSet extract(ArchetypeGraph theGraph) {
        Vertex v;
        if (!PredicateUtils.enforcesEdgeConstraint(theGraph, Graph.UNDIRECTED_EDGE)) {
            throw new IllegalArgumentException("Algorithm currently only handles undirected graphs.");
        }
        VertexClusterSet bicomponents = new VertexClusterSet(theGraph);
        if (theGraph.getVertices().isEmpty()) {
            return bicomponents;
        }
        this.dfs_num = new HashMap();
        Iterator it = theGraph.getVertices().iterator();
        while (it.hasNext()) {
            v = (Vertex)it.next();
            this.set(v, this.dfs_num, 0);
        }
        Iterator iter = theGraph.getVertices().iterator();
        while (iter.hasNext()) {
            v = (Vertex)iter.next();
            if (this.get(v, this.dfs_num) != 0) continue;
            this.high = new HashMap();
            this.stack = new Stack();
            this.parents = new HashMap();
            this.converse_depth = theGraph.numVertices();
            this.findBiconnectedComponents(v, bicomponents);
            if (theGraph.numVertices() - this.converse_depth != 1) continue;
            HashSet<Vertex> s = new HashSet<Vertex>();
            s.add(v);
            bicomponents.addCluster(s);
        }
        return bicomponents;
    }

    protected void findBiconnectedComponents(Vertex v, ClusterSet bicomponents) {
        int v_dfs_num = this.converse_depth--;
        this.set(v, this.dfs_num, v_dfs_num);
        this.set(v, this.high, v_dfs_num);
        Iterator iter = v.getNeighbors().iterator();
        while (iter.hasNext()) {
            Vertex w = (Vertex)iter.next();
            int w_dfs_num = this.get(w, this.dfs_num);
            Edge vw = v.findEdge(w);
            if (w_dfs_num == 0) {
                this.parents.put(w, v);
                this.stack.push(vw);
                this.findBiconnectedComponents(w, bicomponents);
                int w_high = this.get(w, this.high);
                if (w_high <= v_dfs_num) {
                    Edge e;
                    HashSet bicomponent = new HashSet();
                    do {
                        e = (Edge)this.stack.pop();
                        bicomponent.addAll(e.getIncidentVertices());
                    } while (e != vw);
                    bicomponents.addCluster(bicomponent);
                }
                this.set(v, this.high, Math.max(w_high, this.get(v, this.high)));
                continue;
            }
            if (w == this.parents.get(v)) continue;
            this.set(v, this.high, Math.max(w_dfs_num, this.get(v, this.high)));
        }
    }

    protected int get(Vertex v, Map m) {
        return (Integer)m.get(v);
    }

    protected void set(Vertex v, Map m, int value) {
        m.put(v, new Integer(value));
    }
}

