/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.impl.AbstractArchetypeGraph;
import edu.uci.ics.jung.graph.impl.AbstractElement;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractArchetypeEdge
extends AbstractElement
implements ArchetypeEdge {
    public Set getIncidentElements() {
        return this.getIncidentVertices();
    }

    public ArchetypeEdge getEqualEdge(ArchetypeGraph ag) {
        if (ag instanceof AbstractArchetypeGraph) {
            AbstractArchetypeGraph aag = (AbstractArchetypeGraph)ag;
            return aag.getEdgeByID(this.getID());
        }
        return null;
    }

    public ArchetypeEdge getEquivalentEdge(ArchetypeGraph ag) {
        return this.getEqualEdge(ag);
    }

    public int numVertices() {
        return this.getIncidentVertices().size();
    }

    public boolean isIncident(ArchetypeVertex v) {
        return this.getIncidentVertices().contains(v);
    }

    public ArchetypeEdge copy(ArchetypeGraph g) {
        AbstractArchetypeEdge e;
        if (g == this.getGraph()) {
            throw new IllegalArgumentException("Source and destination graphs must be different");
        }
        Iterator iter = this.getIncidentVertices().iterator();
        while (iter.hasNext()) {
            ArchetypeVertex av = (ArchetypeVertex)iter.next();
            if (av.getEqualVertex(g) != null) continue;
            throw new IllegalArgumentException("Cannot create edge: source edge's incident vertex " + av + "has no equivalent " + "in target graph");
        }
        try {
            e = (AbstractArchetypeEdge)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new FatalException("Can't copy edge " + this, cnse);
        }
        e.initialize();
        e.importUserData(this);
        return e;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArchetypeEdge)) {
            return false;
        }
        ArchetypeEdge e = (ArchetypeEdge)o;
        return this == e.getEqualEdge(this.getGraph());
    }
}

