/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import corejava.Format;
import edu.uci.ics.jung.algorithms.GraphMatrixOperations;
import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.io.GraphFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MatrixFile
implements GraphFile {
    private String mWeightKey;

    public MatrixFile(String weightKey) {
        this.mWeightKey = weightKey;
    }

    public Graph load(BufferedReader reader) {
        Graph graph = null;
        try {
            DoubleMatrix2D matrix = this.createMatrixFromFile(reader);
            graph = GraphMatrixOperations.matrixToGraph(matrix, this.mWeightKey);
        }
        catch (Exception e) {
            throw new FatalException("Fatal exception calling MatrixFile.load(...)", e);
        }
        return graph;
    }

    private DoubleMatrix2D createMatrixFromFile(BufferedReader reader) throws IOException, ParseException {
        StringTokenizer tokenizer;
        ArrayList<DoubleArrayList> rows = new ArrayList<DoubleArrayList>();
        String currentLine = null;
        while ((currentLine = reader.readLine()) != null && (tokenizer = new StringTokenizer(currentLine)).countTokens() != 0) {
            DoubleArrayList currentRow = new DoubleArrayList();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                currentRow.add(Double.parseDouble(token));
            }
            rows.add(currentRow);
        }
        int size = rows.size();
        SparseDoubleMatrix2D matrix = new SparseDoubleMatrix2D(size, size);
        for (int i = 0; i < size; ++i) {
            DoubleArrayList currentRow = (DoubleArrayList)rows.get(i);
            if (currentRow.size() != size) {
                throw new ParseException("Matrix must have the same number of rows as columns", 0);
            }
            for (int j = 0; j < size; ++j) {
                double currentVal = currentRow.get(j);
                if (currentVal == 0.0) continue;
                matrix.setQuick(i, j, currentVal);
            }
        }
        return matrix;
    }

    public Graph load(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            Graph graph = this.load(reader);
            reader.close();
            return graph;
        }
        catch (IOException ioe) {
            throw new FatalException("Error in loading file " + filename, ioe);
        }
    }

    public void save(Graph graph, String filename) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            SparseDoubleMatrix2D matrix = GraphMatrixOperations.graphToSparseMatrix(graph, this.mWeightKey);
            Format labelFormat = new Format("%4.2f");
            for (int i = 0; i < matrix.rows(); ++i) {
                for (int j = 0; j < matrix.columns(); ++j) {
                    writer.write(labelFormat.format(matrix.getQuick(i, j)) + " ");
                }
                writer.write("\n");
            }
            writer.close();
        }
        catch (Exception e) {
            throw new FatalException("Error saving file: " + filename, e);
        }
    }
}

