/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import edu.uci.ics.jung.visualization.LayoutMutable;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class FRLayout
extends AbstractLayout
implements LayoutMutable {
    private static final Object FR_KEY = "edu.uci.ics.jung.FR_Visualization_Key";
    private double forceConstant;
    private double temperature;
    private int currentIteration;
    private String status = null;
    private int mMaxIterations = 700;
    private double attraction_multiplier = 0.75;
    private double attraction_constant;
    private double repulsion_multiplier = 0.75;
    private double repulsion_constant;
    private Object key = null;
    private double EPSILON = 1.0E-6;

    public FRLayout(Graph g) {
        super(g);
    }

    public void setAttractionMultiplier(double attraction) {
        this.attraction_multiplier = attraction;
    }

    public void setRepulsionMultiplier(double repulsion) {
        this.repulsion_multiplier = repulsion;
    }

    public synchronized void update() {
        try {
            Iterator iter = this.getGraph().getVertices().iterator();
            while (iter.hasNext()) {
                Vertex v = (Vertex)iter.next();
                Coordinates coord = this.getCoordinates(v);
                if (coord != null) continue;
                coord = new Coordinates();
                v.addUserDatum(this.getBaseKey(), coord, UserData.REMOVE);
                this.initializeLocation(v, coord, this.getCurrentSize());
                this.initialize_local_vertex(v);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.update();
        }
        this.initialize_local();
    }

    public String getStatus() {
        return this.status;
    }

    public void forceMove(Vertex picked, double x, double y) {
        super.forceMove(picked, x, y);
    }

    protected void initialize_local() {
        this.currentIteration = 0;
        this.temperature = this.getCurrentSize().getWidth() / 10.0;
        this.forceConstant = Math.sqrt(this.getCurrentSize().getHeight() * this.getCurrentSize().getWidth() / (double)this.getVisibleGraph().numVertices());
        this.attraction_constant = this.attraction_multiplier * this.forceConstant;
        this.repulsion_constant = this.repulsion_multiplier * this.forceConstant;
    }

    public Object getKey() {
        if (this.key == null) {
            this.key = new Pair(this, FR_KEY);
        }
        return this.key;
    }

    protected void initialize_local_vertex(Vertex v) {
        if (v.getUserDatum(this.getKey()) == null) {
            v.addUserDatum(this.getKey(), new FRVertexData(), UserData.REMOVE);
        }
    }

    public synchronized void advancePositions() {
        Iterator iter;
        ++this.currentIteration;
        this.status = "VV: " + this.getVisibleVertices().size() + " IT: " + this.currentIteration + " temp: " + this.temperature;
        while (true) {
            try {
                iter = this.getVisibleVertices().iterator();
                while (iter.hasNext()) {
                    Vertex v1 = (Vertex)iter.next();
                    if (this.isLocked(v1)) continue;
                    this.calcRepulsion(v1);
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                iter = this.getVisibleEdges().iterator();
                while (iter.hasNext()) {
                    Edge e = (Edge)iter.next();
                    this.calcAttraction(e);
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                iter = this.getVisibleVertices().iterator();
                while (iter.hasNext()) {
                    Vertex v = (Vertex)iter.next();
                    if (this.isLocked(v)) continue;
                    this.calcPositions(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.cool();
    }

    public synchronized void calcPositions(Vertex v) {
        FRVertexData fvd = this.getFRData(v);
        if (fvd == null) {
            return;
        }
        Coordinates xyd = this.getCoordinates(v);
        double deltaLength = Math.max(this.EPSILON, Math.sqrt(fvd.disp.zDotProduct(fvd.disp)));
        double newXDisp = fvd.getXDisp() / deltaLength * Math.min(deltaLength, this.temperature);
        if (Double.isNaN(newXDisp)) {
            throw new FatalException("Unexpected mathematical result in FRLayout:calcPositions [xdisp]");
        }
        double newYDisp = fvd.getYDisp() / deltaLength * Math.min(deltaLength, this.temperature);
        xyd.addX(newXDisp);
        xyd.addY(newYDisp);
        double borderWidth = this.getCurrentSize().getWidth() / 50.0;
        double newXPos = xyd.getX();
        if (newXPos < borderWidth) {
            newXPos = borderWidth + Math.random() * borderWidth * 2.0;
        } else if (newXPos > this.getCurrentSize().getWidth() - borderWidth) {
            newXPos = this.getCurrentSize().getWidth() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        double newYPos = xyd.getY();
        if (newYPos < borderWidth) {
            newYPos = borderWidth + Math.random() * borderWidth * 2.0;
        } else if (newYPos > this.getCurrentSize().getHeight() - borderWidth) {
            newYPos = this.getCurrentSize().getHeight() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        xyd.setX(newXPos);
        xyd.setY(newYPos);
    }

    public void calcAttraction(Edge e) {
        double yDelta;
        Pair endpoints = e.getEndpoints();
        Vertex v1 = (Vertex)endpoints.getFirst();
        Vertex v2 = (Vertex)endpoints.getSecond();
        boolean v1_locked = this.isLocked(v1);
        boolean v2_locked = this.isLocked(v2);
        if (v1_locked && v2_locked) {
            return;
        }
        Point2D p1 = this.getLocation(v1);
        Point2D p2 = this.getLocation(v2);
        if (p1 == null || p2 == null) {
            return;
        }
        double xDelta = p1.getX() - p2.getX();
        double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + (yDelta = p1.getY() - p2.getY()) * yDelta));
        double force = deltaLength * deltaLength / this.attraction_constant;
        if (Double.isNaN(force)) {
            throw new FatalException("Unexpected mathematical result in FRLayout:calcPositions [force]");
        }
        double dx = xDelta / deltaLength * force;
        double dy = yDelta / deltaLength * force;
        if (!v1_locked) {
            FRVertexData fvd1 = this.getFRData(v1);
            fvd1.decrementDisp(dx, dy);
        }
        if (!v2_locked) {
            FRVertexData fvd2 = this.getFRData(v2);
            fvd2.incrementDisp(dx, dy);
        }
    }

    public void calcRepulsion(Vertex v1) {
        FRVertexData fvd1 = this.getFRData(v1);
        if (fvd1 == null) {
            return;
        }
        fvd1.setDisp(0.0, 0.0);
        try {
            Iterator iter2 = this.getVisibleVertices().iterator();
            while (iter2.hasNext()) {
                double yDelta;
                Vertex v2 = (Vertex)iter2.next();
                if (v1 == v2) continue;
                Point2D p1 = this.getLocation(v1);
                Point2D p2 = this.getLocation(v2);
                if (p1 == null || p2 == null) continue;
                double xDelta = p1.getX() - p2.getX();
                double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + (yDelta = p1.getY() - p2.getY()) * yDelta));
                double force = this.repulsion_constant * this.repulsion_constant / deltaLength;
                if (Double.isNaN(force)) {
                    throw new FatalException("Unexpected mathematical result in FRLayout:calcPositions [repulsion]");
                }
                fvd1.incrementDisp(xDelta / deltaLength * force, yDelta / deltaLength * force);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calcRepulsion(v1);
        }
    }

    private void cool() {
        this.temperature *= 1.0 - (double)this.currentIteration / (double)this.mMaxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.mMaxIterations = maxIterations;
    }

    public FRVertexData getFRData(Vertex v) {
        return (FRVertexData)v.getUserDatum(this.getKey());
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return this.currentIteration > this.mMaxIterations;
    }

    public static class FRVertexData {
        private DoubleMatrix1D disp;

        public FRVertexData() {
            this.initialize();
        }

        public void initialize() {
            this.disp = new DenseDoubleMatrix1D(2);
        }

        public double getXDisp() {
            return this.disp.get(0);
        }

        public double getYDisp() {
            return this.disp.get(1);
        }

        public void setDisp(double x, double y) {
            this.disp.set(0, x);
            this.disp.set(1, y);
        }

        public void incrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) + x);
            this.disp.set(1, this.disp.get(1) + y);
        }

        public void decrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) - x);
            this.disp.set(1, this.disp.get(1) - y);
        }
    }
}

