/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.VertexIconFunction;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.Transformer;
import edu.uci.ics.jung.visualization.transform.shape.PluggableRendererDecorator;
import edu.uci.ics.jung.visualization.transform.shape.TransformingGraphics;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class TransformingPluggableRenderer
extends PluggableRendererDecorator {
    Transformer transformer = new MutableAffineTransformer();
    TransformingGraphics tg2d = new TransformingGraphics(this.transformer);

    public TransformingPluggableRenderer(PluggableRenderer delegate) {
        super(delegate);
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
        this.tg2d.setTransformer(transformer);
    }

    protected void drawSimpleEdge(Graphics2D g, Edge e, int x1, int y1, int x2, int y2) {
        this.tg2d.setDelegate(g);
        this.drawSimpleEdge(this.tg2d, e, x1, y1, x2, y2);
    }

    protected void drawSimpleEdge(TransformingGraphics g, Edge e, int x1, int y1, int x2, int y2) {
        HyperbolicTransformer ht;
        Ellipse2D hyperEllipse;
        float flatness = 0.0f;
        if (this.transformer instanceof HyperbolicTransformer && ((hyperEllipse = (ht = (HyperbolicTransformer)this.transformer).getEllipse()).contains(x1, y1) || hyperEllipse.contains(x2, y2))) {
            flatness = 0.05f;
        }
        Pair endpoints = e.getEndpoints();
        Vertex v1 = (Vertex)endpoints.getFirst();
        Vertex v2 = (Vertex)endpoints.getSecond();
        boolean isLoop = v1.equals(v2);
        Shape s2 = this.getVertexShapeFunction().getShape(v2);
        Shape edgeShape = this.getEdgeShapeFunction().getShape(e);
        boolean edgeHit = true;
        boolean arrowHit = true;
        Rectangle deviceRectangle = null;
        if (this.getScreenDevice() != null) {
            Dimension d = this.getScreenDevice().getSize();
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        if (isLoop) {
            Rectangle2D s2Bounds = s2.getBounds2D();
            xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
        } else {
            float dx = x2 - x1;
            float dy = y2 - y1;
            float thetaRadians = (float)Math.atan2(dy, dx);
            xform.rotate(thetaRadians);
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            xform.scale(dist, 1.0);
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        edgeHit = g.hit(deviceRectangle, edgeShape, true);
        if (edgeHit) {
            String label;
            Paint draw_paint;
            Paint oldPaint = g.getPaint();
            Paint fill_paint = this.getEdgePaintFunction().getFillPaint(e);
            if (fill_paint != null) {
                g.setPaint(fill_paint);
                g.fill(edgeShape, flatness);
            }
            if ((draw_paint = this.getEdgePaintFunction().getDrawPaint(e)) != null) {
                g.setPaint(draw_paint);
                g.draw(edgeShape, flatness);
            }
            float scalex = (float)g.getTransform().getScaleX();
            float scaley = (float)g.getTransform().getScaleY();
            if ((double)scalex < 0.3 || (double)scaley < 0.3) {
                return;
            }
            if (this.getEdgeArrowPredicate().evaluate((Object)e)) {
                Shape destVertexShape = this.getVertexShapeFunction().getShape((Vertex)e.getEndpoints().getSecond());
                AffineTransform xf = AffineTransform.getTranslateInstance(x2, y2);
                destVertexShape = xf.createTransformedShape(destVertexShape);
                arrowHit = g.hit(deviceRectangle, destVertexShape, true);
                if (arrowHit) {
                    AffineTransform at = this.getArrowTransform(new GeneralPath(edgeShape), destVertexShape);
                    if (at == null) {
                        return;
                    }
                    Shape arrow = this.getEdgeArrowFunction().getArrow(e);
                    arrow = at.createTransformedShape(arrow);
                    g.fill(arrow);
                    if (e instanceof UndirectedEdge) {
                        Shape vertexShape = this.getVertexShapeFunction().getShape((Vertex)e.getEndpoints().getFirst());
                        xf = AffineTransform.getTranslateInstance(x1, y1);
                        vertexShape = xf.createTransformedShape(vertexShape);
                        arrowHit = g.hit(deviceRectangle, vertexShape, true);
                        if (arrowHit) {
                            at = this.getReverseArrowTransform(new GeneralPath(edgeShape), vertexShape, !isLoop);
                            if (at == null) {
                                return;
                            }
                            arrow = this.getEdgeArrowFunction().getArrow(e);
                            arrow = at.createTransformedShape(arrow);
                            g.fill(arrow);
                        }
                    }
                }
            }
            if (draw_paint == null) {
                g.setPaint(oldPaint);
            }
            if ((label = this.getEdgeStringer().getLabel(e)) != null) {
                this.labelEdge(g, e, label, x1, x2, y1, y2);
            }
            g.setPaint(oldPaint);
        }
    }

    protected void labelEdge(Graphics2D g2d, Edge e, String label, int x1, int x2, int y1, int y2) {
        this.tg2d.setDelegate(g2d);
        this.labelEdge(this.tg2d, e, label, x1, x2, y1, y2);
    }

    protected void labelEdge(TransformingGraphics g2d, Edge e, String label, int x1, int x2, int y1, int y2) {
        Point2D p = g2d.getTransformer().transform(new Point2D.Float(x1, y1));
        Point2D q = g2d.getTransformer().transform(new Point2D.Float(x2, y2));
        x1 = (int)p.getX();
        y1 = (int)p.getY();
        x2 = (int)q.getX();
        y2 = (int)q.getY();
        int distX = x2 - x1;
        int distY = y2 - y1;
        double totalLength = Math.sqrt(distX * distX + distY * distY);
        double closeness = this.getEdgeLabelClosenessFunction().getNumber(e).doubleValue();
        int posX = (int)((double)x1 + closeness * (double)distX);
        int posY = (int)((double)y1 + closeness * (double)distY);
        int xDisplacement = (int)(10.0 * ((double)distY / totalLength));
        int yDisplacement = (int)(10.0 * ((double)(-distX) / totalLength));
        Component component = this.prepareRenderer(this.getGraphLabelRenderer(), (Object)label, this.isPicked(e), e);
        Dimension d = component.getPreferredSize();
        Font font = this.getEdgeFontFunction().getFont(e);
        if (font != null) {
            component.setFont(font);
        }
        Shape edgeShape = this.getEdgeShapeFunction().getShape(e);
        double parallelOffset = 1.0;
        Integer parallelCount = (Integer)e.getUserDatum("parallelCount");
        if (parallelCount != null) {
            parallelOffset += (double)parallelCount.intValue();
        }
        if (edgeShape instanceof Ellipse2D) {
            parallelOffset += edgeShape.getBounds().getHeight();
            parallelOffset = -parallelOffset;
        }
        parallelOffset *= (double)d.height;
        AffineTransform old = g2d.getTransform();
        AffineTransform xform = new AffineTransform(old);
        xform.translate(posX + xDisplacement, posY + yDisplacement);
        if (this.getGraphLabelRenderer().isRotateEdgeLabels()) {
            double dx = x2 - x1;
            double dy = y2 - y1;
            double theta = Math.atan2(dy, dx);
            if (dx < 0.0) {
                theta += Math.PI;
                parallelOffset = -parallelOffset;
            }
            xform.rotate(theta);
        }
        xform.translate(-d.width / 2, -((double)(d.height / 2) - parallelOffset));
        g2d.setTransform(xform);
        this.getRendererPane().paintComponent(g2d.getDelegate(), component, this.getScreenDevice(), 0, 0, d.width, d.height, true);
        g2d.setTransform(old);
    }

    protected void labelVertex(Graphics g, Vertex v, String label, int x, int y) {
        this.tg2d.setDelegate((Graphics2D)g);
        this.labelVertex(this.tg2d, v, label, x, y);
    }

    protected void labelVertex(TransformingGraphics g, Vertex v, String label, int x, int y) {
        int v_offset;
        int h_offset;
        Component component = this.prepareRenderer(this.getGraphLabelRenderer(), (Object)label, this.isPicked(v), v);
        Font font = this.getVertexFontFunction().getFont(v);
        if (font != null) {
            component.setFont(font);
        }
        Dimension d = component.getPreferredSize();
        Point2D p = g.getTransformer().transform(new Point2D.Float(x, y));
        x = (int)p.getX();
        y = (int)p.getY();
        if (this.getVertexLabelCentering()) {
            h_offset = -d.width / 2;
            v_offset = -d.height / 2;
        } else {
            Rectangle2D bounds = this.getVertexShapeFunction().getShape(v).getBounds2D();
            h_offset = (int)(bounds.getWidth() / 2.0) + 5;
            v_offset = (int)(bounds.getHeight() / 2.0) + 5 - d.height;
        }
        this.getRendererPane().paintComponent(g.getDelegate(), component, this.getScreenDevice(), x + h_offset, y + v_offset, d.width, d.height, true);
    }

    public void paintEdge(Graphics g, Edge e, int x1, int y1, int x2, int y2) {
        this.tg2d.setDelegate((Graphics2D)g);
        this.paintEdge(this.tg2d, e, x1, y1, x2, y2);
    }

    public void paintEdge(TransformingGraphics g2d, Edge e, int x1, int y1, int x2, int y2) {
        if (!this.getEdgeIncludePredicate().evaluate((Object)e)) {
            return;
        }
        Pair endpoints = e.getEndpoints();
        Vertex v1 = (Vertex)endpoints.getFirst();
        Vertex v2 = (Vertex)endpoints.getSecond();
        if (!this.getVertexIncludePredicate().evaluate((Object)v1) || !this.getVertexIncludePredicate().evaluate((Object)v2)) {
            return;
        }
        Stroke new_stroke = this.getEdgeStrokeFunction().getStroke(e);
        Stroke old_stroke = g2d.getStroke();
        if (new_stroke != null) {
            g2d.setStroke(new_stroke);
        }
        this.drawSimpleEdge(g2d, e, x1, y1, x2, y2);
        if (new_stroke != null) {
            g2d.setStroke(old_stroke);
        }
    }

    public void paintVertex(Graphics g, Vertex v, int x, int y) {
        this.tg2d.setDelegate((Graphics2D)g);
        this.paintVertex(this.tg2d, v, x, y);
    }

    public void paintVertex(TransformingGraphics g2d, Vertex v, int x, int y) {
        if (!this.getVertexIncludePredicate().evaluate((Object)v)) {
            return;
        }
        boolean vertexHit = true;
        Rectangle deviceRectangle = null;
        if (this.getScreenDevice() != null) {
            Dimension d = this.getScreenDevice().getSize();
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        Stroke old_stroke = g2d.getStroke();
        Stroke new_stroke = this.getVertexStrokeFunction().getStroke(v);
        if (new_stroke != null) {
            g2d.setStroke(new_stroke);
        }
        Shape s = this.getVertexShapeFunction().getShape(v);
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        s = xform.createTransformedShape(s);
        vertexHit = g2d.hit(deviceRectangle, s, true);
        if (vertexHit) {
            String label;
            VertexIconFunction imager = this.getVertexIconFunction();
            Icon icon = null;
            if (imager != null && (icon = imager.getIcon(v)) != null) {
                this.paintIconForVertex(g2d, icon, x, y);
            } else {
                this.paintShapeForVertex(g2d, v, s);
            }
            if (new_stroke != null) {
                g2d.setStroke(old_stroke);
            }
            if ((label = this.getVertexStringer().getLabel(v)) != null) {
                this.labelVertex(g2d, v, label, x, y);
            }
        }
    }

    protected void paintShapeForVertex(TransformingGraphics g2d, Vertex v, Shape shape) {
        Paint drawPaint;
        Paint oldPaint = g2d.getPaint();
        Paint fillPaint = this.getVertexPaintFunction().getFillPaint(v);
        if (fillPaint != null) {
            g2d.setPaint(fillPaint);
            g2d.fill(shape);
            g2d.setPaint(oldPaint);
        }
        if ((drawPaint = this.getVertexPaintFunction().getDrawPaint(v)) != null) {
            g2d.setPaint(drawPaint);
            g2d.draw(shape);
            g2d.setPaint(oldPaint);
        }
    }

    public void paintIconForVertex(TransformingGraphics g, Icon icon, int x, int y) {
        if (icon != null) {
            int xLoc = x - icon.getIconWidth() / 2;
            int yLoc = y - icon.getIconHeight() / 2;
            icon.paintIcon(this.getScreenDevice(), g.getDelegate(), xLoc, yLoc);
        }
    }
}

