/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.test;

import edu.uci.ics.jung.graph.Element;
import java.awt.Color;
import java.awt.Graphics;
import samples.preview_new_graphdraw.Coordinates;
import samples.preview_new_graphdraw.EdgeRenderer;
import samples.preview_new_graphdraw.VertexRenderer;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.test.CircleEdge;

public class CircleRenderer
implements EdgeRenderer,
VertexRenderer {
    int i = 0;

    public void renderEdge(Graphics g, VisEdge ec) {
        try {
            CircleEdge cve = (CircleEdge)ec;
            double r = cve.getRadius();
            Coordinates tl = cve.getCenter();
            if (this.selected(ec.getEdge())) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            double theta = cve.getStartAngle();
            int angle = (int)(theta * 180.0 / Math.PI);
            Color c = new Color(247, 210, 130, 50);
            g.setColor(c);
            g.fillArc((int)(tl.getX() - r), (int)(tl.getY() - r), (int)(2.0 * r), (int)(2.0 * r), -angle, 180);
            g.setColor(new Color(247, 210, 130));
            g.drawArc((int)(tl.getX() - r), (int)(tl.getY() - r), (int)(2.0 * r), (int)(2.0 * r), -angle, 180);
        }
        catch (ClassCastException cce) {
            g.setColor(Color.lightGray);
            this.plainDraw(g, ec);
        }
    }

    private void plainDraw(Graphics g, VisEdge ec) {
        if (this.selected(ec.getEdge())) {
            g.setColor(Color.red);
        }
        Coordinates v1 = ec.getFront();
        Coordinates v2 = ec.getBack();
        g.drawLine((int)v1.getX(), (int)v1.getY(), (int)v2.getX(), (int)v2.getY());
    }

    public void renderVertex(Graphics g, VisVertex vc) {
        if (this.selected(vc.getVertex())) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.black);
        }
        g.fillOval((int)vc.getX() - 3, (int)vc.getY() - 3, 6, 6);
    }

    private boolean selected(Element grapobject) {
        boolean b = grapobject.getUserDatum("SELECTED") != null;
        return b;
    }
}

