function write_probs_continuous(parents, betavectors, variances, labels, savedir)

fid=fopen(fullfile(savedir, 'network_parameters.txt'),'w');

nvar=length(labels);

for i=1:nvar
    fprintf(fid,'Variable: %s\n', labels{i});
    fprintf(fid,'\tVariance:\t%.3f\n', variances(i));

    fprintf(fid,'\tBeta:\t%.3f\t', betavectors{i}(1));

    if ~isempty(parents{i})
        for j=1:length(parents{i})
            fprintf(fid,'%.3f\t',betavectors{i}(j+1));
        end

        fprintf(fid,'\n');
        fprintf(fid,'\tParents\tconstant\t');


        for j=1:length(parents{i})
            fprintf(fid,'%s\t',labels{parents{i}(j)});
        end


    else
        fprintf(fid,'\n');
        fprintf(fid,'\tParents\tconstant\t');
    end

    fprintf(fid,'\n\n');
end

fclose(fid);





