function write_probs_discrete(labels, varstates, CPTs, dag, savedir)

fid=fopen(fullfile(savedir, 'network_parameters.txt'),'w');

nvar=length(labels);

%cycle on variables
for i=1:nvar
    fprintf(fid,'Node: %s\n', labels{i});
    par=find(dag(:,i));
    npar=length(par);

    if npar>0
        %write parents names
        for j=1:npar
            fprintf(fid,'%s\t', labels{par(j)});
        end
        %write possible values of child
        for k=1:length(varstates{i})
            fprintf(fid,'%s\t', varstates{i}{k});
        end
        fprintf(fid,'\n');
    end

    n = ndims(CPTs{i});
    parents_size = size(CPTs{i});
    parents_size = parents_size(1:end-1);
    child_size = size(CPTs{i},n);

    for m=1:prod(parents_size)
        parent_inst = ind2subv(parents_size, m);
       if npar>0
            for h=1:length(parent_inst)
                fprintf(fid, '%s\t ', varstates{par(h)}{parent_inst(h)});
            end
            index = num2cell([parent_inst 1]);
            index{n} = ':';
            fprintf(fid, '%.3f\t ', CPTs{i}(index{:}));
            fprintf(fid, '\n');

        else %no parents
            fprintf(fid, '%s\t ', varstates{i}{parent_inst});
            index = num2cell([parent_inst 1]);
            index{n} = ':';
            fprintf(fid, '%.3f\t', CPTs{i}(index{:}));
            fprintf(fid, '\n');
        end

    end
     fprintf(fid, '\n\n');
end

fclose(fid);