#!/usr/local/bin/perl
#
# This script merges all the .DTA files in the current directory into a single ASCII file
#
# By Alessandra Tiengo - Lab. Informatica Medica - Dip. Informatica e 
# Sistemistica - Univ. Pavia - 2011
#

use Cwd;

$file_output=$ARGV[0]; #output file

$dir_data=cwd; #current directory
opendir(DATA,$dir_data);
@allfiles=readdir(DATA);
closedir(DATA);

#$file_tmp="temp_".time;
open(RES,">".$file_output);
for($i=0; $i<@allfiles; $i++){
	if($allfiles[$i]=~/.dta/){
		#scan event e.g. Mio01.24.27.1
		@split_1=split('\.',$allfiles[$i]);
    	$scan_event=$split_1[1]."_".$split_1[2];
    	if($hash{$scan_event}==1){
    		#if the scan already exists, add the charge to the title
    		$scan_event=$scan_event.$split_1[3];
    	}
    	else{
    	   	$hash{$scan_event}=1;
    	}
		open(INFILE,"<$allfiles[$i]");
		$row=<INFILE>; #header with mz and charge
		chomp($row);
		($mz, $charge) = split(" ", $row);
      	$mz_ok = ($mz + ($charge - 1) * 1.007276) / $charge; 
      	print RES "$mz_ok\t$charge\t$scan_event\n";
		while(! eof INFILE){
			$row=<INFILE>; 
			print RES $row;
		}		
		close(INFILE);
		print RES "\n";
	}	
}
close(RES);

