#!/usr/bin/perl
#
# This script creates performs the protein identification
# If compareC.c has been compiled, it uses the executable files compare (linux platform)
# or compare_win.exe (windows platform) to perform the identification.
# If the files "compare" or "compare_win.exe" are present in the folder, 
# they are used to perform the comparison between experimental and theoretical MS/MS peaks,
# speeding up the searching step.
# If they are not present, the searching step is anyway performed by using a Perl routine. 
#
# By Alessandra Tiengo - Lab. Informatica Medica - Dip. Informatica e 
# Sistemistica - Univ. Pavia - 2011
# 
#

use IO::Zlib;
use Cwd;
no warnings;

#subroutines
#controls the user input
sub format_number{
  my $value=$_[0];
  if (index($value,".")==-1){
    $value=$value.".0";
  }
  while ($value=~/[^\d+\.\d*]/||$value=~/\.{2,}/){
    print "Wrong input. Insert \n";
    $value=<STDIN>;
    chomp($value);
    if (index($value,".")==-1){
      $value=$value.".0";
    }  
  }
  return $value;
}
 
#this subroutine controls a numeric input
sub number{
  local($number, $n, $s, $a, $i, $flag_num);
  $number=$_[0];
  $n=$_[1];
  $flag_num=$_[2];
  $a=$n-1; 
  $s=0;
  while ($s==0){
      for ($i=$flag_num; $i<($n+$flag_num); $i++){
        if($number eq $i){
            $s=1;
        }
      }
      if ($s==0 && $flag_num==0){
        print "\nWrong input. Insert a number from 0 to $a\n";
        $number=<STDIN>;
        chomp($number);
      }
  } 
  return $number;
}

#controls the user input
sub answer {
  my $answer;
  my $flag_letter;
	$answer=$_[0];
	$flag_letter=$_[1];
	if ($flag_letter==0){
	 while ($answer=~/^[^YN]/){
      print "\nWrong input. Answer Y o N\n";
      $answer=uc(<STDIN>);
      chomp($answer);  
    }
  }
  return $answer;
}
 
#subroutine that returns the upper and lower bounds in the database files
#on the basis of the mass range and on the input file
sub db_bound{
    local($ref_db,$ref_control,$p,$n_file,@database,@control_file,$i,$ref_file,$control_file);
    local($n_file,$first_pep,$j,$value_f,$value,$file_db,@file_db,$value1,$value2,$p);
    $ref_db=$_[0];
    $ref_control=$_[1];
    @database=@$ref_db;
    @control_file=@$ref_control;
    $p=0;
    $n_file=@database;
    for($j=0;$j<@control_file;$j++){
        $value_f=$control_file[$j];
        $value=$database[0];
        $value=~tr/_/./;
        #first bin
        if($value_f<=$value){
             $file_db[$p]=0;
             $p++;   
             next; 
        }
        #last bin (big_pep case)
        $value=$database[$n_file-2];
        $value=~tr/_/./;
        if($value_f>$value){
            $file_db[$p]=$n_file-1;
            $p++;   
            next; 
        }
        for($i=1;$i<$n_file-1;$i++){
            $value1=$database[$i-1];
            $value1=~tr/_/./;
            $value2=$database[$i];  
            $value2=~tr/_/./;
            if($value_f>$value1 && $value_f<=$value2){
              $file_db[$p]=$i;
              $p++;   
              last; 
            }
            next;
        }
    }
    $ref_file=\@file_db;
    return $ref_file;
}

#compute the molecular weight
sub molecular_weight{
 	local($mol, $ref_aa, $ref_mw, @aa, @mw, $weight, $i, $total_w, $number_aa, $flag);
	$mol=$_[0]; #protein or peptide
	$ref_aa=$_[1];	
	$ref_mw=$_[2];
	$flag=$_[3]; #0 if protein 1 if peptide
 	#retrieves the arrays
	@aa=@$ref_aa;
	@mw=@$ref_mw;
	if ($flag==0){
	   $weight=18.01524; #average molecular weight of water
	}
	else{
      $weight=18.01056; #monoisotopic molecular weight of water
	}
 	for($i=0; $i<@aa; $i++){
	  $number_aa=($mol=~s/$aa[$i]/$aa[$i]/g);
	  #computes mw
      $total_w=$mw[$i]*$number_aa;
	  $number_aa=0;
      #updates mw
      $weight=$weight+$total_w;
  	}
  
   	return $weight;
}

#tag control
sub tag_control{
   local($id,$string_tag,$d,$start_id,@split_id,$string_id,$mc,$flag_star,$mod,$n_mod,$diff_bit);
   local($size_id,$flag_ok,$delta_mass_plus,$t,$index);
   #@ptm_fragm,
   $string_tag=$_[0];
   $id=$_[1];
   @split_id=split("_",$id);
   $start_id=0;
   $mc=0;
   $string_id="";
   $flag_star=0;
   $flag_ok=0;
   $delta_mass_plus=0;
   $size_id=@split_id;
   @ptm_fragm=0;
   pop(@ptm_fragm);  
   $cod_tag="";
   if($size_id==1){
      $flag_ok=1;
   }
   else{
       for($w=1;$w<@split_id;$w++){
          if($split_id[$w]=~/\D+/){
              $start_id=$w;
              $mc=$start_id-1;
              last;    
          }
       } 
       if($mc<=$n_mc){
           if($size_id>$start_id){
               $t=0;
               for($d=$start_id;$d<@split_id;$d++){
                  $split_id[$d]=~/([a-zA-Z]+)([0-9]+|\*{1})/;
                  $mod=$1;
                  $n_mod=$2;
                  ##tag control
                  if($n_mod==0 && $n_mod ne "\*"){
                    $string_id=$string_id."0";
                  }
                  elsif($n_mod>0){
                    $string_id=$string_id."1"; 
                  }
                  elsif($n_mod eq "\*" && substr($string_tag,(($d-$mc)-1),1) eq "0"){
                    $string_id=$string_id."0";
                    
                  }
                  else{
                      $flag_star=1;
                      last;
                  }
                  if(substr($string_tag,(($d-$mc)-1),1) eq "1" && $flag_star==0){
                     $delta_mass_plus=$delta_mass_plus+($n_mod*$ptm_value[($d-$mc)-1]);
                     if($ptm_file_type[($d-$mc)-1] eq "V"){
                     	$index=($d-$mc)-1;
                     	$ptm_fragm[$t]=$n_mod."_".$index; 
                     	$t++;
                     }
                     
                  }
                  $cod_tag=$cod_tag.$split_id[$d];
               }
               if($flag_star==0){
                   $diff_bit=$string_tag-$string_id;    
                   if($diff_bit>=0 && index($diff_bit,"9")==-1){   
                    $flag_ok=1;
                   }
               } 
           }
           else{
              $flag_ok=1;
           }
           #mass to be added to the MW of the protein
           $delta_mass_plus=$delta_mass_plus-($mc*18.01524);
       }
   }
   return ($flag_ok,$delta_mass_plus,$cod_tag,@ptm_fragm);
}

#phosphorilations control
sub phospho_control{
   local($id,$n_phospho,$d,$start_id,@split_id,$mod,$n_mod);
   local($size_id,$flag_ok);
   $id=$_[0];
   $n_phospho=$_[1];
   $flag_ok=1;
   @split_id=split("_",$id);
   $start_id=0;
   $delta_mass_plus=0;
   $size_id=@split_id;
   if($size_id==1){
      $flag_ok=1;
   }
   else{
       for($w=1;$w<@split_id;$w++){
          if($split_id[$w]=~/\D+/){
              $start_id=$w;
              last;    
          }
       } 
       ###if($mc<=$n_mc){
           if($size_id>$start_id){
               for($d=$start_id;$d<@split_id;$d++){
                  $split_id[$d]=~/([a-zA-Z]+)([0-9]+|\*{1})/;
                  $mod=$1;
                  $n_mod=$2;
                  $flag_ok=0;
                  if($mod eq "PhosphoST"){
	                  ###tag control
	                  if($n_mod eq "\*"){
	                  	$n_mod=0;
	                  }
	                  if($n_phospho==0 && $n_mod==0){
	                  	$flag_ok=0;
	                  }
	                  elsif($n_mod>0 && $n_phospho>0){ #$n_mod>=$n_phospho 
	                  	$flag_ok=1;
	                  }
	              }
               }
           }
       ###}
   }
   return ($flag_ok,$n_mod);
}


################################################################
$path_tool=cwd;
$path_tool=substr($path_tool,0,length($path_tool)-4);
open(SET,"<settings.ini");
$n=0;
while(! eof SET){
  $row=<SET>;
  chomp($row);
  if(index($row,"#")!=0){
    $settings[$n]=$row;
    $n++;  
  }
}
close(SET);
$dir_tmp=$path_tool.'/tmp';
$dir_db=$path_tool.'/db';
$dir_src=$path_tool.'/src';
$dir_data=$path_tool.'/data';
$dir_res=$path_tool.'/results';
chdir($dir_data);

$file_input=$ARGV[0];
if ($file_input eq ""){
  die("Miss input!!!\n");
}
if (! -e $file_input){
  die("File doesn't exit\n");
}
$file_input="<".$file_input;
###Input ASCII file
# input m/z [$file_name]
# output file [$file results]
# mw (if unknown 0) [$weight]
# pi (if unknown 0) [$PI]
# peptide mass tollerance (ex. P 100 or D 1) [$input_toll_prec]
# fragment mass tollerance (ex. P 100 or D 1) [$input_toll_frag]
# lower range [$low]
# upper range [$upp]
# p-value cutoff (0 if you don't want compute it) [$p_cutoff]
# intensity threshold (for the neutral loss detection, eg. 40)
# number of MCs (>=0)
# number of PTMs (>=0)
###
open(INPUT, $file_input);
$n_in=0;
$n_ptm=0;
$n_mc=0;
while(!eof INPUT){
   $data=<INPUT>;
   chomp($data);
   if(index($data,"#")!=0){
      $split_in[$n_in]=$data;
      $n_in++;
   }
}
close(INPUT);
$so=$settings[0]; #operating system
$file_name="<".$split_in[0];
$file_results=$split_in[1];
print "RESULTS FILE $file_results\n";
###
$weight=$split_in[2];
$PI=$split_in[3];
$input_toll=uc($split_in[4]);
$fragm_toll=uc($split_in[5]);
$low=$split_in[6];
$upp=$split_in[7];
$p_cutoff=$split_in[8];
$int_stop_choose=$split_in[9];
$n_mc=$split_in[10];
$n_ptm=$split_in[11];
$state=$split_in[12];
$string_ptm="";
$decoy_flag=$p_cutoff;
#chomp($decoy_flag);
chdir($dir_db);

##Search database
opendir(DB,$dir_db);
@allfiles=readdir(DB);
closedir(DB);
print "\nSelect the search database:\n\n";
$n=0;
for($i=0; $i<@allfiles; $i++){
  $index1=index($allfiles[$i],"\."); 
  $index2=index($allfiles[$i],"_random"); 
  if($index1==-1 && $allfiles[$i] ne "." && $allfiles[$i] ne ".." && $index2==-1){
    $allfiles2[$n]=$allfiles[$i];
    chdir($dir_db."/".$allfiles[$i]);
    open(RF,"<read_file.txt");
    $header=<RF>;
    close(RF);
    print "$n) $allfiles[$i]";
    print " --> $header\n";
    $n++;
  }
}
print "Input: ";
$file_choose=<STDIN>;
chomp($file_choose);
$file_choose=&format_number($file_choose, $n);
$db_choose=$allfiles2[$file_choose];

$dir_db_choose=$dir_db."/".$db_choose;

#if($n_ptm>0){
  chdir($dir_db_choose);
  open(PTM,"<ptm_db.txt");
  $k=0;
  while(!eof PTM){
     $ptm_file=<PTM>;
  	 chomp($ptm_file);
  	 @ptm=split("\t",$ptm_file); 
  	 $ptm_name[$k]=$ptm[0];
  	 $ptm_aa[$k]=$ptm[1];
  	 $ptm_weight_mn[$k]=$ptm[2];
  	 $ptm_weight_av[$k]=$ptm[3]; #average
     $ptm_file_type[$k]=$ptm[4];
     $ptm_tag[$k]=0;
     $k++;
  }
  close(PTM);
  if($n_ptm>0){
#######################  	
    print "The available PTMs are:\n";
    for($i=0;$i<@ptm_name;$i++){
        print "$i $ptm_name[$i]\n";
    }
########################
    $n=@ptm_name;
    for($i=0;$i<$n_ptm;$i++){
      print "Choose the PTM number ".($i+1).":\n";
      $ptm_choose=<STDIN>;
      chomp($ptm_choose);
      $ptm_choose=&number($ptm_choose, $n, 0); 
      #$ptm_choose=$i;
      ###non prendo l'input da tastiera
      $string_ptm=$string_ptm.$ptm_name[$ptm_choose];
      $ptm_tag[$ptm_choose]=1;
      if($ptm_file_type[$ptm_choose] eq "F"){
          $string_ptm=$string_ptm."fix";
      }
      $string_ptm=$string_ptm." ";
    }
  }
  $ptm_string_tag=join("",@ptm_tag); #the first number is not the number of mc
  
#}
if($state==1){
	@ptm_value=@ptm_weight_mn;
}
else{
	@ptm_value=@ptm_weight_av;
}
$protein_file=$db_choose."prot.gz";
#acquisition range
opendir(DB,$dir_db_choose);
@allfiles=readdir(DB);
closedir(DB);
$s=0;
for($i=0;$i<@allfiles;$i++){
  if(index($allfiles[$i],".")==-1){
    $database[$s]=$allfiles[$i];
    $s++;
  }
###DO NOT EDIT - START  
#  if(index($allfiles[$i],"range")!=-1){
#    @split_ac_range=split("_",$allfiles[$i]);
#    $low_range=$split_ac_range[1];
#    @split_ac_range2=split('\.',$split_ac_range[2]);
#    $upp_range=$split_ac_range2[0];
#    $flag_range_db="N";
#    if($low_range!=$low || $upp_range!=$upp){
#        print "Warning!!The acquisition range selected is not equal to the \n";
#        print "database acquisition range (from $low_range to $upp_range Da).\n";
#        print "If you want use the new range, the analysis takes more time.\n";
#        print "Do you want change the acquisition range?(Y/N)?";
#        $flag_range_db=<STDIN>;
#        $flag_range_db=uc($flag_range_db);
#        chomp($flag_range_db);
#        $flag_range_db=&answer($flag_range_db, 0);
#        if($flag_range_db eq "N"){
#          $low=$low_range;
#          $upp=$upp_range;
#        }
#    }
#  }
###DO NOT EDIT - END  
}
chdir($dir_src);
#amino acid molecular weigth
open(AA,"<table_mw.txt");
$k=0;
while(! eof AA){
	$aa_file=<AA>;
	chomp($aa_file);
	if(index($aa_file,"#")!=0){
    @aa_mw=split("\t",$aa_file); 
    $aa[$k]=$aa_mw[0];
    if($state==1){
    	$mw_mn[$k]=$aa_mw[1]; ####$aa_mw[1]; for monoisotopic ####;
    	
    }
    else{
    	$mw_mn[$k]=$aa_mw[2]; ####$aa_mw[1]; $aa_mw[2] for average####;
    }
    for($j=0;$j<@ptm_aa;$j++){
      if($ptm_file_type[$j] eq "F" && $aa[$k]=~/[$ptm_aa[$j]]/){
          $mw_mn[$k]=$mw_mn[$k]+$ptm_value[$j];#####
          last;
      } 
      elsif($ptm_file_type[$j] eq "V" && $aa[$k]=~/[$ptm_aa[$j]]/){
      	$k++;
      	#modified amino acid
      	$mw_mn[$k]=$mw_mn[$k-1]+$ptm_value[$j]; #####
      	$aa[$k]=lc($aa[$k-1]);
		last;
      }
    }
    
    $k++;	
	}
}
close(AA);
$ref_aa=\@aa;
$ref_mw_mn=\@mw_mn;

chdir($dir_db);
###MW and PI controls
$flag_input=0;
if ($weight ne "0"){
  $toll_weight=$weight*$settings[11];
  $w_up=$weight+$toll_weight;
  $w_down=$weight-$toll_weight;
  $flag_input=1;
  if ($w_down<0) {
    $w_down=0;
  }
}
if ($PI ne "0"){
  $toll_pi=$settings[12];
  $pi_up=$PI+$toll_pi;
  $pi_down=$PI-$toll_pi;
  $flag_input=2;
  if ($pi_up>14){
    $pi_up=14;
  }
  if ($pi_down<1){
    $pi_down=1;
  }
}
if($PI ne "0" && $weight ne "0"){
  $flag_input=3;
}
chdir($dir_data);
##intensity threshold
if($int_stop_choose>100){
	$int_stop_choose=100;
}
##mass tolerance
#precursor
@split_toll_prec=split(" ", $input_toll);
#fragment
@split_toll_fragm=split(" ", $fragm_toll);
##
###removes charge from input data
#@array_reference memory addresses
#address-> ions array
#if precursor is out of range --> filtering
#hash_mz{i}-->precursor; i-->$array_reference[$i]
open(MZ, $file_name);
$start_read=0;
$start_write=0;
$k=0;
$r=0;  
$flag=0;
$toll_diff=3;
$flag_rem_cont=0;
$water_value=18.01524; #mono=18.01056 av=18.01524;
$phospho_ptm=79.9799; #mono 79.96631  av 79.9799
$water=116.01024; #mono 115.98756 av 116.01024
$phospho=97.995; #mono 97.977 av 97.995
$nh3_av=17.0306;
$nh3_mn=17.0265;
$h=0;
$separatore="\t";
#normalization
$int_low=1;
$int_upp=100;
while(! eof MZ){
   $data_mz=<MZ>;
   chomp($data_mz);
   if($data_mz eq ""){
   	$flag=0;
   	$flag_rem_cont=0;
   	$separatore="\t";
   	next;
   }
   if($flag==1){
   	$separatore=" ";
   }
   @values_read=split($separatore, $data_mz);
   if($flag==0 && $flag_rem_cont==0){
   	   if($r>0 && $h==0){
   	   	   @sorted_i=0;
   	   	   pop(@sorted_i);
   	   	   #intensity sorted
   	   	   @sorted_i=sort{$int_ion{$b}<=>$int_ion{$a}}keys %int_ion;
   		   $max=$int_ion{$sorted_i[0]};
      	   $min=$int_ion{$sorted_i[@sorted_i-1]};
      	   #normalization
      	   $somma=0;
      	   for($rr=0;$rr<@sorted_i;$rr++){
      	   		if($max==$min){
      	   			$int_ion{$sorted_i[$rr]}=100;
      	   		}
      	   		else{
		  	    	#to the higher peak
		  	    	$int_ion{$sorted_i[$rr]}=100*$int_ion{$sorted_i[$rr]}/$max;
      	   		}
		        $somma=$somma+$int_ion{$sorted_i[$rr]};
		   }
		   $soglia=0;	
		   #print "$hash_mz{$r-1} $mean_int $stdev_int $cutoff_int\n masse scelte\n";
		   $count_phospho=0;
		   $count_water=0;
		   $partenza=$precursor;
		   #$differenza=$phospho_charge;
		   for($rr=0;$rr<@sorted_i;$rr++){
	     	 if($int_ion{$sorted_i[$rr]}<=$soglia){# || ($mean_int+$stdev_int)>15){ #
	     	 	$m_ion_old[$sorted_i[$rr]]=-1;
	     	 	delete($int_ion{$sorted_i[$rr]});
		  	  }
	       }	
########### end peak filtering ###############			   

		   $int_stop=$int_stop_choose; 
		   $count_phospho_tot=0;
	   	   #from monoisotopic to average 
	   	   #y=1.0006393800113x-0.012176250630052
	   	   #$precursor_loss=$precursor;
	   	   $precursor_loss=1.0006393800113*$precursor-0.012176250630052;
	   	   for($tt=1;$tt<5;$tt++){
	   			$uu_old=0;
	   			for($uu=0;$uu<3;$uu++){
	   				if($uu!=($uu_old+1) && $uu!=0){
	   					last;
	   				}
	   				$tipo_loss=$tt."H3PO4_".$uu."H2O";
	   				$water_charge=$water_value/$charge;
	   				$loss=$precursor_loss-($tt*$phospho_charge+$uu*$water_charge);
	   				if($count_phospho_tot<($tt-1)){
	   					last;
	   				}
	   				for($rr=0;$rr<@sorted_i;$rr++){	
	   					if($m_ion_old[$sorted_i[$rr]]>0 && $int_ion{$sorted_i[$rr]}>=$int_stop && $m_ion_old[$sorted_i[$rr]]<$precursor){
							if(($m_ion_old[$sorted_i[$rr]]-$toll_diff_charge)<=$loss && ($m_ion_old[$sorted_i[$rr]]+$toll_diff_charge)>=$loss){
								$count_phospho_tot=$tt;
					   			$uu_old=$uu;
				   				if($count_phospho_tot>1){
			   						$int_stop=5;
				   				}
				   				last;
							}
	   					}	
	   				}	
				}
	   		}			
		   $ss=0;
		   for($rr=0;$rr<@sorted_i;$rr++){
		   	    #phosphorylation control
		   		if($m_ion_old[$sorted_i[$rr]]>0 && ($count_phospho_tot)>=0){ 
		   			if($int_ion{$sorted_i[$rr]}>=0.01){
		   				$m_ion_hash{$ss}=$m_ion_old[$sorted_i[$rr]];
		   				$int_mz{$ss}=sprintf "%.2f", $int_ion{$sorted_i[$rr]};
		   				$ss++;
		   			}
		   		}
		   		delete($int_ion{$sorted_i[$rr]});
		   }
		   @m_ion_old=0;
		   pop(@m_ion_old);
		   if(($count_phospho_tot)>=0){	
			   $ref_mem={%m_ion_hash};
	  		   $array_reference[$r-1]=$ref_mem;
	  		   $ref_mem2={%int_mz};
	  		   $array_reference_int[$r-1]=$ref_mem2;
	  		   $tot_phospho[$r-1]=$count_phospho_tot;
		   }	 
		   else{
		   		delete($hash_mz{$r-1});
		   		delete($hash_charge{$r-1});
		   		delete($hash_scan{$r-1});
		   		$r=$r-1;
		   		if($r<0){
		   			$r=0;
		   		}
		   }  
		   @chiavi=keys(%m_ion_hash);
		   for($rr=0;$rr<@chiavi;$rr++){
		   		delete($m_ion_hash{$chiavi[$rr]});
		   		delete($int_mz{$chiavi[$rr]});
		   }
		   @chiavi=0;
		   pop(@chiavi);

	   }
	   
	   $precursor=$values_read[0];
###DO NOT EDIT - START	   
#		contaminants  
#	   if ($flag_cont!=0){ 
#		    if ($split_toll_prec[0] eq "P"){
#		      $pick_u=$precursor+($precursor*$split_toll_prec[1]*(10**(-6)));
#		      $pick_d=$precursor-($precursor*$split_toll_prec[1]*(10**(-6)));
#		    }
#		    else{
#		      $pick_u=$precursor+$split_toll_prec[1];
#		      $pick_d=$precursor-$split_toll_prec[1];
#		    }
#		    for ($j=0; $j<@array_cont; $j++){
#		      if($array_cont[$j]>=$pick_d && $array_cont[$j]<=$pick_u){
#		          #erase the precursor
#		          $flag=0;
#		          $flag_rem_cont=1;
#		          last;
#		      } 
#		    }
#		}	
###DO NOT EDIT - END
	   if($flag_rem_cont==0){
		   $charge=$values_read[1];
		   $scan_event=$values_read[2];
		   $h=0;
		   if($charge==1 || $charge>4){
		   		$flag_rem_cont=1; #contaminant
		   		$h=1;
		   		next;
		   }
		   $hash_mz{$r}=0;
		   $hash_mz{$r}=$precursor;
		   #neutral m/z
		   $hash_mz{$r}=($hash_mz{$r}*$charge)-$charge;
		   $hash_mz{$r}=sprintf "%.4f", $hash_mz{$r};
		  
		   $hash_charge{$r}=$charge;
		   $hash_scan{$r}=$scan_event;
		   $water_charge=$water/$charge;
		   $phospho_charge=$phospho/$charge;
		   $toll_diff_charge=$toll_diff/$charge;
		   #MH+; filter ions with m/z>MH+
		   $precursor_1=$hash_mz{$r}+1;
		   $r++; 
		   $flag=1;
		   $g=0;
		   next;
	   }
   }
   if($flag==1){
   	  #filtering ions (noise)
   	  if($values_read[0]<$precursor_1){
   	  	$m_ion_old[$g]=$values_read[0];
      	$int_ion{$g}=$values_read[1];
      	$g++;
   	  }
   }
}   
if(-eof MZ){
	$flag=0;
}
if($flag==0 && $flag_rem_cont==0 && $r>0 && $h==0){
	@sorted_i=0;
   	pop(@sorted_i);
   	#intensity sorted
   	   	   @sorted_i=sort{$int_ion{$b}<=>$int_ion{$a}}keys %int_ion;
   		   $max=$int_ion{$sorted_i[0]};
      	   $min=$int_ion{$sorted_i[@sorted_i-1]};
      	   #normalization
      	   $somma=0;
      	   for($rr=0;$rr<@sorted_i;$rr++){
      	   		if($max==$min){
      	   			$int_ion{$sorted_i[$rr]}=100;
      	   		}
      	   		else{
		  	    	#to the higher peak
		  	    	$int_ion{$sorted_i[$rr]}=100*$int_ion{$sorted_i[$rr]}/$max;
      	   		}
		        $somma=$somma+$int_ion{$sorted_i[$rr]};
		   }
		   $soglia=0;	
		   #print "$hash_mz{$r-1} $mean_int $stdev_int $cutoff_int\n masse scelte\n";
		   $count_phospho=0;
		   $count_water=0;
		   $partenza=$precursor;
		   #$differenza=$phospho_charge;
		   for($rr=0;$rr<@sorted_i;$rr++){
	     	 if($int_ion{$sorted_i[$rr]}<=$soglia){# || ($mean_int+$stdev_int)>15){ #
	     	 	$m_ion_old[$sorted_i[$rr]]=-1;
	     	 	delete($int_ion{$sorted_i[$rr]});
		  	  }
	       }	
########### end peak filtering ###############			   

		   $int_stop=$int_stop_choose; 
		   $count_phospho_tot=0;
	   	   #from monoisotopic to average
	   	   #y=1.0006393800113x-0.012176250630052
	   	   #$precursor_loss=$precursor;
	   	   $precursor_loss=1.0006393800113*$precursor-0.012176250630052;
	   	   for($tt=1;$tt<5;$tt++){
	   			$uu_old=0;
	   			for($uu=0;$uu<3;$uu++){
	   				if($uu!=($uu_old+1) && $uu!=0){
	   					last;
	   				}
	   				$tipo_loss=$tt."H3PO4_".$uu."H2O";
	   				$water_charge=$water_value/$charge;
	   				$loss=$precursor_loss-($tt*$phospho_charge+$uu*$water_charge);
	   				if($count_phospho_tot<($tt-1)){
	   					last;
	   				}
	   				for($rr=0;$rr<@sorted_i;$rr++){	
	   					if($m_ion_old[$sorted_i[$rr]]>0 && $int_ion{$sorted_i[$rr]}>=$int_stop && $m_ion_old[$sorted_i[$rr]]<$precursor){
							if(($m_ion_old[$sorted_i[$rr]]-$toll_diff_charge)<=$loss && ($m_ion_old[$sorted_i[$rr]]+$toll_diff_charge)>=$loss){
								$count_phospho_tot=$tt;
					   			$uu_old=$uu;
				   				if($count_phospho_tot>1){
			   						$int_stop=5;
				   				}
				   				last;
							}
	   					}	
	   				}	
				}
	   		}			
		   $ss=0;
		   for($rr=0;$rr<@sorted_i;$rr++){
		   	    #phosphorylation control
		   		if($m_ion_old[$sorted_i[$rr]]>0 && ($count_phospho_tot)>=0){ 
		   			if($int_ion{$sorted_i[$rr]}>=0.01){
		   				$m_ion_hash{$ss}=$m_ion_old[$sorted_i[$rr]];
		   				$int_mz{$ss}=sprintf "%.2f", $int_ion{$sorted_i[$rr]};
		   				$ss++;
		   			}
		   		}
		   		delete($int_ion{$sorted_i[$rr]});
		   }
		   @m_ion_old=0;
		   pop(@m_ion_old);
		   if(($count_phospho_tot)>=0){	
			   $ref_mem={%m_ion_hash};
	  		   $array_reference[$r-1]=$ref_mem;
	  		   $ref_mem2={%int_mz};
	  		   $array_reference_int[$r-1]=$ref_mem2;
	  		   $tot_phospho[$r-1]=$count_phospho_tot;
		   }	 
		   else{
		   		delete($hash_mz{$r-1});
		   		delete($hash_charge{$r-1});
		   		delete($hash_scan{$r-1});
		   		$r=$r-1;
		   		if($r<0){
		   			$r=0;
		   		}
		   }  
		   @chiavi=keys(%m_ion_hash);
		   for($rr=0;$rr<@chiavi;$rr++){
		   		delete($m_ion_hash{$chiavi[$rr]});
		   		delete($int_mz{$chiavi[$rr]});
		   }
		   @chiavi=0;
		   pop(@chiavi);

} 
close(MZ);
@sorted_prec=sort{$hash_mz{$a}<=>$hash_mz{$b}}keys(%hash_mz);
$n_prec=@sorted_prec; #number of precursors
#signals filtering (every 100 peaks --> 50 peaks)
for($i=0;$i<@sorted_prec;$i++){
	$ref_mz=$array_reference[$sorted_prec[$i]];
	$ref_int=$array_reference_int[$sorted_prec[$i]];	
	%hash_mass=%$ref_mz;  
	%int_mass=%$ref_int;  
	@sorted_mz=sort{$hash_mass{$a}<=>$hash_mass{$b}}keys(%hash_mass);
	#bins
	$n_mass=@sorted_mz;
	$picchi=50;
	if($n_mass<200){
		$picchi=50;
	}
	$n_bin=int($n_mass/100);
	if(($n_bin*100)<$n_mass){
		$n_bin=$n_bin+1;
	}
	for($j=0;$j<($n_bin*100);$j=$j+100){
		
		$fine=$j+99;
		if($fine>$n_mass){
			$fine=$n_mass-1;
		}
		@array_bin=@sorted_mz[$j..$fine];
		#50 more intense peaks
		for($kk2=0;$kk2<@keys_int;$kk2++){
			delete($int{$keys_int[$kk2]});
		}	
		for($k=0;$k<@array_bin;$k++){
			$int{$k}=$int_mass{$array_bin[$k]};
		}
		@sorted_int=sort{$int{$b}<=>$int{$a}}keys(%int);
		@int_scelte=@sorted_int[0..($picchi-1)];
		for($k=$picchi;$k<@sorted_int;$k++){
			if($int{$sorted_int[$k]}==$int{$sorted_int[$picchi-1]}){
				push @int_scelte, $sorted_int[$k];
			}
			else{
				delete($int_mass{$array_bin[$sorted_int[$k]]});
				delete($hash_mass{$array_bin[$sorted_int[$k]]});
				delete($int{$sorted_int[$k]});
			}
		}	
		for($k=0;$k<@sorted_int;$k++){
			delete($int{$sorted_int[$k]});
		}	
		@int_scelte=0;
		pop(@int_scelte);
		@int_eliminate=0;
		pop(@int_eliminate);
		@array_bin=0;
		pop(@array_bin);
		@sorted_int=0;
		pop(@sorted_int);
		
	}
	$ref_mem={%hash_mass};
	$array_reference[$sorted_prec[$i]]=$ref_mem;
	$ref_mem2={%int_mass};
	$array_reference_int[$sorted_prec[$i]]=$ref_mem2;
	@sorted_mz=keys(%hash_mass);
	$nn=@sorted_mz;
	for($k=0;$k<@sorted_mz;$k++){
		delete($hash_mass{$sorted_mz[$k]});
		delete($int_mass{$sorted_mz[$k]});
	}
	@sorted_mz=0;
	pop(@sorted_mz);
}
print "Input masses: $n_prec\n";
$last_mass=$hash_mz{$sorted_prec[$n_prec-1]};
if($split_toll_prec[0] eq "P"){
    #ppm -> Da conversion 
    $window=$last_mass*$split_toll_prec[1]*(10**(-6));
    $w_up_last=$last_mass+$window;
    $w_down_first=$hash_mz{$sorted_prec[0]}-$window;
}
elsif($split_toll_prec[0] eq "D"){
   $w_up_last=$last_mass+$split_toll_prec[1];
   $w_down_first=$hash_mz{$sorted_prec[0]}-$split_toll_prec[1];
}
for($i=0;$i<@database;$i++){
	if($database[$i] ne "big_pep"){
		$database[$i]=~tr/_/./;
	}

}
@database=sort{$a<=>$b}@database;#
@control_file=($low,$upp,$w_down_first,$w_up_last);
$first_pep=$database[0];
if($first_pep eq "big_pep"){
  shift(@database);
  @database=sort{$a<=>$b}@database;
  $n_file=@database;
  $database[$n_file]=$first_pep;
}
$ref_db=\@database;
$ref_control=\@control_file;
$ref_file=&db_bound($ref_db,$ref_control);
@file_db=@$ref_file;
# ###
#### DO NOT EDIT - STARTcomputes some score parameters
#$big_delta=$upp-$low; #range
#$delta=$split_toll_prec[1];
#$L=$n_prec;
#$lambda=0; 
#if($split_toll_prec[0] eq "P"){ 
#    for($i=0; $i<$L; $i++){
#        $delta_ppm=$hash_mz{$sorted_prec[$i]}*$delta*(10**(-6));
#        $pl=2*$delta_ppm/$big_delta;
#        $lambda=$lambda+$pl; 
#    }
#}   
#elsif($split_toll_prec[0] eq "D"){
#   $delta=$split_toll_prec[1];
#   $lambda=$L*(2*$delta/$big_delta);
#}
#chdir($dir_db_choose);
##calcolo N
#if($flag_range_db eq "Y"){
#   for($p=$file_db[0];$p<=$file_db[1];$p++){
#   	   $database[$p]=~tr/./_/;
#   	   open(FILE,"<".$database[$p]);#
#       while(!eof FILE){
#           $row=<FILE>;
#           @split_row=split("\t",$row);
#           $prot=$split_row[0];
#           $mass_db=$split_row[2];
#           $id_pep=$split_row[1];
#           ($flag_ok,$mass_tag,$ref_ptm_framm,$cod_tag)=&tag_control($ptm_string_tag,$id_pep);
#           if($flag_ok==1){
#              if($mass_db>=$low && $mass_db<=$upp){ 
#                  $hash_N{$prot}=$hash_N{$prot}+1;
#              }
#           }
#       } #while
#       close(FILE);
#   }
#}  
###DO NOT EDIT - END
$start_db=0;
$flag_exit=0;
chdir($dir_db_choose);
$start_time=time;
#$phospho_ptm=79.96631; #mono 79.96631  av 79.9799
for($m=0;$m<$n_prec;$m++){
	$start_db=0;
	$charge=$hash_charge{$sorted_prec[$m]};
	print "input $m $hash_mz{$sorted_prec[$m]} neutral loss $tot_phospho[$sorted_prec[$m]] scan $hash_scan{$sorted_prec[$m]}\n";
	if($split_toll_prec[0] eq "P"){
          #ppm -> Da conversion 
          $window=$hash_mz{$sorted_prec[$m]}*$split_toll_prec[1]*(10**(-6));
          $w_up2=$hash_mz{$sorted_prec[$m]}+$window;
          $w_down2=$hash_mz{$sorted_prec[$m]}-$window;
    }
    elsif($split_toll_prec[0] eq "D"){
          $w_up2=$hash_mz{$sorted_prec[$m]}+$split_toll_prec[1];
          $w_down2=$hash_mz{$sorted_prec[$m]}-$split_toll_prec[1];
    }
   
   	###
   	#delete the hashes
	#bin di 100
	$range_pep=100+(100*(int($w_down2/100)));
	if($range_pep!=$range_pep_old){
		#delete hash_fragmented and $hash_combinazioni
		@chiavi_el=keys(%hash_fragmented);
		@chiavi_el2=keys(%hash_combinazioni);
		for($j=0;$j<@chiavi_el;$j++){
			delete($hash_fragmented{$chiavi_el[$j]});
		}
		for($j=0;$j<@chiavi_el2;$j++){
			delete($hash_combinazioni{$chiavi_el2[$j]});
		}
	}
   	$range_pep_old=$range_pep;
   	###
    $ref_mz=$array_reference[$sorted_prec[$m]];
    %hash_mass=%$ref_mz;  
    $ref_int=$array_reference_int[$sorted_prec[$m]];
    
	for($p=$file_db[2];$p<=$file_db[3];$p++){
		
        $stop_db=$database[$p];
        $stop_db=~tr/_/./;
        $start_db=~tr/_/./;
       
        if(($w_down2<=$stop_db && $w_up2>=$start_db) || ($stop_db eq "big.pep")){
        	
        		$database[$p]=~tr/./_/;
        	    open(FILE,"<".$database[$p]);
        	    
        	    while(!eof FILE){
        	    	%hash_mass=%$ref_mz;
        	    	%int_mass=%$ref_int;
        	    	$score=0; 
                	$row=<FILE>;
                    @split_row=split("\t",$row);
                    $prot=$split_row[0];
                    if($decoy_flag==0 && $prot=~/Decoy/){
                    	next;
                    }
                    $id_pep=$split_row[1];
                    $mass_db=$split_row[2];
                    $delta_mass=$hash_mz{$sorted_prec[$m]}-$mass_db;
                    $delta_mass_plus=0;
                    if($mass_db>$w_up2){	
                        last;
                    }
                    if(abs($delta_mass)>$hash_delta{$prot."_".$sorted_prec[$m]} && exists($hash_delta{$prot."_".$sorted_prec[$m]})==1){
                    	#delta mass filtering	
                    	#last;
                    }
                    $seq_aa=$split_row[3];
                    $start=$split_row[4];
                    $stop=$split_row[5];
                    chomp($stop);
                    @ptm_fragm=0;
                    pop(@ptm_fragm);
                    ($flag_ok,$delta_mass_plus,$cod_tag,@ptm_fragm)=&tag_control($ptm_string_tag,$id_pep);
                    
                    #################
                    if($flag_ok==1){  
                    	#$n_mod_phospho: peptide phosphorylations 
                    	($flag_ok,$n_mod_phospho)=&phospho_control($id_pep,$tot_phospho[$sorted_prec[$m]]);	
                    }
                    else{
                    	next;
                    }
                    #################
                    $tot_aa=length($seq_aa);
                    if($hash_flag_R{$prot."_".$m} eq ""){
                    	$hash_flag_R{$prot."_".$m}=0;
                    }
                    
                    ###################################	 
                    if($flag_ok==1 && $tot_phospho[$sorted_prec[$m]]>0){
                    }
                    else{
                    	next;
                    }
                    if($flag_ok==1){ 
					  if($mass_db>=$low && $mass_db<=$upp && $mass_db>=$w_down2 && $mass_db<=$w_up2){ 
                       	  #existing match
                       	  if(exists($hash_match_pep{$sorted_prec[$m]."_".$seq_aa."_".$n_mod_phospho})){
                       	   	 @keys_results=keys(%hash_results);
                       	   	 @keys_results=sort(@keys_results);
                       	   	 for($kk3=0;$kk3<@keys_results;$kk3++){
                       	   	 	$keys_results[$kk3]=~/^(\w+)(\_{1})(\d+)(\_{1})(\d+)$/;
                       	   	 	$seq_letta=$1;
                       	   	 	$prec_letto=$3;
                       	   	 	if(uc($seq_letta) eq $seq_aa && $prec_letto==$sorted_prec[$m]){
                       	   	 		$n_st=($seq_letta=~s/[st]/[st]/g);
                       	   	 		if($n_st == $n_mod_phospho){
                       	   	 			$nuova_chiave=$seq_letta."_".$prec_letto."_".$prot;
                       	   	 			$hash_results{$nuova_chiave}=$hash_results{$keys_results[$kk3]};
                       	   	 			$hash_results{$nuova_chiave}=~s/(\d+)(\t)(\d+)(\n)(\t)/$start\t$stop\n\t/;
                       	   	 			$hash_R{$prot}++;
                       	   	 		}
                       	   	 	}
                       	   	 }
                       	   	 next;
                       	  }
                       	  if(exists($hash_combinazioni{$seq_aa."_".$n_mod_phospho})){
                       	  	 $ref_array_comb=$hash_combinazioni{$seq_aa."_".$n_mod_phospho};
                       	  	 @array_comb_aa=@$ref_array_comb;
                       	   	 goto "NO_FRAGM";
                       	  }
               	  	      #fragmentation
               	  	      @mw_ion=0;
						  pop(@mw_ion);
						  @keys_ioni=keys(%ioni);
						  for($kk=0; $kk<@keys_ioni; $kk++){
						   	delete($ioni{$keys_ioni[$kk]});
						  }
						  $seq_aa_temp=$seq_aa;
      					  $number_aa_pep=($seq_aa_temp=~s/[ST]/[ST]/g);
      					  if($number_aa_pep eq ""){
      					  	$number_aa_pep=0;
      					  }
      					  @array_comb_aa=0;
					      pop(@array_comb_aa);
					      if($n_mod_phospho==$number_aa_pep){
      				      	 $seq_aa_temp=$seq_aa;
      				      	 if($n_mod_phospho!=0){
	      						 #ST	
	      				         $seq_aa_temp=~s/S/s/g;
						         $seq_aa_temp=~s/T/t/g;
						     }
							 $array_comb_aa[0]=$seq_aa_temp;
      				      }	
						  else{
					      	@array_combinazioni=0;
					      	pop(@array_combinazioni);
					      	$combination=2**($number_aa_pep);
					      	for($kk=0; $kk<$combination; $kk++){
					      		$bit="";
                    			$bit=sprintf("%b",$kk);
                    			$n_bit=($bit=~s/1/1/g); 
                    			if($n_bit eq ""){
                    				$n_bit=0;
                    			}
                    			$stringa_p="";
                    			$new_string="";
                    			if($n_bit==$n_mod_phospho){
                    				$start_aa=0;
                    				$seq_aa_temp=$seq_aa;
                    				for($kk3=0;$kk3<$number_aa_pep;$kk3++){
					                	$seq_aa_temp=~/([ST])/;
					                	$index_aa=index($seq_aa,$1,$start_aa); 
					                	$shift_aa=$index_aa+1-$start_aa;
					                	$sub_aa=substr($seq_aa,$start_aa,$shift_aa);
					                    $array_combinazioni[$kk3]=$sub_aa; 
					                    $start_aa=$index_aa+1;
					                    $seq_aa_temp=substr($seq_aa,$start_aa,length($seq_aa)-$start_aa);
					                    $start_bit=0;
					                }
					                if($start_aa<length($seq_aa)){ 
					                    $shift_aa=length($seq_aa)-$index_aa;
					                    $sub_aa=substr($seq_aa,$start_aa,$shift_aa);
					                    $array_combinazioni[$kk3]=$sub_aa;
					                	$start_bit=1;
                    				} 
					                $dim_array=@array_combinazioni;
					                if((length($bit)+$start_bit)<$dim_array){
					                	for($qq=0;$qq<($dim_array-length($bit)-$start_bit);$qq++){
					                		$new_string=$new_string.$array_combinazioni[$qq];
					                	}	
					                }
					                $pos=$dim_array-length($bit)-$start_bit;
							        for($qq=0;$qq<length($bit);$qq++){
							             $split_bit=substr($bit,$qq,1);
							         	 $stringa_p=$array_combinazioni[$pos];
							         	 if($split_bit==1){
							               $array_combinazioni[$pos]=~/([ST])/;
							               $letter=$1;
							               $lower=lc($letter);
							               $stringa_p=~s/$letter/$lower/g;
							            }
							            $new_string=$new_string.$stringa_p;
							            $pos++;
							        }
				                    if($start_bit==1){
				                    	$new_string=$new_string.$array_combinazioni[$dim_array-1];
				                    } 
				                    push(@array_comb_aa,$new_string);
				                } #if n_bit
					      	} #for $kk
					      	
					      }#else 
					      $ref_array_comb=[@array_comb_aa];	
					      
						  $hash_combinazioni{$seq_aa."_".$n_mod_phospho}=$ref_array_comb;
						  for($kk3=0;$kk3<@array_comb_aa;$kk3++){
						  	  $seq_read=$array_comb_aa[$kk3];
						  	  $seq_aa_y=reverse($seq_read);
						  	  $mass_db_av=&molecular_weight($seq_read,$ref_aa,$ref_mw_mn,$state);
						  	  if($seq_read=~/[STstDE]/ ){ # [STsDE]
						  	  	 
						  	  	 $seq_SsDE=$seq_read;
						  	  	 $n_SsDE=($seq_SsDE=~s/[STstDE]/[STstDE]/g); #[STsDE]
						  	  	 #mass-H2O
						  	  	 ###
						  	  	 #stop 2 H2O
						  	  	 if($n_SsDE>1){
							  	  		$n_SsDE=2;
							  	 }
							  	 ###
							     for($kk=1;$kk<=$n_SsDE;$kk++){
								    $ioni{"M".$kk."h2o_0_1"}=1+$mass_db_av-$kk*($water_value); #1+
								    $ioni{"M".$kk."h2o_0_2"}=($ioni{"M".$kk."h2o_0_1"}+1)/2; #2+
								    $ioni{"M".$kk."h2o_0_3"}=($ioni{"M".$kk."h2o_0_1"}+2)/3; #3+
								    $ioni{"M".$kk."h2o_0_4"}=($ioni{"M".$kk."h2o_0_1"}+3)/4; #4+
								 }
							  	 #loss of phosphoric acid
							  	 for($kk2=1;$kk2<=$n_mod_phospho;$kk2++){
							  	 	for($kk=0;$kk<=$n_SsDE;$kk++){
							  		 	$ioni{"M".$kk."h2o_0_1_".$kk2."p"}=1+$mass_db_av-($kk2*$phospho+$kk*($water_value));
								  	 	$ioni{"M".$kk."h2o_0_2_".$kk2."p"}=($ioni{"M".$kk."h2o_0_1_".$kk2."p"}+1)/2;
								  	 	$ioni{"M".$kk."h2o_0_3_".$kk2."p"}=($ioni{"M".$kk."h2o_0_1_".$kk2."p"}+2)/3;
								  	 	$ioni{"M".$kk."h2o_0_4_".$kk2."p"}=($ioni{"M".$kk."h2o_0_1_".$kk2."p"}+3)/4;
								  	}
							  	 }
						  	  }	
						  	 #ammonia
						  	 if($seq_read=~/[KRQN]/ ){ # 
						  	  	 
						  	  	 $seq_krqn=$seq_read;
						  	  	 $n_krqn=($seq_krqn=~s/[KRQN]/[KRQN]/g); 
						  	  	 #mass-nh3
						  	  	 ###
						  	  	 #stop 2 nh3
						  	  	 if($n_krqn>1){
							  	  		$n_krqn=2;
							  	 }
							  	 ###
							     for($kk=1;$kk<=$n_krqn;$kk++){
								    $ioni{"M".$kk."nh3_0_1"}=1+$mass_db_av-$kk*($nh3_av); #1+
								    $ioni{"M".$kk."nh3_0_2"}=($ioni{"M".$kk."nh3_0_1"}+1)/2; #2+
								    $ioni{"M".$kk."nh3_0_3"}=($ioni{"M".$kk."nh3_0_1"}+2)/3; #3+
								    $ioni{"M".$kk."nh3_0_4"}=($ioni{"M".$kk."nh3o_0_1"}+3)/4; #4+
								 }
							  	 #loss of phosphoric acid
							  	 #DO NOT EDIT - START
#							  	 for($kk2=1;$kk2<=$n_mod_phospho;$kk2++){
#							  	 	for($kk=0;$kk<=$n_krqn;$kk++){
#							  		 	$ioni{"M".$kk."nh3_0_1_".$kk2."p"}=1+$mass_db_av-($kk2*$phospho+$kk*($nh3_av));
#								  	 	$ioni{"M".$kk."nh3_0_2_".$kk2."p"}=($ioni{"M".$kk."nh3_0_1_".$kk2."p"}+1)/2;
#								  	 	$ioni{"M".$kk."nh3_0_3_".$kk2."p"}=($ioni{"M".$kk."nh3_0_1_".$kk2."p"}+2)/3;
#								  	 	$ioni{"M".$kk."nh3_0_4_".$kk2."p"}=($ioni{"M".$kk."nh3_0_1_".$kk2."p"}+3)/4;
#								  	}
#							  	 }
								 #DO NOT EDIT - END
						  	  }	
						  	  #ammonia end
						  	  
	 				          for($kk=0; $kk<$tot_aa-1; $kk++){ 
							     #b ions
							     $aa_ione=substr($seq_read,0,$kk+1);
							     $ind1=$kk+1;
							     #y ions
							     $ind2=$tot_aa-length($aa_ione); 
							     $aa_ione_y=substr($seq_aa_y,0,$ind2);
							     $massa_ione=&molecular_weight($aa_ione,$ref_aa,$ref_mw_mn,$state); 
							     $ioni{"b_".$ind1."_1"}=$massa_ione-$water_value+1; #1+ #monoisotopic water							     #ioni y
							     $ioni{"y_".$ind2."_1"}=$mass_db_av-$ioni{"b_".$ind1."_1"}+2; #1+
							    
							     #2,3,4+
					       		$ioni{"b_".$ind1."_2"}=($ioni{"b_".$ind1."_1"}+1)/2; #2+
					       		$ioni{"y_".$ind2."_2"}=($ioni{"y_".$ind2."_1"}+1)/2; #2+
					      		$ioni{"b_".$ind1."_3"}=($ioni{"b_".$ind1."_1"}+2)/3; #3+
					      		$ioni{"y_".$ind2."_3"}=($ioni{"y_".$ind2."_1"}+2)/3; #3+
				      			$ioni{"b_".$ind1."_4"}=($ioni{"b_".$ind1."_1"}+3)/4; #4+
				      			$ioni{"y_".$ind2."_4"}=($ioni{"y_".$ind2."_1"}+3)/4; #4+
							    #loss of water
							    #b
					        	if($aa_ione=~/[STstDE]/ ){
					        	 	#loss of phosphoric acid
						  	  	    $seq_phospho=$aa_ione;
							     	$count_phospho=($seq_phospho=~s/[st]/[st]/g);
						  	  	    if($count_phospho eq ""){
							     		$count_phospho=0;
							     	}
					        	 	$seq_SsDE=$aa_ione;
						  	  	    $n_SsDE=($seq_SsDE=~s/[STstDE]/[STstDE]/g); #[STsDE]
						  	  	    if($n_SsDE>1){
							  	  		$n_SsDE=2;
							  	  	}
							  	  	###
							  	  	if($n_SsDE>0){
							  	  	    for($kk2=1;$kk2<=$n_SsDE;$kk2++){
							     	     	 for($kk4=0;$kk4<=$count_phospho;$kk4++){
										     	$ioni{"b".$kk2."h2o_".$ind1."_1_".$kk4."p"}=$ioni{"b_".$ind1."_1"}-($kk2*$water_value+$kk4*$phospho); #H2O b 
								              	$ioni{"b".$kk2."h2o_".$ind1."_2_".$kk4."p"}=$ioni{"b_".$ind1."_2"}-($kk2*$water_value/2+$kk4*$phospho/2); #H2O b 2
								              	$ioni{"b".$kk2."h2o_".$ind1."_3_".$kk4."p"}=$ioni{"b_".$ind1."_3"}-($kk2*$water_value/3+$kk4*$phospho/3); #H2O b 3
								              	$ioni{"b".$kk2."h2o_".$ind1."_4_".$kk4."p"}=$ioni{"b_".$ind1."_4"}-($kk2*$water_value/4+$kk4*$phospho/4); #H2O b 4
								             }
								     	} 
							  	  	}	
					        	 }
					        	 #y
							     if($aa_ione_y=~/[STstDE]/){
					        	 	#loss of phosphoric acid
						  	  	    $seq_phospho=$aa_ione_y;
							     	$count_phospho=($seq_phospho=~s/[st]/[st]/g);
						  	  	    if($count_phospho eq ""){
							     		$count_phospho=0;
							     	}
							     	$seq_SsDE=$aa_ione_y;
						  	  	    $n_SsDE=($seq_SsDE=~s/[STstDE]/[STstDE]/g); #[STsDE][STstDE]
						  	  	    ###
							  	  	if($n_SsDE>1){
							  	  		$n_SsDE=2;
							  	  	}
							  	  	###
						  	  	    if($n_SsDE>0){
							     	     for($kk2=1;$kk2<=$n_SsDE;$kk2++){
							     	     	 for($kk4=0;$kk4<=$count_phospho;$kk4++){
										        $ioni{"y".$kk2."h2o_".$ind2."_1_".$kk4."p"}=$ioni{"y_".$ind2."_1"}-($kk2*$water_value+$kk4*$phospho); #H2O y
								           		$ioni{"y".$kk2."h2o_".$ind2."_2_".$kk4."p"}=$ioni{"y_".$ind2."_2"}-($kk2*$water_value/2+$kk4*$phospho/2); #H2O y 2 
								       			$ioni{"y".$kk2."h2o_".$ind2."_3_".$kk4."p"}=$ioni{"y_".$ind2."_3"}-($kk2*$water_value/3+$kk4*$phospho/3); #H2O y 3 
								    			$ioni{"y".$kk2."h2o_".$ind2."_4_".$kk4."p"}=$ioni{"y_".$ind2."_4"}-($kk2*$water_value/4+$kk4*$phospho/4); #H2O y 4 
								            }
							        	}
							  	  	}     	
					        	 }
					        	 #b
							     if($aa_ione=~/[st]/){
							     	$seq_phospho=$aa_ione;
							     	$count_phospho=($seq_phospho=~s/[st]/[st]/g);
							     	if($count_phospho eq ""){
							     		$count_phospho=0;
							     	}
							     	if($count_phospho>0){
							     	 	for($kk2=1;$kk2<=$count_phospho;$kk2++){
								     		$ioni{"b_".$ind1."_1_".$kk2."p"}=$ioni{"b_".$ind1."_1"}-($kk2*$phospho);
								   			$ioni{"b_".$ind1."_2_".$kk2."p"}=$ioni{"b_".$ind1."_2"}-($kk2*$phospho/2);
											$ioni{"b_".$ind1."_3_".$kk2."p"}=$ioni{"b_".$ind1."_3"}-($kk2*$phospho/3);
											$ioni{"b_".$ind1."_4_".$kk2."p"}=$ioni{"b_".$ind1."_4"}-($kk2*$phospho/4);
								     	}
							     	}
							     	
							     }
							     #y ion
							     if($aa_ione_y=~/[st]/){
							     	$seq_phospho=$aa_ione_y;
							     	$count_phospho=($seq_phospho=~s/[st]/[st]/g);
							     	if($count_phospho eq ""){
							     		$count_phospho=0;
							     	}
							     	if($count_phospho>0){
								     	for($kk2=1;$kk2<=$count_phospho;$kk2++){
								     		$ioni{"y_".$ind2."_1_".$kk2."p"}=$ioni{"y_".$ind2."_1"}-($kk2*$phospho);
								   			$ioni{"y_".$ind2."_2_".$kk2."p"}=$ioni{"y_".$ind2."_2"}-($kk2*$phospho/2);
											$ioni{"y_".$ind2."_3_".$kk2."p"}=$ioni{"y_".$ind2."_3"}-($kk2*$phospho/3);
											$ioni{"y_".$ind2."_4_".$kk2."p"}=$ioni{"y_".$ind2."_4"}-($kk2*$phospho/4);
								     	}
							     	}	
							     	
							     }	
							  }#for ions	
							  $ref_hash_ioni={%ioni}; 
							  $hash_fragmented{$seq_read}=$ref_hash_ioni;
							  @keys_ioni=keys(%ioni);
							  for($kk=0; $kk<@keys_ioni; $kk++){
							  	   delete($ioni{$keys_ioni[$kk]});
						  	  }
							  #fragmentation end
						  } #$kk3	
				NO_FRAGM:   
						  $score_old=0;	
						  $conta_fraz=0;
						  $conta_fraz_old=0;
						  @sorted_mz_int=0;
						  pop(@sorted_mz_int);
                          @sorted_mz_int=sort{$int_mass{$b}<=>$int_mass{$a}}keys(%int_mass);
                          $picco_soglia=0;
                          $picco_soglia=$int_mass{$sorted_mz_int[9]};
                          $soglia_seq=$int_mass{$sorted_mz_int[int($#sorted_mz_int/3)]}; #threshold
                          for($kk3=0;$kk3<@array_comb_aa;$kk3++){
						  		@array_b_seq=0;
		                        pop(@array_b_seq);
		                        @array_y_seq=0;
		                        pop(@array_y_seq);
						  		@keys_ioni=keys(%ioni);
							  	for($kk=0; $kk<@keys_ioni; $kk++){
							   		delete($ioni{$keys_ioni[$kk]});
							  	}
						  		$seq_read=$array_comb_aa[$kk3];
								$ref_hash_ioni=$hash_fragmented{$seq_read};
						        %ioni=%$ref_hash_ioni;
						  		@sorted_fragm=0;
						  		pop(@sorted_fragm);
						  		@sorted_fragm=sort{$ioni{$a}<=>$ioni{$b}}keys(%ioni);  
						  		@array_match=0;
						  		pop(@array_match);
						  		$score=0;
						  		$conta_intensi=0;
						  		$stringa_match="";
                          		@array_mz=0;
						  		pop(@array_mz);
						  		@int_value=0;
						  		pop(@int_value);
						  		for($j=0;$j<@sorted_mz_int;$j++){
                          			$array_mz[$j]=$hash_mass{$sorted_mz_int[$j]};
                          			$int_value[$j]=$int_mass{$sorted_mz_int[$j]};
						  		}	
						  		@ioni_theo=0;
						  		pop(@ioni_theo);
						  		@array_indici_match=0;
						  		pop(@array_indici_match);
						  		for($j=0;$j<@sorted_fragm;$j++){
						  			$ioni_theo[$j]=$ioni{$sorted_fragm[$j]};
						  			$array_indici_match[$j]=-1;
						  		}	
						  		$dim_in=@ioni_theo;
						  		$dim_conf=@array_mz;
						  		if(exists($hash_dim_ioni{$array_comb_aa[$kk3]})==0){
						  			$hash_dim_ioni{$array_comb_aa[$kk3]}=$dim_in;
						  		}
						  		#search the compiled files compare or compare_win
						  		chdir($dir_src);
						  		if(-e 'compare' || -e 'compare_win.exe'){
						  			if($so eq "LINUX"){
						  				$indici_match=`./compare $split_toll_fragm[1] $dim_in $dim_conf @ioni_theo @array_mz`;
						  			}
						  			else{
						  				$indici_match=`./compare_win $split_toll_fragm[1] $dim_in $dim_conf @ioni_theo @array_mz`;
						  			}
						  			@array_indici_match=split("\t",$indici_match);
						  			chdir($dir_db_choose);
						  		}
						  		else{
						  			chdir($dir_db_choose);
							  		for($j=0;$j<@sorted_mz_int;$j++){
	                          			if($split_toll_fragm[0] eq "P"){
			                               #ppm -> Da conversion 
			                               $window_fragm=$array_mz[$j]*$split_toll_fragm[1]*(10**(-6));
			                               $array_toll_up=$array_mz[$j]+$window_fragm;
			                               $array_toll_down=$array_mz[$j]-$window_fragm;
		                                }
		                                else{
			                               $array_toll_up=$array_mz[$j]+$split_toll_fragm[1];
			                               $array_toll_down=$array_mz[$j]-$split_toll_fragm[1];
		                                }
		                                for($kk=0;$kk<@sorted_fragm;$kk++){
		                                	if($array_match[$kk]==1){
						                       	 	next;
						                    }
						                    if($ioni{$sorted_fragm[$kk]}>=$hash_mz{$sorted_prec[$m]}){
				                           		next;
				                           	}
		                                	@split_id_fragm=split("_",$sorted_fragm[$kk]);
		                                	
		                                	$carica_ione=$split_id_fragm[2];
					                        if($split_id_fragm[0]=~/M/ && $carica_ione!=$charge){
				                           	 	next;
				                           	}
				                           	
					                        if($carica_ione>$charge || $ioni{$sorted_fragm[$kk]}<=0){
				                           		next;
				                           	}
				                           	if($array_toll_down<=$ioni{$sorted_fragm[$kk]} && $array_toll_up>=$ioni{$sorted_fragm[$kk]}){       
								            	$array_match[$kk]=1;	
								             	$array_indici_match[$kk]=$j;
								             	last; #exit from $kk
				                            }
		                               	} #kk
		                                	#	
		                            } #j
						  		} #exists compare or compare_win
						  		for($j=0;$j<@array_indici_match;$j++){
						  			if($array_indici_match[$j]==-1){
						  				next; 
						  			}
						  			@split_id_fragm=split("_",$sorted_fragm[$j]);
		                            $carica_ione=$split_id_fragm[2];
			                        if($split_id_fragm[0]=~/M/ && $carica_ione!=$charge){
	                           	 		next;
		                           	}
			                        if($carica_ione>$charge || $ioni_theo[$j]<=0){
		                           		
		                           		next;
		                           	} 
		                           	$stampa_ione=sprintf "%.4f", $ioni_theo[$j];
		                            
		                           	$stringa_match=$stringa_match."\t\t$sorted_fragm[$j]\t$array_mz[$array_indici_match[$j]]\t$stampa_ione\t$int_value[$array_indici_match[$j]]\n";
							        $den=1+exp(-$int_value[$array_indici_match[$j]]);
							        $score=$score+(-1+(2/$den));
							        ####
                          			if($int_value[$array_indici_match[$j]]>=$picco_soglia){
						               	$conta_intensi=$conta_intensi+1;
						            }
						  		}
                          		$conta_fraz=$conta_intensi/10;
                          		$n_aa_seq=length($seq_aa);
                          		if(($score)>=$score_old ){ 
	                                $hash_punti{$kk3}=$score;
	                          		$chiave_hash_pep=$sorted_prec[$m]."_".$seq_aa."_".$n_mod_phospho;
	                          		$hash_match_pep{$chiave_hash_pep}=$score; 
	                          		$hash_phospho{$kk3."_".$sorted_prec[$m]."_".$seq_aa}=$array_comb_aa[$kk3];
	                          		$chiave_hash_stringa=$kk3."_".$sorted_prec[$m]."_".$seq_aa;
	                          		@separa_stringa=split("\t\t",$stringa_match);
	                          		$numero_ioni=@separa_stringa; 
	                          		$numero_ioni=$numero_ioni-1;
	                          		for($kkk=0;$kkk<@separa_stringa;$kkk++){
	                          			@split_stringa2=split("\t",$separa_stringa[$kkk]);
	                          			$hash_massa_stringa{$kkk}=$split_stringa2[1];
	                          		}
	                          		@sorted_stringa=0;
	                          		pop(@sorted_stringa);
	                          		@sorted_stringa=sort{$hash_massa_stringa{$a}<=>$hash_massa_stringa{$b}}keys(%hash_massa_stringa);
	                          		$stringa_match="$separa_stringa[$sorted_stringa[0]]";
	                          		for($kkk=1;$kkk<@sorted_stringa;$kkk++){
	                          			$stringa_match=$stringa_match."\t\t".$separa_stringa[$sorted_stringa[$kkk]];
	                          			delete($hash_massa_stringa{$sorted_stringa[$kkk]});
	                          		}
	                          		####
	                          		$hash_stringa_match{$chiave_hash_stringa}=$stringa_match;
	                          		
	                          		$conta_fraz=$conta_intensi/10;
	                          		$score_old=$score;
	                          	    $conta_fraz_old=$conta_fraz;
	                          			
	                          		$hash_fraz_pep{$chiave_hash_pep}=$conta_fraz;
	                          		$hash_numero_match{$chiave_hash_pep}=$numero_ioni;
	                          	}
                          }#$kk3
                   MATCH: 
                   		  if($score>0){
                   		  	 @sorted_punti=0;
                          	 pop(@sorted_punti);
                          	 @sorted_punti=sort{$hash_punti{$b}<=>$hash_punti{$a}}keys(%hash_punti);
                          	 $chiave=$sorted_punti[0]."_".$sorted_prec[$m]."_".$seq_aa;
                          	 for($kkk=1;$kkk<@sorted_punti;$kkk++){
                          	 	if($hash_punti{$sorted_punti[$kkk]}<$hash_punti{$sorted_punti[0]}){
                          			$chiave=$sorted_punti[$kkk]."_".$sorted_prec[$m]."_".$seq_aa;
                          			$chiave3=$hash_phospho{$chiave}."_".$sorted_prec[$m]."_".$prot;
						  			delete($hash_punti{$sorted_punti[$kkk]});
						  			delete($hash_phospho{$chiave});
                          			delete($hash_stringa_match{$chiave});
                          			delete($hash_results{$chiave3});
                          		}	
                         	 }
                          	 $hash_R{$prot}++;
                          	 $hash_flag_R{$prot."_".$m}=$hash_flag_R{$prot."_".$m}+1;
                          	 $scelta=$hash_flag_R{$prot."_".$m}+1;
                          	 @keys_punti=0;
                   		  	 pop(@keys_punti);
                          	 @keys_punti=keys(%hash_punti);
                          	 $chiave2=$sorted_prec[$m]."_".$seq_aa."_".$n_mod_phospho;	
						  	 for($kkk1=0;$kkk1<@keys_punti;$kkk1++){
						  	 	$kkk=$keys_punti[$kkk1];
                          		$chiave=$kkk."_".$sorted_prec[$m]."_".$seq_aa;
                          		$chiave3=$hash_phospho{$chiave}."_".$sorted_prec[$m]."_".$prot;
                          		$hash_keys_results{$prot}=$hash_keys_results{$prot}."\t".$chiave3; # for MW and PI filtering
                          		$hash_results{$chiave3}="Peptide $hash_phospho{$chiave}\tMass: $hash_mz{$sorted_prec[$m]}\tCharge: $charge\tScan: $hash_scan{$sorted_prec[$m]}\t";
                          		$hash_delta{$prot."_".$sorted_prec[$m]}=abs($delta_mass);
                          		$delta_mass=sprintf "%.4f",$delta_mass;
                          		$n_ioni=$hash_dim_ioni{$hash_phospho{$chiave}};
                          		$hash_results{$chiave3}=$hash_results{$chiave3}."Mass db: $mass_db\tDelta mass: $delta_mass\tRatio: $hash_fraz_pep{$chiave2}\tIons: $n_ioni\tPosition: $start\t$stop\n\t";
                          		if(index($hash_match_pep{$chiave2},".")<0){
                          			$hash_match_pep{$chiave2}=$hash_match_pep{$chiave2}.".0";
                          		}
                          		$hash_match_pep{$chiave2}=sprintf "%.2f", $hash_match_pep{$chiave2};
                          		$hash_results{$chiave3}=$hash_results{$chiave3}."Ions matched: $hash_numero_match{$chiave2}\tScore: $hash_match_pep{$chiave2}\n";
                          		$hash_results{$chiave3}=$hash_results{$chiave3}."$hash_stringa_match{$chiave}\n";
                          		
                          		delete($hash_punti{$keys_punti[$kkk1]});
                          		delete($hash_stringa_match{$chiave});
                          		delete($hash_phospho{$chiave});
                          	}
                          }
                          @keys_punti=keys(%hash_punti);
                          for($kkk1=0;$kkk1<@keys_punti;$kkk1++){
                          	delete($hash_punti{$keys_punti[$kkk1]});
                          }	
                      } #if mass_db
                   }#if flag ok  
             } #while
             close(FILE);
        }###match if
       $start_db=$stop_db;  
    }  #ciclo for
    @chiavi_mass=keys(%hash_mass);
    for($i=0;$i<@chiavi_mass;$i++){
    	delete($hash_mass{$chiavi_mass[$i]});
    	delete($int_mass{$chiavi_mass[$i]})
    }
   
    if($flag_exit==1){
      last;
    }
}
@keys_flag=keys(%hash_flag_R);
for($i=0;$i<@keys_flag;$i++){
  delete($hash_flag_R{$keys_flag[$i]});
}
# ###
###DO NOT EDIT - START
#chdir($dir_db_choose);
# if($flag_range_db eq "N"){
#   $p=0;
#   open(NFILE,"<range_".$low_range."_".$upp_range.".txt");
#   $row=<NFILE>;
#   chomp($row);
#   #select the columns to read 
#   @split_row=split("\t",$row);
#   $k=0;
#   for($i=0;$i<@split_row;$i++){
#     $column=$split_row[$i];  
#     $mc_column=substr($column,0,1);
#     if($mc_column<=$n_mc){
#        $string_bit=substr($column,1,length($column)-1);
#        $diff_bit=$ptm_string_tag-$string_bit;
#        if(($diff_bit>=0 && index($diff_bit,"9")==-1)||($ptm_file_type[$k] eq "F" && $ptm_tag[$k]==0)){
#           $array_bit[$k]=$i; 
#           $k++;
#        } 
#     }
#   }
#   while(!eof NFILE){
#     $row=<NFILE>;
#     chomp($row);
#     @split_row=split("\t",$row);
#     for($i=0;$i<@array_bit;$i++){
#       $hash_N{$p}=$hash_N{$p}+$split_row[$array_bit[$i]];
#     }
#     $p++;  
#   }  
#   close(NFILE);
#}
###DO NOT EDIT - END
if($decoy_flag>0){
    chdir($dir_db);
	$DB_PROT=new IO::Zlib;
	$DB_PROT->open("$protein_file","rb");
	$n_chiavi=0;
	while($row=<$DB_PROT>){
		$n_chiavi++;	
	}
	$DB_PROT->close;
	$meta_chiavi=$n_chiavi/2;
 	@chiavi_totali=0;
 	pop(@chiavi_totali);
 	@chiavi_totali=keys(%hash_R);
 	for($i=0;$i<@chiavi_totali;$i++){
 		if($chiavi_totali[$i]=~/(Decoy\_)(\d+)/){
 			$numero=$2;
 			$numero=$numero+$meta_chiavi;
 			$hash_R{$numero}=$hash_R{$chiavi_totali[$i]};
 			delete($hash_R{$chiavi_totali[$i]});
 			$hash_decoy_prot{$chiavi_totali[$i]}=$numero;
 		}
 	}
 	@keys_hash_result=sort(keys(%hash_results));
 	for($i=0;$i<@keys_hash_result;$i++){
 		$chiave_res=$keys_hash_result[$i];
 		if($chiave_res=~/(Decoy\_\d+)$/){
 			$prot=$1;
 			$corrispondenza=$hash_decoy_prot{$prot};
 			$chiave_res=~s/$prot/$corrispondenza/;
 			$hash_results{$chiave_res}=$hash_results{$keys_hash_result[$i]};
 			delete($hash_results{$keys_hash_result[$i]});
 		}
 		
 	}
} 
#MW and PI control
chdir($dir_db);
$DB_PROT=new IO::Zlib;
$DB_PROT->open("$protein_file","rb");
$p=0;
 while($row=<$DB_PROT>){
     @split_row=split("\t",$row);
     $mw_prot=$split_row[4];
     $hash_MW{$p}=$hash_MW{$p}+$mw_prot;
     $hash_MW{$p}=sprintf "%.2f", $hash_MW{$p};
     $flag_search=1;
     if($flag_input!=0){
         if ($flag_input==1 || $flag_input==3){
               if ($hash_MW{$p}>=$w_up || $hash_MW{$p}<=$w_down){
                   $flag_search=0;
               }
         }
         if ($flag_input==2 || $flag_input==3){
               $pi_prot=$split_row[5];
               if ($pi_prot>=$pi_up || $pi_prot<=$pi_down){
          	        $flag_search=0;
               }
         } 
     }    
     if($flag_search==0){
     	 $chiavi=$hash_keys_results{$p};
     	 @split_chiavi=split("\t",$chiavi);
     	 for($i=0;$i<@split_chiavi;$i++){
     	 	delete($hash_results{$split_chiavi[$i]});
     	 }
         delete($hash_R{$p});
         #delete($hash_N{$p});
     }
     else{
       $hash_aa{$p}=$split_row[5]; #$split_row[6];
       $tab=rindex($row,"\t");
       $header=substr($row,0,$tab);
       $new_mw=$hash_MW{$p};
       $header=~s/\t$mw_prot\t/\t$new_mw\t/;
       $hash_header{$p}=$header."\t"
     }
     delete($hash_MW{$p});
     $p++;
 }
 $DB_PROT->close;
 
#compute score
#computes some score parameters
$big_delta=$upp-$low; #range
$delta=$split_toll_prec[1];
@keys_prot=keys(%hash_R);
for($i=0;$i<@keys_prot;$i++){
    $R=$hash_R{$keys_prot[$i]};
    #$N=$hash_N{$keys_prot[$i]};
    #$score=&computeScore3($R,$N,$lambda);
    #$score=sprintf "%.2f", $score;
    #$hash_score{$score."_".$keys_prot[$i]}="$hash_header{$keys_prot[$i]}\n";
    $hash_score{$keys_prot[$i]}="$hash_header{$keys_prot[$i]}\n";
    
    delete($hash_R{$keys_prot[$i]});
    #delete($hash_N{$keys_prot[$i]});
}	
chdir($dir_res);
open(RESULTS, ">".$file_results);
$string_parameter1="Results report\n\n";
$string_parameter="Parameter used\n";
$string_parameter=$string_parameter."--------------\n";
$string_parameter=$string_parameter."Query mass list:\t$split_in[0]\nMolecular weight:\t";
if($weight==0){
    $string_parameter=$string_parameter."none\nIsoelectric point:\t";
}
else{
     $string_parameter=$string_parameter."$weight\nIsoelectric point:\t";
}
if($PI==0){
     $string_parameter=$string_parameter."none\n";
}
else{
     $string_parameter=$string_parameter."$PI\n";
}
$string_parameter=$string_parameter."Mass tolerance (precursor ions):\t$split_toll_prec[1] ";
if($split_toll_prec[0] eq "P"){
     $string_parameter=$string_parameter."ppm\n";
}
else{
     $string_parameter=$string_parameter."Da\n";
}    
$string_parameter=$string_parameter."Mass tolerance (fragment ions):\t$split_toll_fragm[1] ";
if($split_toll_fragm[0] eq "P"){
     $string_parameter=$string_parameter."ppm\n";
}
else{
     $string_parameter=$string_parameter."Da\n";
}    
$string_parameter=$string_parameter."Acquisition mass range:\t$low-$upp Da\nIntensity threshold:\t$int_stop_choose\np-value threshold:\t$p_cutoff\n";
if($n_mc==0){
 $string_parameter=$string_parameter."Missed cleavages:\tnone\n";
}
else{
   $string_parameter=$string_parameter."Missed cleavages:\t$n_mc\n";
}
if($n_ptm==0){
   $string_parameter=$string_parameter."PTM:\tnone\n";
}
else{
    $string_parameter=$string_parameter."PTM:\t";
    @split_string_ptm=split(" ",$string_ptm);
    for($i=0;$i<@split_string_ptm;$i++){
       if($i==0){
           $string_parameter=$string_parameter."$split_string_ptm[0]";
       }
       else{
           $string_parameter=$string_parameter."    \t$split_string_ptm[$i]";
       }
       $string_parameter=$string_parameter."\n";
       
    }   
}
$string_parameter=$string_parameter."\nCandidate proteins list\n";
$string_parameter=$string_parameter."-----------------------\n\n";
print RESULTS $string_parameter1.$string_parameter;
@keys_hash_result=sort(keys(%hash_results));#{$a<=>$b}
$nn=@keys_hash_result;
$numero_peptidi=@keys_hash_result;
for($j=0;$j<@keys_hash_result;$j++){	
	$risultato=$hash_results{$keys_hash_result[$j]};
	@split_res=split("_",$keys_hash_result[$j]);
	$prec=$split_res[1]; #$split_res[0];
	#$risultato=~/(Ions matched: )(\d+\.{1}\d+)(\n{1})/;
	$risultato=~/(Score: )(\d+\.{1}\d+)(\n{1})/;
	$n_match=$2;
	$match_prec{$keys_hash_result[$j]}=$n_match;
}
@keys_match_prec=sort{$match_prec{$b}<=>$match_prec{$a}}keys(%match_prec);
for($j=0;$j<@keys_match_prec;$j++){
	@split_res=split("_",$keys_match_prec[$j]);
	$prec=$split_res[1]; #$split_res[0];
	$hash_conta{$prec}=$hash_conta{$prec}+1;
	if($hash_conta{$prec}==1){
		$match_old{$prec}=$match_prec{$keys_match_prec[$j]};
	}
	if($hash_conta{$prec}>$numero_peptidi && $match_prec{$keys_match_prec[$j]}<$match_old{$prec}){
		delete($hash_results{$keys_match_prec[$j]});
	}
}	
@keys_hash_result=sort(keys(%hash_results)); #{$a<=>$b}
$nn2=@keys_hash_result;
@array_score=keys(%hash_score);
@array_score=sort{$b<=>$a}@array_score;
$rank=0;
for($i=0;$i<@array_score;$i++){
	@split_score=split("_",$array_score[$i]);
	$split_score[1]=$array_score[$i];###########
	for($j=0;$j<@keys_hash_result;$j++){	
    	if($keys_hash_result[$j]=~/_$split_score[1]$/){
    		if($write[$i]!=1){
    			$rank=$rank+1;
    			print RESULTS $rank.") ".$hash_score{$array_score[$i]}."\n";
    			$write[$i]=1;
    		}
    		print RESULTS $hash_results{$keys_hash_result[$j]};
    		delete($hash_results{$keys_hash_result[$j]});
    	}
	}
	if($write[$i]==1){
		print RESULTS "***---***---***---***---\n\n";	
	}
	delete($hash_score{$array_score[$i]});
}
if(@array_score==0){
	print RESULTS "All the peptides are not phosphorilated.\n";
}
close(RESULTS);

#resume file
chdir($dir_res);
$final_file="resume_".$file_results;
$i=0;
open(FILE,"<".$file_results);
while(!eof FILE){
	$row=<FILE>;
	if($row=~/^(\d+)(\))/){
		@split_row=split(/[\s\t]/,$row);
		$prot=$split_row[1];
		next;
	}
	if($row=~/^Peptide/){
		
		$row=~/^(Peptide )(.+[^\t])(\t{1})(Mass: )(\d+\.{1}\d+)(\t{1})(Charge: )(\d+)(\t{1})(Scan: )(\d+\_{1}\d+)(\t{1})(Mass db: )(\d+\.{1}\d+)(\t{1})(Delta mass: )(\-{0,1}\d+\.{1}\d+)(\t{1})(Ratio: )(\d+\.{0,1}\d*)(\t{1})(Ions: )(\d+)(\t{1})(Position: )(.+)(\n)$/;
  #Peptide VVEsLAK	Mass: 825.3633	Charge: 2	Scan: 1055_1055	Mass db: 824.4044	Delta mass: 0.9589	Ratio: 0.2	Ions: 188	Position: 182	188 
 		$stringa=$2.$3.$5.$6.$8.$9.$11.$12.$14.$15.$17.$18.$20.$21.$23.$24;
		$file[$i]=$file[$i]."$prot\t$stringa\t";
		#print "stringa $stringa\n";
		next;
	}
	if($row=~/Ions matched/){ 
		$row=~/(Ions matched: )(\d+)(\t{1})(Score: )(\d+\.{1}\d+)/;
		$score=$5;
		$match=$2;
	    $file[$i]=$file[$i]."$match\t$score";
	    
	    $i++;
	    next;
	}
}
close(FILE);
for($i=0;$i<@file;$i++){
	@split_file=split("\t",$file[$i]);
	$scan=$split_file[4];# $split_file[4];
	$hash_mem1{$scan}=$hash_mem1{$scan}.$file[$i];
}	
@chiavi=keys(%hash_mem1);
@chiavi=sort@chiavi;
open(NEW_FILE,">$final_file"); 
print NEW_FILE "Protein\tPeptide\tMass\tCharge\tScan\tMass db\tDelta mass\tRatio\tTh.Ions\tStart\tStop\tIons matched\tScore\n";
for($i=0;$i<@chiavi;$i++){
	$scan_letto=$hash_mem1{$chiavi[$i]};
	@split_scan=split("\n",$scan_letto);
	$n=@split_scan;
	$old_score=0;
	for($j=0;$j<@split_scan;$j++){
		@split_scan2=split("\t",$split_scan[$j]);
		$score=$split_scan2[11];
		$hash_score{$j}=$score;
	}
	@chiavi_score=sort{$hash_score{$b}<=>$hash_score{$a}}keys(%hash_score);
	$rank=1;
	$old_score=0;
	for($j=0;$j<@chiavi_score;$j++){
		if($hash_score{$chiavi_score[$j]}<$old_score){
			$rank=$rank+1;
		}
		print NEW_FILE $split_scan[$chiavi_score[$j]]."\n";
		$old_score=$hash_score{$chiavi_score[$j]};
		delete($hash_score{$chiavi_score[$j]});
	}
	print NEW_FILE "\n";
	
}	
close(NEW_FILE);

#pvalue
if($decoy_flag>0){
	print "computing p-value\n";
	$file_accessorio=$final_file."_pvalue.txt";
	chdir($dir_tmp);
	open(F,"<decoy_pep");
	$n=0;
	while(!eof F){
		$row=<F>;
		chomp($row);
		@split_row=split("\t",$row);
		$database=$split_row[0];
		if($database eq $db_choose){
			$pep_decoy=$split_row[1];
		}
	}
	close(F);
	chdir($dir_res);
	open(TMP,">$file_accessorio");
	print TMP "Database: $db_choose Trials: $pep_decoy pvalue-threshold: threshold(e.g. 0.05)/$pep_decoy\n";
	open(RES, "<$final_file");
	$row=<RES>; #header
	chomp $row;
	print TMP $row."\tp-value\n";
	$scan="";
	$mean=0;
	$st_dev=0;
	$conta_decoy=0;
	@decoy_value=0;
	pop(@decoy_value);
	$conta_hit=0;
	$conta_non_decoy=0;
	@keys_hash_row=0;
	pop(@keys_hash_row);
	$flag=0;
	while(!eof RES){
		$row=<RES>;
		if($row eq "\n"){
			if($flag==1){
				print TMP "\n";
			}
			$conta_decoy=0;
			next;
		}
		chomp($row);
		@split_row=split("\t",$row);
		if($row=~/^Decoy/){
			$conta_decoy++;
		}
		else{
			$pvalue=$conta_decoy/$pep_decoy;
			if($pvalue==0){
				$pvalue="0";
			}
			print TMP "$row\t$pvalue\n";
		}
		
	}
	close(RES);
	close(TMP);

}
print "Peptide characterization performed.\nThe results files are in the directory $dir_res\n";   
$fine=time-$start_time;
print "tempo $fine\n";


