% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_logNcorr_bounds.R
\name{get_logNcorr_bounds}
\alias{get_logNcorr_bounds}
\title{Computation of the ranges of Correlations for Log-Normal distributions}
\usage{
get_logNcorr_bounds(mu, sd)
}
\arguments{
\item{mu}{Array object which contains mean values of variables with a Log-Normal distribution.}

\item{sd}{Array object which contains sd values of variables with a Log-Normal distribution.}
}
\value{
A Matrix object with a number of rows equal to the number of Log-Normal variables couples and 4 columns containing:
\itemize{
\item{\code{var1}:} {numerical index of the first Log-Normal variable of the couple}
\item{\code{var2}:} {numerical index of the second Log-Normal variable of the couple}
\item{\code{lower}:} {lower bound for the range of Log-Normal correlation between \code{var1} and \code{var2}}
\item{\code{upper}:} {upper bound for the range of Log-Normal correlation between \code{var1} and \code{var2}}.
}
}
\description{
Correlations between Log-Normal distributed variables should be in specific ranges
depending on their CVs. These bounds represent a necessary condition for obtaining a positive definite covariance/correlation
matrix for the underlying normal distribution [1].
}
\details{
If \eqn{X=(x1,...,xN)} is a set of variables with a Log-Normal distribution with parameters \eqn{\theta,\Omega},
\eqn{Y=ln(X)} will be a set of Normal parameters with parameters \eqn{\mu,\Sigma}. The bond between \eqn{X} and \eqn{Y},
as well as between the parameters of the two multivariate distribution, is a non-linear transformation. Thus, Log-Normal
correlation structure has to fulfill the bound described in [1] in order to obtain a positive definite
covariance matrix for the underlying Normal distribution.
}
\examples{
sd2 <- array(c(1,2,0.5,3)) #array with standard deviations of variables
mu2 <- array(c(3,0.2,1,8)) #array with means of variables
get_logNcorr_bounds(mu2,sd2)

#returns
#      var1 var2   lower     upper
# [1,]    1    2 -0.1506242 0.3025073
# [2,]    1    3 -0.8529277 0.9942674
# [3,]    1    4 -0.8885903 0.9996221
# [4,]    2    3 -0.1275056 0.3517665
# [5,]    2    4 -0.1443341 0.3146269
# [6,]    3    4 -0.8398526 0.9968250


}
\references{
[1] Henrique S. Xavier, Filipe B. Abdalla, Benjamin Joachimi, Improving lognormal models for
cosmological fields, Monthly Notices of the Royal Astronomical Society,
Volume 459, Issue 4, 11 July 2016, Pages 3693–3710,
\href{https://doi.org/10.1093/mnras/stw874}{https://doi.org/10.1093/mnras/stw874}
}
\author{
Alessandro De Carlo \email{alessandro.decarlo01@universitadipavia.it}
}
