% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_to_logn.R
\name{normal_to_logn}
\alias{normal_to_logn}
\title{Convert Normal parameters to Log-Normal parameters}
\usage{
normal_to_logn(mu, covMatrix)
}
\arguments{
\item{mu}{Array object containing means of the multivariate Normal distribution.}

\item{covMatrix}{Matrix object containing covariance matrix of the multivariate Normal distribution.}
}
\value{
A list containing:\tabular{ll}{
\code{muLn} \tab Array object. It contains mean of the multivariate Log-Normal distribution associated to the
                    Normal one.\cr
   \tab \cr
   \code{sigmaLn} \tab Matrix object. It contains covariance matrix of the multivariate Log-Normal distribution
   associated to the Normal one.\cr
}
}
\description{
This function converts mean vector and covariance matrix of a multivariate Normal
distribution to mean vector and covariance matrix of the associated multivariate Log-Normal distribution.
}
\examples{
#define correlations
corr<- diag(rep(1,4))
corr[1,4] <- 0.9
corr[4,1]<-corr[1,4]
corr[2,4] <- -0.3
corr[4,2] <- corr[2,4]
corr[3,2] <- -0.2
corr[2,3] <- corr[3,2]
#define sd of variables
sd2 <- array(c(rep(1,4)))
#obtain covariance matrix
covMatrix2 <- sd2\%*\%t(sd2)*corr
#define mean vector
mu2 <- array(rep(2.5,4))
normal_to_logn(mu2,covMatrix2)
#output:

# $muLn
# [1] 20.08554 20.08554 20.08554 20.08554
#
# $sigmaLn
#           [,1]   [,2]      [,3]      [,4]
# [1,] 693.2044    0.00000   0.00000  588.8459
# [2,]   0.0000  693.20436 -73.12923 -104.5614
# [3,]   0.0000  -73.12923 693.20436    0.0000
# [4,] 588.8459 -104.56139   0.00000  693.2044
}
\seealso{
\code{\link{logn_to_normal}}
}
\author{
Alessandro De Carlo \email{alessandro.decarlo01@universitadipavia.it}
}
