% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_graph_corr.R
\name{plot_graph_corr}
\alias{plot_graph_corr}
\title{Plot of correlation graph}
\usage{
plot_graph_corr(
  corrMat,
  title = "Graph of Correlation Matrix",
  title_size = 1.2,
  edge_width = 0.2,
  edge_label_size = 1.2,
  edge_label_position = 0.6,
  custom_labels = NULL,
  bg_color = "#F8F8F8",
  shade_factor = 0.2
)
}
\arguments{
\item{corrMat}{Matrix object which represents correlation matrix.}

\item{title}{String object which contains the title of the plot. Default values is "Graph of correlation matrix".}

\item{title_size}{Double with the size of the title. Default value is 1.2.}

\item{edge_width}{Double with the width of the edges. Default value is 0.2.}

\item{edge_label_size}{Double with the size of the labels plotted on the edges. They correspond to the
correlations. Default value is 1.2.}

\item{edge_label_position}{Double in [0,1] interval which indicates the relative position of the label on the graph.
Default value is 0.6.}

\item{custom_labels}{Vector with custom node names. If it is \emph{NULL}, column names of correlation matrix.
are used. If correlation matrix has not column names, indices of column are taken. Default value is \emph{NULL}.}

\item{bg_color}{String with hexadecimal code of background color. Default value is gray "#F8F8F8".}

\item{shade_factor}{Double for tuning edge shades. Default value is 0.2.}
}
\description{
Function that generates a plot of the graph associated to a given correlation matrix.
}
\note{
No more than 3 letters can be showed in each node.
}
\examples{
c_start <- diag(rep(1,10))
c_start[1,2] <- -0.6
c_start[1,3] <- -0.75
c_start[2,3] <-0.95
c_start[2,4] <- 0.75
c_start[2,6] <- -0.6
c_start[2,8] <- 0.75
c_start[3,4] <- 0.6
c_start[3,8] <-0.75
c_start[4,7] <- 0.6
c_start[4,8]<-0.75
c_start[5,7] <- -0.95
c_start <- c_start+t(c_start)-diag(rep(1,ncol(c_start)))
plot_graph_corr(c_start,"Graph of Correlation Matrix")


}
\author{
Alessandro De Carlo \email{alessandro.decarlo01@universitadipavia.it}
}
