/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.opti;

import com.sun.org.apache.xerces.internal.impl.xs.opti.DefaultElement;
import com.sun.org.apache.xerces.internal.impl.xs.opti.NamedNodeMapImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.SchemaDOM;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementImpl
extends DefaultElement {
    SchemaDOM schemaDOM;
    Attr[] attrs;
    int row = -1;
    int col = -1;
    int parentRow = -1;
    int line;
    int column;

    public ElementImpl(int line, int column) {
        this.nodeType = 1;
        this.line = line;
        this.column = column;
    }

    public ElementImpl(String prefix, String localpart, String rawname, String uri, int line, int column) {
        super(prefix, localpart, rawname, uri, (short)1);
        this.line = line;
        this.column = column;
    }

    public Document getOwnerDocument() {
        return this.schemaDOM;
    }

    public Node getParentNode() {
        return this.schemaDOM.relations[this.row][0];
    }

    public boolean hasChildNodes() {
        return this.parentRow != -1;
    }

    public Node getFirstChild() {
        if (this.parentRow == -1) {
            return null;
        }
        return this.schemaDOM.relations[this.parentRow][1];
    }

    public Node getLastChild() {
        if (this.parentRow == -1) {
            return null;
        }
        int i = 1;
        while (i < this.schemaDOM.relations[this.parentRow].length) {
            if (this.schemaDOM.relations[this.parentRow][i] == null) {
                return this.schemaDOM.relations[this.parentRow][i - 1];
            }
            ++i;
        }
        if (i == 1) {
            ++i;
        }
        return this.schemaDOM.relations[this.parentRow][i - 1];
    }

    public Node getPreviousSibling() {
        if (this.col == 1) {
            return null;
        }
        return this.schemaDOM.relations[this.row][this.col - 1];
    }

    public Node getNextSibling() {
        if (this.col == this.schemaDOM.relations[this.row].length - 1) {
            return null;
        }
        return this.schemaDOM.relations[this.row][this.col + 1];
    }

    public NamedNodeMap getAttributes() {
        return new NamedNodeMapImpl(this.attrs);
    }

    public boolean hasAttributes() {
        return this.attrs.length != 0;
    }

    public String getTagName() {
        return this.rawname;
    }

    public String getAttribute(String name) {
        int i = 0;
        while (i < this.attrs.length) {
            if (this.attrs[i].getName().equals(name)) {
                return this.attrs[i].getValue();
            }
            ++i;
        }
        return "";
    }

    public Attr getAttributeNode(String name) {
        int i = 0;
        while (i < this.attrs.length) {
            if (this.attrs[i].getName().equals(name)) {
                return this.attrs[i];
            }
            ++i;
        }
        return null;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        int i = 0;
        while (i < this.attrs.length) {
            if (this.attrs[i].getLocalName().equals(localName) && this.attrs[i].getNamespaceURI().equals(namespaceURI)) {
                return this.attrs[i].getValue();
            }
            ++i;
        }
        return "";
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        int i = 0;
        while (i < this.attrs.length) {
            if (this.attrs[i].getName().equals(localName) && this.attrs[i].getNamespaceURI().equals(namespaceURI)) {
                return this.attrs[i];
            }
            ++i;
        }
        return null;
    }

    public boolean hasAttribute(String name) {
        int i = 0;
        while (i < this.attrs.length) {
            if (this.attrs[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        int i = 0;
        while (i < this.attrs.length) {
            if (this.attrs[i].getName().equals(localName) && this.attrs[i].getNamespaceURI().equals(namespaceURI)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setAttribute(String name, String value) {
        int i = 0;
        while (i < this.attrs.length) {
            if (this.attrs[i].getName().equals(name)) {
                this.attrs[i].setValue(value);
                return;
            }
            ++i;
        }
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }
}

