/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.MasterObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.DelayVariable;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.maths.Operand;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DelayType", propOrder={"symbRef", "delayVariable"})
public class Delay
extends PharmMLRootType
implements Operand {
    @XmlElement(name="SymbRef", required=true)
    protected SymbolRef symbRef;
    @XmlElement(name="DelayVariable", required=true)
    protected DelayVariable delayVariable;

    public Delay() {
    }

    public Delay(SymbolRef y, SymbolRef tau) {
        this.symbRef = y;
        this.createDelayVariable(tau);
    }

    public Delay(SymbolRef y, Scalar tau) {
        this.symbRef = y;
        this.createDelayVariable(tau);
    }

    public SymbolRef getSymbRef() {
        return this.symbRef;
    }

    public void setSymbRef(SymbolRef value) {
        this.symbRef = value;
    }

    public DelayVariable getDelayVariable() {
        return this.delayVariable;
    }

    public void setDelayVariable(DelayVariable value) {
        this.delayVariable = value;
    }

    public DelayVariable createDelayVariable(SymbolRef symbRef) {
        DelayVariable var = new DelayVariable();
        var.setSymbRef(symbRef);
        this.delayVariable = var;
        return var;
    }

    public DelayVariable createDelayVariable(Scalar scalar) {
        DelayVariable var = new DelayVariable();
        var.setScalar(scalar);
        this.delayVariable = var;
        return var;
    }

    public JAXBElement<Delay> toJAXBElement() {
        return MasterObjectFactory.COMMONTYPES_OF.createDelay(this);
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<DelayVariable>().addIfNotNull(this.delayVariable).addIfNotNull((DelayVariable)((Object)this.symbRef));
    }

    @Override
    public String toMathExpression() {
        return new MathExpressionConverterToExpression().convert(this);
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }
}

