/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.commontypes.MatrixBlock;
import eu.ddmore.libpharmml.dom.commontypes.MatrixCell;
import eu.ddmore.libpharmml.dom.commontypes.MatrixCellValue;
import eu.ddmore.libpharmml.dom.commontypes.MatrixColumn;
import eu.ddmore.libpharmml.dom.commontypes.MatrixColumnRowNames;
import eu.ddmore.libpharmml.dom.commontypes.MatrixRow;
import eu.ddmore.libpharmml.dom.commontypes.MatrixRowValue;
import eu.ddmore.libpharmml.dom.commontypes.MatrixVectorIndex;
import eu.ddmore.libpharmml.dom.commontypes.ObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import eu.ddmore.libpharmml.util.SubList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MatrixType", propOrder={"rowNames", "columnNames", "matrixRowOrMatrixCellOrMatrixBlock"})
public class Matrix
extends PharmMLRootType
implements ExpressionValue,
LogicBinOperand {
    @XmlElement(name="RowNames")
    protected MatrixColumnRowNames rowNames;
    @XmlElement(name="ColumnNames")
    protected MatrixColumnRowNames columnNames;
    @XmlElements(value={@XmlElement(name="MatrixColumn", type=MatrixColumn.class), @XmlElement(name="MatrixRow", type=MatrixRow.class), @XmlElement(name="MatrixCell", type=MatrixCell.class), @XmlElement(name="MatrixBlock", type=MatrixBlock.class)})
    protected List<PharmMLRootType> matrixRowOrMatrixCellOrMatrixBlock;
    @XmlAttribute(name="diagDefault")
    protected Double diagDefault;
    @XmlAttribute(name="offDiagDefault")
    protected Double offDiagDefault;
    @XmlAttribute(name="numbCols")
    protected Integer numbCols;
    @XmlAttribute(name="numbRows")
    protected Integer numbRows;
    @XmlAttribute(name="matrixType", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String matrixType;
    @XmlAttribute(name="symbId")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @Deprecated
    protected String symbId;

    public Matrix() {
    }

    @Deprecated
    public Matrix(String symbolId, Type type) {
        this();
        this.setSymbId(symbolId);
        this.setMatrixType(type);
    }

    public Matrix(Type type) {
        this();
        this.setMatrixType(type);
    }

    @Deprecated
    public Matrix(String symbolId, Type type, int numbCols, int numbRows) {
        this(symbolId, type);
        this.setNumbCols(numbCols);
        this.setNumbRows(numbRows);
    }

    public Matrix(Type type, int numbCols, int numbRows) {
        this(type);
        this.setNumbCols(numbCols);
        this.setNumbRows(numbRows);
    }

    public Matrix(String symbolId, Type type, int numbCols, int numbRows, double diagDefault, double offDiagDefault) {
        this(symbolId, type, numbCols, numbRows);
        this.setDiagDefault(diagDefault);
        this.setOffDiagDefault(offDiagDefault);
    }

    public MatrixColumnRowNames getRowNames() {
        return this.rowNames;
    }

    public void setRowNames(MatrixColumnRowNames value) {
        this.rowNames = value;
    }

    public MatrixColumnRowNames getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(MatrixColumnRowNames value) {
        this.columnNames = value;
    }

    public List<MatrixRow> getMatrixRow() {
        return new SubList<MatrixRow>(this.getListOfMatrixElements(), MatrixRow.class);
    }

    public List<PharmMLRootType> getListOfMatrixElements() {
        if (this.matrixRowOrMatrixCellOrMatrixBlock == null) {
            this.matrixRowOrMatrixCellOrMatrixBlock = new ArrayList<PharmMLRootType>();
        }
        return this.matrixRowOrMatrixCellOrMatrixBlock;
    }

    public double getDiagDefault() {
        if (this.diagDefault == null) {
            return 0.0;
        }
        return this.diagDefault;
    }

    public void setDiagDefault(Double value) {
        this.diagDefault = value;
    }

    public double getOffDiagDefault() {
        if (this.offDiagDefault == null) {
            return 0.0;
        }
        return this.offDiagDefault;
    }

    public void setOffDiagDefault(Double value) {
        this.offDiagDefault = value;
    }

    public Integer getNumbCols() {
        return this.numbCols;
    }

    public void setNumbCols(Integer value) {
        this.numbCols = value;
    }

    @Deprecated
    public void setNumbCols(BigInteger value) {
        this.numbCols = value.intValue();
    }

    public Integer getNumbRows() {
        return this.numbRows;
    }

    public void setNumbRows(Integer value) {
        this.numbRows = value;
    }

    @Deprecated
    public void setNumbRows(BigInteger value) {
        this.numbRows = value.intValue();
    }

    public String getMatrixType() {
        return this.matrixType;
    }

    public void setMatrixType(String value) {
        this.matrixType = value;
    }

    @Deprecated
    public String getSymbId() {
        return this.symbId;
    }

    @Deprecated
    public void setSymbId(String value) {
        this.symbId = value;
    }

    public void setMatrixType(Type type) {
        this.setMatrixType(type.toString());
    }

    public MatrixColumnRowNames createRowNames() {
        MatrixColumnRowNames rowNames;
        this.rowNames = rowNames = new MatrixColumnRowNames();
        return rowNames;
    }

    public MatrixColumnRowNames createColumnNames() {
        MatrixColumnRowNames columnNames;
        this.columnNames = columnNames = new MatrixColumnRowNames();
        return columnNames;
    }

    public MatrixCell createMatrixCell() {
        MatrixCell cell = new MatrixCell();
        this.getListOfMatrixElements().add(cell);
        return cell;
    }

    public MatrixCell createMatrixCell(int rowIndex, int columnIndex) {
        return this.createMatrixCell(new MatrixVectorIndex(rowIndex), new MatrixVectorIndex(columnIndex));
    }

    public MatrixCell createMatrixCell(int rowIndex, int columnIndex, double value) {
        MatrixCell cell = this.createMatrixCell(rowIndex, columnIndex);
        cell.createRealValue(value);
        return cell;
    }

    public MatrixCell createMatrixCell(int rowIndex, int columnIndex, int value) {
        MatrixCell cell = this.createMatrixCell(rowIndex, columnIndex);
        cell.createIntValue(value);
        return cell;
    }

    public MatrixCell createMatrixCell(int rowIndex, int columnIndex, boolean value) {
        MatrixCell cell = this.createMatrixCell(rowIndex, columnIndex);
        cell.createBooleanValue(value);
        return cell;
    }

    public MatrixCell createMatrixCell(int rowIndex, int columnIndex, String value) {
        MatrixCell cell = this.createMatrixCell(rowIndex, columnIndex);
        cell.createStringValue(value);
        return cell;
    }

    public MatrixCell createMatrixCell(MatrixVectorIndex rowIndex, MatrixVectorIndex columnIndex) {
        MatrixCell cell = this.createMatrixCell();
        cell.setCellRow(rowIndex);
        cell.setCellColumn(columnIndex);
        return cell;
    }

    public MatrixCell createMatrixCell(MatrixVectorIndex rowIndex, MatrixVectorIndex columnIndex, MatrixCellValue value) {
        MatrixCell cell = this.createMatrixCell(rowIndex, columnIndex);
        cell.setValue(value);
        return cell;
    }

    public MatrixBlock createMatrixBlock() {
        MatrixBlock block = new MatrixBlock();
        this.getListOfMatrixElements().add(block);
        return block;
    }

    public MatrixBlock createMatrixBlock(MatrixVectorIndex rowStartIndex, MatrixVectorIndex columnStartIndex) {
        MatrixBlock block = this.createMatrixBlock();
        block.setBlockStartRow(rowStartIndex);
        block.setBlockStartColumn(columnStartIndex);
        return block;
    }

    public MatrixRow createMatrixRow() {
        MatrixRow row = new MatrixRow();
        this.getListOfMatrixElements().add(row);
        return row;
    }

    public MatrixRow createMatrixRow(double defaultValue) {
        MatrixRow row = this.createMatrixRow();
        row.setDefault(defaultValue);
        return row;
    }

    public MatrixRow createMatrixRow(MatrixVectorIndex index, double defaultValue) {
        MatrixRow row = this.createMatrixRow(defaultValue);
        row.setRowIndex(index);
        return row;
    }

    public MatrixRow createMatrixRow(MatrixRowValue[] values) {
        MatrixRow row = this.createMatrixRow();
        for (MatrixRowValue value : values) {
            row.getListOfValues().add(value);
        }
        return row;
    }

    public MatrixRow createMatrixRow(MatrixVectorIndex index, MatrixRowValue[] values) {
        MatrixRow row = this.createMatrixRow(values);
        row.setRowIndex(index);
        return row;
    }

    public MatrixColumn createMatrixColumn() {
        MatrixColumn column = new MatrixColumn();
        this.getListOfMatrixElements().add(column);
        return column;
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<MatrixColumnRowNames>().addIfNotNull(this.rowNames).addIfNotNull(this.columnNames).addIfNotNull(this.matrixRowOrMatrixCellOrMatrixBlock);
    }

    @Override
    public String toMathExpression() {
        return new MathExpressionConverterToExpression().convert(this);
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<Matrix> toJAXBElement() {
        return ObjectFactory.getInstance().createMatrix(this);
    }

    public JAXBElement<Matrix> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createMatrix(this);
    }

    public static enum Type {
        ANY("Any"),
        DIAGONAL("Diagonal"),
        LOWER_TRIANGULAR("LowerTriangular"),
        UPPER_TRIANGULAR("UpperTriangular"),
        SYMMETRIC("Symmetric");

        private String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

