/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.dom.commontypes.MatrixCell;
import eu.ddmore.libpharmml.dom.commontypes.MatrixRow;
import eu.ddmore.libpharmml.dom.commontypes.MatrixVectorIndex;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.util.ChainedList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MatrixBlockType", propOrder={"blockStartRow", "blockStartColumn", "blockRow", "blockCell"})
public class MatrixBlock
extends PharmMLRootType {
    @XmlElement(name="BlockStartRow", required=true)
    protected MatrixVectorIndex blockStartRow;
    @XmlElement(name="BlockStartColumn", required=true)
    protected MatrixVectorIndex blockStartColumn;
    @XmlElement(name="BlockRow")
    protected List<MatrixRow> blockRow;
    @XmlElement(name="BlockCell")
    protected List<MatrixCell> blockCell;
    @XmlAttribute(name="diagDefault")
    protected Double diagDefault;
    @XmlAttribute(name="offDiagDefault")
    protected Double offDiagDefault;
    @XmlAttribute(name="numbCols")
    protected Integer numbCols;
    @XmlAttribute(name="numbRows")
    protected Integer numbRows;

    public MatrixBlock() {
    }

    public MatrixBlock(MatrixVectorIndex blockStartRow, MatrixVectorIndex blockStartColumn) {
        this.blockStartRow = blockStartRow;
        this.blockStartColumn = blockStartColumn;
    }

    public MatrixBlock(int blockStartRow, int blockStartcolumn) {
        this(new MatrixVectorIndex(blockStartRow), new MatrixVectorIndex(blockStartcolumn));
    }

    public MatrixVectorIndex getBlockStartRow() {
        return this.blockStartRow;
    }

    public void setBlockStartRow(MatrixVectorIndex value) {
        this.blockStartRow = value;
    }

    public MatrixVectorIndex getBlockStartColumn() {
        return this.blockStartColumn;
    }

    public void setBlockStartColumn(MatrixVectorIndex value) {
        this.blockStartColumn = value;
    }

    public List<MatrixRow> getListOfBlockRow() {
        if (this.blockRow == null) {
            this.blockRow = new ArrayList<MatrixRow>();
        }
        return this.blockRow;
    }

    public List<MatrixCell> getListOfBlockCell() {
        if (this.blockCell == null) {
            this.blockCell = new ArrayList<MatrixCell>();
        }
        return this.blockCell;
    }

    public double getDiagDefault() {
        if (this.diagDefault == null) {
            return 0.0;
        }
        return this.diagDefault;
    }

    public void setDiagDefault(Double value) {
        this.diagDefault = value;
    }

    public double getOffDiagDefault() {
        if (this.offDiagDefault == null) {
            return 0.0;
        }
        return this.offDiagDefault;
    }

    public void setOffDiagDefault(Double value) {
        this.offDiagDefault = value;
    }

    public Integer getNumbCols() {
        return this.numbCols;
    }

    public void setNumbCols(Integer value) {
        this.numbCols = value;
    }

    @Deprecated
    public void setNumbCols(BigInteger value) {
        this.numbCols = value.intValue();
    }

    public Integer getNumbRows() {
        return this.numbRows;
    }

    public void setNumbRows(Integer value) {
        this.numbRows = value;
    }

    @Deprecated
    public void setNumbRows(BigInteger value) {
        this.numbRows = value.intValue();
    }

    public MatrixVectorIndex createBlockStartRow() {
        MatrixVectorIndex el;
        this.blockStartRow = el = new MatrixVectorIndex();
        return el;
    }

    public MatrixVectorIndex createBlockStartColumn() {
        MatrixVectorIndex el;
        this.blockStartColumn = el = new MatrixVectorIndex();
        return el;
    }

    public MatrixRow createBlockRow() {
        MatrixRow el = new MatrixRow();
        this.getListOfBlockRow().add(el);
        return el;
    }

    public MatrixRow createBlockRow(MatrixVectorIndex rowIndex) {
        MatrixRow el = this.createBlockRow();
        el.setRowIndex(rowIndex);
        return el;
    }

    public MatrixCell createBlockCell() {
        MatrixCell el = new MatrixCell();
        this.getListOfBlockCell().add(el);
        return el;
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<MatrixVectorIndex>().addIfNotNull(this.blockStartRow).addIfNotNull(this.blockStartColumn).addIfNotNull(this.blockRow).addIfNotNull(this.blockCell);
    }
}

