/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.dom.commontypes.BooleanValue;
import eu.ddmore.libpharmml.dom.commontypes.FalseBoolean;
import eu.ddmore.libpharmml.dom.commontypes.IdValue;
import eu.ddmore.libpharmml.dom.commontypes.IntValue;
import eu.ddmore.libpharmml.dom.commontypes.MatrixCellValue;
import eu.ddmore.libpharmml.dom.commontypes.MatrixVectorIndex;
import eu.ddmore.libpharmml.dom.commontypes.MissingValue;
import eu.ddmore.libpharmml.dom.commontypes.MissingValueSymbol;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.RealValue;
import eu.ddmore.libpharmml.dom.commontypes.ScalarContainer;
import eu.ddmore.libpharmml.dom.commontypes.StringValue;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.TrueBoolean;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MatrixCellType", propOrder={"cellRow", "cellColumn", "value"})
public class MatrixCell
extends PharmMLRootType
implements ScalarContainer {
    @XmlElement(name="CellRow", required=true)
    protected MatrixVectorIndex cellRow;
    @XmlElement(name="CellColumn", required=true)
    protected MatrixVectorIndex cellColumn;
    @XmlElementRefs(value={@XmlElementRef(name="VectorCellValue", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class), @XmlElementRef(name="Assign", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class), @XmlElementRef(name="Equation", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class)})
    protected MatrixCellValue value;

    public MatrixCell() {
    }

    public MatrixCell(MatrixVectorIndex rowIndex, MatrixVectorIndex columnIndex) {
        this.cellRow = rowIndex;
        this.cellColumn = columnIndex;
    }

    public MatrixCell(MatrixVectorIndex rowIndex, MatrixVectorIndex columnIndex, MatrixCellValue value) {
        this(rowIndex, columnIndex);
        this.value = value;
    }

    public MatrixVectorIndex getCellRow() {
        return this.cellRow;
    }

    public void setCellRow(MatrixVectorIndex value) {
        this.cellRow = value;
    }

    public MatrixVectorIndex getCellColumn() {
        return this.cellColumn;
    }

    public void setCellColumn(MatrixVectorIndex value) {
        this.cellColumn = value;
    }

    public MatrixCellValue getValue() {
        return this.value;
    }

    public void setValue(MatrixCellValue value) {
        this.value = value;
    }

    public MatrixVectorIndex createCellRowIndex() {
        MatrixVectorIndex el;
        this.cellRow = el = new MatrixVectorIndex();
        return el;
    }

    public MatrixVectorIndex createCellRowIndex(int index) {
        MatrixVectorIndex el = this.createCellRowIndex();
        el.setIntValue(new IntValue(index));
        return el;
    }

    public MatrixVectorIndex createCellRowIndex(SymbolRef index) {
        MatrixVectorIndex el = this.createCellRowIndex();
        el.setSymbolRef(index);
        return el;
    }

    public MatrixVectorIndex createCellColumnIndex() {
        MatrixVectorIndex el;
        this.cellColumn = el = new MatrixVectorIndex();
        return el;
    }

    public MatrixVectorIndex createCellColumnIndex(int index) {
        MatrixVectorIndex el = this.createCellColumnIndex();
        el.setIntValue(new IntValue(index));
        return el;
    }

    public MatrixVectorIndex createCellColumnIndex(SymbolRef index) {
        MatrixVectorIndex el = this.createCellColumnIndex();
        el.setSymbolRef(index);
        return el;
    }

    @Override
    public IntValue createIntValue(int value) {
        this.value = new IntValue(value);
        return (IntValue)this.value;
    }

    @Override
    public RealValue createRealValue(double value) {
        RealValue wValue = new RealValue(value);
        this.value = wValue;
        return wValue;
    }

    @Override
    public StringValue createStringValue(String value) {
        StringValue wValue = new StringValue(value);
        this.value = wValue;
        return wValue;
    }

    @Override
    public IdValue createIdValue(String value) {
        IdValue wValue = new IdValue(value);
        this.value = wValue;
        return wValue;
    }

    @Override
    public BooleanValue createBooleanValue(boolean value) {
        BooleanValue wValue = value ? new TrueBoolean() : new FalseBoolean();
        this.value = wValue;
        return wValue;
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<MatrixVectorIndex>().addIfNotNull(this.cellRow).addIfNotNull(this.cellColumn).addIfNotNull((MatrixVectorIndex)((Object)this.value));
    }

    @Override
    public MissingValue createMissingValue(MissingValueSymbol symbol) {
        MissingValue mValue = new MissingValue(symbol);
        this.value = mValue;
        return mValue;
    }
}

