/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.MasterObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.MatrixBlockSelector;
import eu.ddmore.libpharmml.dom.commontypes.MatrixCellSelector;
import eu.ddmore.libpharmml.dom.commontypes.MatrixVectorIndex;
import eu.ddmore.libpharmml.dom.commontypes.ObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.Operand;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MatrixSelectorType", propOrder={"symbRef", "cell", "block", "row", "column"})
public class MatrixSelector
extends PharmMLRootType
implements Operand,
ExpressionValue,
LogicBinOperand {
    @XmlElement(name="SymbRef", required=true)
    protected SymbolRef symbRef;
    @XmlElement(name="Cell")
    protected MatrixCellSelector cell;
    @XmlElement(name="Block")
    protected MatrixBlockSelector block;
    @XmlElement(name="Row")
    protected MatrixVectorIndex row;
    @XmlElement(name="Column")
    protected MatrixVectorIndex column;

    public MatrixSelector() {
    }

    public MatrixSelector(SymbolRef matrixRef) {
        this.symbRef = matrixRef;
    }

    public SymbolRef getSymbRef() {
        return this.symbRef;
    }

    public void setSymbRef(SymbolRef value) {
        this.symbRef = value;
    }

    public MatrixCellSelector getCell() {
        return this.cell;
    }

    public void setCell(MatrixCellSelector value) {
        this.cell = value;
    }

    public MatrixBlockSelector getBlock() {
        return this.block;
    }

    public void setBlock(MatrixBlockSelector value) {
        this.block = value;
    }

    public MatrixVectorIndex getRow() {
        return this.row;
    }

    public void setRow(MatrixVectorIndex value) {
        this.row = value;
    }

    public MatrixVectorIndex getColumn() {
        return this.column;
    }

    public void setColumn(MatrixVectorIndex value) {
        this.column = value;
    }

    public SymbolRef createSymbRef() {
        SymbolRef el;
        this.symbRef = el = new SymbolRef();
        return el;
    }

    public MatrixCellSelector createCell() {
        MatrixCellSelector el;
        this.cell = el = new MatrixCellSelector();
        return el;
    }

    public MatrixBlockSelector createBlock() {
        MatrixBlockSelector el;
        this.block = el = new MatrixBlockSelector();
        return el;
    }

    public MatrixVectorIndex createRow() {
        MatrixVectorIndex el;
        this.row = el = new MatrixVectorIndex();
        return el;
    }

    public MatrixVectorIndex createColumn() {
        MatrixVectorIndex el;
        this.column = el = new MatrixVectorIndex();
        return el;
    }

    public JAXBElement<MatrixSelector> toJAXBElement() {
        return MasterObjectFactory.COMMONTYPES_OF.createMatrixSelector(this);
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<SymbolRef>().addIfNotNull(this.symbRef).addIfNotNull((SymbolRef)((Object)this.cell)).addIfNotNull((SymbolRef)((Object)this.block)).addIfNotNull((SymbolRef)((Object)this.row)).addIfNotNull((SymbolRef)((Object)this.column));
    }

    @Override
    public String toMathExpression() {
        if (this.symbRef != null) {
            return this.symbRef.toMathExpression();
        }
        return "null";
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<MatrixSelector> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createMatrixSelector(this);
    }
}

