/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.MasterObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.AbstractFormula;
import eu.ddmore.libpharmml.dom.commontypes.ObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.OperationVariable;
import eu.ddmore.libpharmml.dom.commontypes.SumProductIndex;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.Operand;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProductType", propOrder={"variable", "productIndex", "lowLimit", "upLimit"})
public class Product
extends AbstractFormula
implements Operand,
ExpressionValue,
LogicBinOperand {
    @XmlElement(name="ProductIndex", required=true)
    protected SumProductIndex productIndex;

    public Product() {
    }

    public Product(OperationVariable V, SymbolRef i, int n, int N) {
        this.variable = V;
        this.createProductIndex(i);
        this.createLowLimit(n);
        this.createUpLimit(N);
    }

    public SumProductIndex getProductIndex() {
        return this.productIndex;
    }

    public void setProductIndex(SumProductIndex value) {
        this.productIndex = value;
    }

    public SumProductIndex createProductIndex(SymbolRef i) {
        SumProductIndex index = new SumProductIndex();
        index.setSymbRef(i);
        this.setProductIndex(index);
        return index;
    }

    public JAXBElement<Product> toJAXBElement() {
        return MasterObjectFactory.COMMONTYPES_OF.createProduct(this);
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<OperationVariable>().addIfNotNull(this.variable).addIfNotNull((OperationVariable)((Object)this.productIndex)).addIfNotNull((OperationVariable)((Object)this.lowLimit)).addIfNotNull((OperationVariable)((Object)this.upLimit));
    }

    @Override
    public String toMathExpression() {
        return null;
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<Product> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createProduct(this);
    }
}

