/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.dom.commontypes.MissingValue;
import eu.ddmore.libpharmml.dom.commontypes.MissingValueSymbol;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.impl.LoggerWrapper;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ScalarAdapter
extends XmlAdapter<JAXBElement<? extends Scalar>, Scalar> {
    public Scalar unmarshal(JAXBElement<? extends Scalar> v) throws Exception {
        if (v == null) {
            return null;
        }
        Scalar value = (Scalar)v.getValue();
        if (value instanceof MissingValue) {
            String name = v.getName().getLocalPart();
            if (name.equals("NaN")) {
                ((MissingValue)value).setSymbol(MissingValueSymbol.NaN);
            } else if (name.equals("ALQ")) {
                ((MissingValue)value).setSymbol(MissingValueSymbol.ALQ);
            } else if (name.equals("plusInf")) {
                ((MissingValue)value).setSymbol(MissingValueSymbol.PLUSINF);
            } else if (name.equals("minusInf")) {
                ((MissingValue)value).setSymbol(MissingValueSymbol.MINUSINF);
            } else if (name.equals("BLQ")) {
                ((MissingValue)value).setSymbol(MissingValueSymbol.BLQ);
            } else if (name.equals("NA")) {
                ((MissingValue)value).setSymbol(MissingValueSymbol.NA);
            } else {
                LoggerWrapper.getLogger().severe("Unknown name (" + v.getName() + ")for missing value.");
            }
        }
        return value;
    }

    public JAXBElement<? extends Scalar> marshal(Scalar v) throws Exception {
        if (v == null) {
            return null;
        }
        return v.toJAXBElement();
    }
}

