/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.Rhs;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.dom.commontypes.StandardAssignable;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.maths.Equation;
import eu.ddmore.libpharmml.dom.tags.AdaptedClass;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class StandardAssignableAdapted
extends PharmMLRootType
implements AdaptedClass<StandardAssignable> {
    @XmlTransient
    private StandardAssignable unmappedObject;
    @XmlElement(name="Assign")
    protected Rhs assign;
    @XmlElement(name="Equation", namespace="http://www.pharmml.org/pharmml/0.8/Maths")
    protected Equation equation;
    @XmlElementRef(name="Scalar", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class)
    protected Scalar scalar;
    @XmlElement(name="SymbRef", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes")
    protected SymbolRef symbRef;

    public StandardAssignableAdapted() {
    }

    public StandardAssignableAdapted(StandardAssignable unmapped) {
        this.unmappedObject = unmapped;
    }

    public static StandardAssignableAdapted normal(StandardAssignable sa) {
        StandardAssignableAdapted adapted = new StandardAssignableAdapted();
        StandardAssignableAdapted.copyRoot(sa, adapted);
        adapted.assign = sa.getAssign();
        return adapted;
    }

    public static StandardAssignableAdapted scalarRhs(StandardAssignable sa) {
        StandardAssignableAdapted adapted = new StandardAssignableAdapted();
        StandardAssignableAdapted.copyRoot(sa, adapted);
        if (sa.getAssign() != null) {
            Rhs assign = sa.getAssign();
            if (assign.getScalar() != null) {
                adapted.scalar = assign.getScalar();
            } else if (assign.getSymbRef() != null) {
                adapted.symbRef = assign.getSymbRef();
            } else {
                adapted.equation = assign.getEquation() != null ? assign.getEquation() : Equation.fromRhs(assign);
            }
        }
        return adapted;
    }

    private static void copyRoot(StandardAssignable from, StandardAssignableAdapted to) {
        to.setId(from.getId());
        to.setDescription(from.getDescription());
        to.setMarshalVersion(from.getMarshalVersion());
    }

    private static void copyRoot(StandardAssignableAdapted from, StandardAssignable to) {
        to.setId(from.getId());
        to.setDescription(from.getDescription());
        to.setMarshalVersion(from.getMarshalVersion());
    }

    @Override
    public StandardAssignable getUnmappedObject() {
        if (this.unmappedObject == null) {
            this.unmappedObject = this.generatesPOJO();
        }
        return this.unmappedObject;
    }

    private StandardAssignable generatesPOJO() {
        StandardAssignable sa = new StandardAssignable();
        StandardAssignableAdapted.copyRoot(this, sa);
        if (this.assign != null) {
            sa.setAssign(this.assign);
        } else if (this.equation != null) {
            sa.setAssign(Equation.toRhs(this.equation));
        } else if (this.scalar != null) {
            sa.setAssign(new Rhs(this.scalar));
        } else if (this.symbRef != null) {
            sa.setAssign(new Rhs(this.symbRef));
        }
        return sa;
    }

    public static class ScalarRhsAdapter
    extends XmlAdapter<StandardAssignableAdapted, StandardAssignable> {
        public StandardAssignable unmarshal(StandardAssignableAdapted v) throws Exception {
            if (v != null) {
                return v.getUnmappedObject();
            }
            return null;
        }

        public StandardAssignableAdapted marshal(StandardAssignable v) throws Exception {
            if (v != null) {
                StandardAssignableAdapted adapted = v.getMarshalVersion().isEqualOrLaterThan(PharmMLVersion.V0_7_3) ? StandardAssignableAdapted.normal(v) : StandardAssignableAdapted.scalarRhs(v);
                adapted.unmappedObject = v;
                return adapted;
            }
            return null;
        }
    }
}

