/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.MasterObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.AbstractFormula;
import eu.ddmore.libpharmml.dom.commontypes.ObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.OperationVariable;
import eu.ddmore.libpharmml.dom.commontypes.SumIndexSet;
import eu.ddmore.libpharmml.dom.commontypes.SumProductIndex;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.Vector;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.Operand;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SumType", propOrder={"variable", "sumIndex", "lowLimit", "upLimit", "sumIndexSet"})
public class Sum
extends AbstractFormula
implements Operand,
ExpressionValue,
LogicBinOperand {
    @XmlElement(name="SumIndex", required=true)
    protected SumProductIndex sumIndex;
    @XmlElement(name="SumIndexSet")
    protected SumIndexSet sumIndexSet;

    public Sum() {
    }

    public Sum(OperationVariable V, SymbolRef i, int n, int N) {
        this.variable = V;
        this.createSumIndex(i);
        this.createLowLimit(n);
        this.createUpLimit(N);
    }

    public Sum(OperationVariable V, SymbolRef i, Vector indexSet) {
        this.variable = V;
        this.createSumIndex(i);
        this.createSumIndexSet(indexSet);
    }

    public SumProductIndex getSumIndex() {
        return this.sumIndex;
    }

    public void setSumIndex(SumProductIndex value) {
        this.sumIndex = value;
    }

    public SumIndexSet getSumIndexSet() {
        return this.sumIndexSet;
    }

    public void setSumIndexSet(SumIndexSet value) {
        this.sumIndexSet = value;
    }

    public SumIndexSet createSumIndexSet(Vector vector) {
        SumIndexSet indexSet = new SumIndexSet();
        indexSet.setVector(vector);
        this.setSumIndexSet(indexSet);
        return indexSet;
    }

    public SumProductIndex createSumIndex(SymbolRef i) {
        SumProductIndex index = new SumProductIndex();
        index.setSymbRef(i);
        this.setSumIndex(index);
        return index;
    }

    public JAXBElement<Sum> toJAXBElement() {
        return MasterObjectFactory.COMMONTYPES_OF.createSum(this);
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<OperationVariable>().addIfNotNull(this.variable).addIfNotNull((OperationVariable)((Object)this.sumIndex)).addIfNotNull((OperationVariable)((Object)this.lowLimit)).addIfNotNull((OperationVariable)((Object)this.upLimit)).addIfNotNull((OperationVariable)((Object)this.sumIndexSet));
    }

    @Override
    public String toMathExpression() {
        return null;
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<Sum> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createSum(this);
    }
}

