/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.dom.commontypes.BooleanValue;
import eu.ddmore.libpharmml.dom.commontypes.IdValue;
import eu.ddmore.libpharmml.dom.commontypes.IntValue;
import eu.ddmore.libpharmml.dom.commontypes.RealValue;
import eu.ddmore.libpharmml.dom.commontypes.StringValue;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="SymbolTypeType")
@XmlEnum
public enum SymbolType {
    INT("int", IntValue.class),
    REAL("real", RealValue.class),
    BOOLEAN("boolean", BooleanValue.class),
    STRING("string", StringValue.class),
    ID("id", IdValue.class);

    private final String value;
    private final Class<?> dataType;

    private SymbolType(String v, Class<?> dataType) {
        this.value = v;
        this.dataType = dataType;
    }

    public String value() {
        return this.value;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public static SymbolType fromValue(String v) {
        for (SymbolType c : SymbolType.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }
}

