/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.commontypes.AbstractVector;
import eu.ddmore.libpharmml.dom.commontypes.BooleanValue;
import eu.ddmore.libpharmml.dom.commontypes.IntValue;
import eu.ddmore.libpharmml.dom.commontypes.MatrixVectorIndex;
import eu.ddmore.libpharmml.dom.commontypes.ObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.RealValue;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.dom.commontypes.StringValue;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.VectorCell;
import eu.ddmore.libpharmml.dom.commontypes.VectorCellValue;
import eu.ddmore.libpharmml.dom.commontypes.VectorElements;
import eu.ddmore.libpharmml.dom.commontypes.VectorSegment;
import eu.ddmore.libpharmml.dom.commontypes.VectorValue;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.dom.tags.MathExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="VectorType", propOrder={"vectorElements", "vectorCellOrVectorSegment", "sequenceOrScalar"})
public class Vector
extends AbstractVector
implements ExpressionValue,
MathExpression,
LogicBinOperand {
    @XmlElementRefs(value={@XmlElementRef(name="Sequence", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="Scalar", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false)})
    protected List<JAXBElement<?>> sequenceOrScalar;
    @XmlElements(value={@XmlElement(name="VectorCell", type=VectorCell.class), @XmlElement(name="VectorSegment", type=VectorSegment.class)})
    protected List<PharmMLRootType> vectorCellOrVectorSegment;
    @XmlAttribute(name="length")
    protected Integer length;

    public Vector() {
    }

    public Vector(VectorValue[] values, int length) {
        this.vectorElements = new VectorElements(values);
        this.length = length;
    }

    public Vector(double defaultValue, int length) {
        this.defaultValue = defaultValue;
        this.length = length;
    }

    public boolean addVectorCell(VectorCell cell) {
        return this.getListOfVectorCellAndSegment().add(cell);
    }

    public boolean addVectorSegment(VectorSegment segment) {
        return this.getListOfVectorCellAndSegment().add(segment);
    }

    @Deprecated
    public List<JAXBElement<?>> getSequenceOrScalar() {
        if (this.sequenceOrScalar == null) {
            this.sequenceOrScalar = new ArrayList();
        }
        return this.sequenceOrScalar;
    }

    public List<PharmMLRootType> getListOfVectorCellAndSegment() {
        if (this.vectorCellOrVectorSegment == null) {
            this.vectorCellOrVectorSegment = new ArrayList<PharmMLRootType>();
        }
        return this.vectorCellOrVectorSegment;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public VectorCell createVectorCell(int index) {
        VectorCell cell = new VectorCell();
        cell.setVectorIndex(new MatrixVectorIndex(index));
        this.addVectorCell(cell);
        return cell;
    }

    public VectorCell createVectorCell(int index, SymbolRef value) {
        VectorCell cell = this.createVectorCell(index);
        cell.setValue(value);
        return cell;
    }

    public VectorCell createVectorCell(int index, Scalar value) {
        VectorCell cell = this.createVectorCell(index);
        cell.setValue(value);
        return cell;
    }

    public VectorCell createVectorCell(int index, double value) {
        return this.createVectorCell(index, new RealValue(value));
    }

    public VectorCell createVectorCell(int index, int value) {
        return this.createVectorCell(index, new IntValue(value));
    }

    public VectorCell createVectorCell(int index, boolean value) {
        return this.createVectorCell(index, BooleanValue.fromBoolean(value));
    }

    public VectorCell createVectorCell(int index, String value) {
        return this.createVectorCell(index, new StringValue(value));
    }

    public VectorCell createVectorCell(MatrixVectorIndex index, VectorCellValue value) {
        VectorCell cell = new VectorCell();
        if (value instanceof Scalar) {
            cell.setValue((Scalar)value);
        } else if (value instanceof SymbolRef) {
            cell.setValue((SymbolRef)value);
        }
        cell.setVectorIndex(index);
        this.addVectorCell(cell);
        return cell;
    }

    public VectorSegment createVectorSegment() {
        VectorSegment segment = new VectorSegment();
        this.addVectorSegment(segment);
        return segment;
    }

    public VectorSegment createVectorSegment(int startIndex, int segmentLength, double defaultValue, VectorValue[] values) {
        VectorSegment segment = new VectorSegment(new MatrixVectorIndex(startIndex), new MatrixVectorIndex(segmentLength), defaultValue, values);
        this.addVectorSegment(segment);
        return segment;
    }

    public VectorSegment createVectorSegment(int startIndex, int segmentLength, double defaultValue) {
        VectorSegment segment = new VectorSegment(new MatrixVectorIndex(startIndex), new MatrixVectorIndex(segmentLength), defaultValue);
        this.addVectorSegment(segment);
        return segment;
    }

    @Override
    protected List<TreeNode> listChildren() {
        ChainedList<TreeNode> list = new ChainedList<VectorElements>().addIfNotNull(this.vectorElements).addIfNotNull(this.vectorCellOrVectorSegment);
        if (this.sequenceOrScalar != null) {
            for (JAXBElement<?> jaxbEl : this.sequenceOrScalar) {
                if (!(jaxbEl.getValue() instanceof TreeNode)) continue;
                list.add((TreeNode)jaxbEl.getValue());
            }
        }
        return list;
    }

    @Override
    public String toMathExpression() {
        return new MathExpressionConverterToExpression().convert(this);
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<Vector> toJAXBElement() {
        return ObjectFactory.getInstance().createVector(this);
    }

    public JAXBElement<Vector> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createVector(this);
    }
}

