/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.dom.commontypes.IntValue;
import eu.ddmore.libpharmml.dom.commontypes.MatrixVectorIndex;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="VectorSegmentSelectorType", propOrder={"startIndex", "segmentLength"})
public class VectorSegmentSelector
extends PharmMLRootType {
    @XmlElementRef(name="StartIndex", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class)
    protected MatrixVectorIndex startIndex;
    @XmlElementRef(name="SegmentLength", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class)
    protected MatrixVectorIndex segmentLength;

    public VectorSegmentSelector() {
    }

    public VectorSegmentSelector(int startIndex, int length) {
        this();
        this.createStartIndex(startIndex);
        this.createSegmentLength(length);
    }

    public VectorSegmentSelector(MatrixVectorIndex startIndex, MatrixVectorIndex length) {
        this();
        this.startIndex = startIndex;
        this.segmentLength = length;
    }

    public MatrixVectorIndex getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(MatrixVectorIndex index) {
        this.startIndex = index;
    }

    public MatrixVectorIndex getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentLength(MatrixVectorIndex length) {
        this.segmentLength = length;
    }

    public MatrixVectorIndex createStartIndex(int index) {
        MatrixVectorIndex mvIndex = new MatrixVectorIndex();
        mvIndex.setIntValue(new IntValue(index));
        this.startIndex = mvIndex;
        return mvIndex;
    }

    public MatrixVectorIndex createStartIndex(SymbolRef index) {
        MatrixVectorIndex mvIndex = new MatrixVectorIndex();
        mvIndex.setSymbolRef(index);
        this.startIndex = mvIndex;
        return mvIndex;
    }

    public MatrixVectorIndex createSegmentLength(int length) {
        MatrixVectorIndex mvIndex = new MatrixVectorIndex();
        mvIndex.setIntValue(new IntValue(length));
        this.segmentLength = mvIndex;
        return mvIndex;
    }

    public MatrixVectorIndex createSegmentLength(SymbolRef length) {
        MatrixVectorIndex mvIndex = new MatrixVectorIndex();
        mvIndex.setSymbolRef(length);
        this.segmentLength = mvIndex;
        return mvIndex;
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<MatrixVectorIndex>().addIfNotNull(this.startIndex).addIfNotNull(this.segmentLength);
    }
}

