/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.commontypes;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.MasterObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.IntValue;
import eu.ddmore.libpharmml.dom.commontypes.MatrixVectorIndex;
import eu.ddmore.libpharmml.dom.commontypes.ObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.VectorCell;
import eu.ddmore.libpharmml.dom.commontypes.VectorSegment;
import eu.ddmore.libpharmml.dom.commontypes.VectorSegmentSelector;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.Operand;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="VectorSelectorType", propOrder={"symbRef", "head", "cellOrSegment", "tail"})
public class VectorSelector
extends PharmMLRootType
implements Operand,
ExpressionValue,
LogicBinOperand {
    @XmlElement(name="SymbRef", required=true)
    protected SymbolRef symbRef;
    @XmlElement(name="Head")
    protected MatrixVectorIndex head;
    @XmlElements(value={@XmlElement(name="Cell", type=MatrixVectorIndex.class), @XmlElement(name="Segment", type=VectorSegmentSelector.class)})
    protected List<PharmMLRootType> cellOrSegment;
    @XmlElement(name="Tail")
    protected MatrixVectorIndex tail;

    public VectorSelector() {
    }

    public VectorSelector(SymbolRef vectorRef) {
        this.symbRef = vectorRef;
    }

    public SymbolRef getSymbRef() {
        return this.symbRef;
    }

    public void setSymbRef(SymbolRef value) {
        this.symbRef = value;
    }

    public MatrixVectorIndex getHead() {
        return this.head;
    }

    public void setHead(MatrixVectorIndex value) {
        this.head = value;
    }

    public List<PharmMLRootType> getCellOrSegment() {
        if (this.cellOrSegment == null) {
            this.cellOrSegment = new ArrayList<PharmMLRootType>();
        }
        return this.cellOrSegment;
    }

    public MatrixVectorIndex getTail() {
        return this.tail;
    }

    public void setTail(MatrixVectorIndex value) {
        this.tail = value;
    }

    public MatrixVectorIndex createHead(int n) {
        MatrixVectorIndex head = new MatrixVectorIndex();
        head.setIntValue(new IntValue(n));
        this.head = head;
        return head;
    }

    public MatrixVectorIndex createHead(SymbolRef n) {
        MatrixVectorIndex head = new MatrixVectorIndex();
        head.setSymbolRef(n);
        this.head = head;
        return head;
    }

    public MatrixVectorIndex createTail(int n) {
        MatrixVectorIndex tail = new MatrixVectorIndex();
        tail.setIntValue(new IntValue(n));
        this.tail = tail;
        return tail;
    }

    public MatrixVectorIndex createTail(SymbolRef n) {
        MatrixVectorIndex tail = new MatrixVectorIndex();
        tail.setSymbolRef(n);
        this.tail = tail;
        return tail;
    }

    public VectorCell createVectorCell() {
        VectorCell cell = new VectorCell();
        this.getCellOrSegment().add(cell);
        return cell;
    }

    public VectorCell createVectorCell(int index) {
        VectorCell cell = this.createVectorCell();
        cell.createIndex(index);
        return cell;
    }

    public VectorCell createVectorCell(SymbolRef index) {
        VectorCell cell = this.createVectorCell();
        cell.createIndex(index);
        return cell;
    }

    public VectorSegment createVectorSegment() {
        VectorSegment segment = new VectorSegment();
        this.getCellOrSegment().add(segment);
        return segment;
    }

    public VectorSegment createVectorSegment(MatrixVectorIndex startIndex, MatrixVectorIndex segmentLength) {
        VectorSegment segment = this.createVectorSegment();
        segment.setStartIndex(startIndex);
        segment.setSegmentLength(segmentLength);
        return segment;
    }

    public JAXBElement<VectorSelector> toJAXBElement() {
        return MasterObjectFactory.COMMONTYPES_OF.createVectorSelector(this);
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<SymbolRef>().addIfNotNull(this.symbRef).addIfNotNull((SymbolRef)((Object)this.head)).addIfNotNull(this.cellOrSegment).addIfNotNull(this.tail);
    }

    @Override
    public String toMathExpression() {
        if (this.symbRef != null) {
            return this.symbRef.toMathExpression();
        }
        return "null";
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<VectorSelector> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createVectorSelector(this);
    }
}

