/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.dataset;

import eu.ddmore.libpharmml.dom.commontypes.SymbolType;
import eu.ddmore.libpharmml.dom.dataset.ColumnType;
import eu.ddmore.libpharmml.dom.dataset.CommonColumnDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ColumnDefnType")
public class ColumnDefinition
extends CommonColumnDefinition {
    @XmlAttribute(name="columnId", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String columnId;
    @XmlAttribute(name="columnType")
    protected List<ColumnType> listOfColumnType;
    @XmlAttribute(name="level")
    protected String level;
    @XmlAttribute(name="valueType", required=true)
    protected SymbolType valueType;

    public ColumnDefinition() {
    }

    public ColumnDefinition(String columnId, SymbolType valueType, Integer columnNum) {
        this.columnId = columnId;
        this.valueType = valueType;
        this.columnNum = columnNum;
    }

    @Deprecated
    public ColumnDefinition(String columnId, ColumnType columnType, SymbolType valueType, Integer columnNum) {
        this.columnId = columnId;
        this.getListOfColumnType().add(columnType);
        this.valueType = valueType;
        this.columnNum = columnNum;
    }

    public ColumnDefinition(String columnId, SymbolType valueType, Integer columnNum, ColumnType ... types) {
        this.columnId = columnId;
        this.setColumnType(types);
        this.valueType = valueType;
        this.columnNum = columnNum;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public void setColumnId(String value) {
        this.columnId = value;
    }

    @Deprecated
    public ColumnType getColumnType() {
        if (this.getListOfColumnType().size() > 0) {
            return this.getListOfColumnType().get(0);
        }
        return null;
    }

    public void setColumnType(ColumnType ... types) {
        this.getListOfColumnType().clear();
        for (ColumnType type : types) {
            this.getListOfColumnType().add(type);
        }
    }

    public List<ColumnType> getListOfColumnType() {
        if (this.listOfColumnType == null) {
            this.listOfColumnType = new ArrayList<ColumnType>();
        }
        return this.listOfColumnType;
    }

    public boolean hasColumnType(ColumnType type) {
        return this.getListOfColumnType().contains((Object)type);
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String value) {
        this.level = value;
    }

    public SymbolType getValueType() {
        return this.valueType;
    }

    public void setValueType(SymbolType value) {
        this.valueType = value;
    }
}

