/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.dataset;

import eu.ddmore.libpharmml.IErrorHandler;
import eu.ddmore.libpharmml.dom.commontypes.BooleanValue;
import eu.ddmore.libpharmml.dom.commontypes.IdValue;
import eu.ddmore.libpharmml.dom.commontypes.IntValue;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.RealValue;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.dom.commontypes.StringValue;
import eu.ddmore.libpharmml.dom.commontypes.SymbolType;
import eu.ddmore.libpharmml.dom.dataset.ColumnDefinition;
import eu.ddmore.libpharmml.dom.dataset.ColumnType;
import eu.ddmore.libpharmml.dom.dataset.DataSetTable;
import eu.ddmore.libpharmml.dom.dataset.DatasetRow;
import eu.ddmore.libpharmml.dom.dataset.ExternalFile;
import eu.ddmore.libpharmml.dom.dataset.HeaderColumnsDefinition;
import eu.ddmore.libpharmml.impl.LoggerWrapper;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import eu.ddmore.libpharmml.util.ChainedList;
import eu.ddmore.libpharmml.util.annotations.HasElementRenamed;
import eu.ddmore.libpharmml.util.annotations.RenamedElement;
import eu.ddmore.libpharmml.validation.Validatable;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DataSetType", propOrder={"definition", "mapped_externalFile", "mapped_importData", "table"})
@HasElementRenamed(mappedFields={@RenamedElement(field="mapped_externalFile", since=PharmMLVersion.V0_6), @RenamedElement(field="mapped_importData")}, transientField="externalFile")
public class DataSet
extends PharmMLRootType
implements Validatable {
    @XmlElement(name="ExternalFile")
    protected ExternalFile mapped_externalFile;
    @XmlElement(name="ImportData")
    protected ExternalFile mapped_importData;
    @XmlTransient
    protected ExternalFile externalFile;
    @XmlElement(name="Definition")
    protected HeaderColumnsDefinition definition;
    @XmlElement(name="Table")
    protected DataSetTable table;

    public HeaderColumnsDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(HeaderColumnsDefinition value) {
        this.definition = value;
    }

    @Deprecated
    public ColumnDefinition createColumnDefinition(String columnId, ColumnType columnType, SymbolType valueType, Integer columnNum) {
        if (this.definition == null) {
            this.definition = new HeaderColumnsDefinition();
        }
        return this.definition.createColumnDefinition(columnId, columnType, valueType, columnNum);
    }

    public DatasetRow createRow(String[] values) {
        DatasetRow row = new DatasetRow();
        if (this.getDefinition() == null) {
            throw new IllegalStateException("Can't create row from array without column definition.");
        }
        int size = values.length;
        List<ColumnDefinition> listOfColumns = this.getDefinition().getListOfColumn();
        if (size != listOfColumns.size()) {
            throw new IllegalStateException("Size of the array of values does not match the number of columns");
        }
        for (int i = 0; i < size; ++i) {
            SymbolType symbolType = listOfColumns.get(i).getValueType();
            if (symbolType == null) {
                throw new IllegalStateException("valueType attribute is undefined for column " + i + ".");
            }
            Scalar value = DataSet.stringToScalar(symbolType, values[i]);
            row.getListOfValue().add(value);
        }
        DataSetTable table = this.getTable() == null ? this.createTable() : this.getTable();
        table.getListOfRow().add(row);
        return row;
    }

    @Deprecated
    public ExternalFile createImportData(String path, String format, ExternalFile.Delimiter delimiter, String oid) {
        return this.createExternalFile(path, format, delimiter, oid);
    }

    public HeaderColumnsDefinition createDefinition() {
        HeaderColumnsDefinition el;
        this.definition = el = new HeaderColumnsDefinition();
        return el;
    }

    public DataSetTable createTable() {
        DataSetTable el;
        this.table = el = new DataSetTable();
        return el;
    }

    public ExternalFile createExternalFile(String path, String format, ExternalFile.Delimiter delimiter, String oid) {
        ExternalFile data = new ExternalFile();
        data.setPath(path);
        data.setFormat(format);
        data.setDelimiter(delimiter);
        data.setOid(oid);
        this.setExternalFile(data);
        return data;
    }

    @Deprecated
    public ExternalFile getImportData() {
        return this.externalFile;
    }

    @Deprecated
    public void setImportData(ExternalFile value) {
        this.externalFile = value;
    }

    public ExternalFile getExternalFile() {
        return this.externalFile;
    }

    public void setExternalFile(ExternalFile value) {
        this.externalFile = value;
    }

    public DataSetTable getTable() {
        return this.table;
    }

    public void setTable(DataSetTable value) {
        this.table = value;
    }

    @Override
    public void validate(IErrorHandler errorHandler) {
        boolean DS1a = false;
        if (this.getDefinition() != null) {
            boolean hasIdColumn = false;
            List<ColumnDefinition> listOfColumn = this.getDefinition().getListOfColumn();
            for (ColumnDefinition col : listOfColumn) {
                if (!col.hasColumnType(ColumnType.ID)) continue;
                if (hasIdColumn) {
                    DS1a = true;
                    continue;
                }
                hasIdColumn = true;
            }
            if (this.getTable() != null) {
                for (DatasetRow row : this.getTable().getListOfRow()) {
                    int n = 0;
                    try {
                        for (Scalar value : row.getListOfValue()) {
                            ColumnDefinition col;
                            if ((col = listOfColumn.get(++n - 1)).getValueType() == null || value.getClass().equals(col.getValueType().getDataType())) continue;
                            errorHandler.handleError("DS2", "Each cell must contain a value that is type compatible with the column definition.", this);
                        }
                        if (n == listOfColumn.size()) continue;
                        errorHandler.handleError("DS3", "Each row must define a cell for each column.", this);
                    }
                    catch (IndexOutOfBoundsException e) {
                        errorHandler.handleError("DS3", "Each row must define a cell for each column.", this);
                    }
                }
            }
        }
        if (DS1a) {
            errorHandler.handleError("DS1", "Only one column with columnType=\"id\" attribute is allowed", this);
        }
    }

    public void updateTypes() {
        if (this.definition != null && this.table != null) {
            int columnSize = this.definition.getListOfColumn().size();
            for (DatasetRow row : this.table.getListOfRow()) {
                int size = Math.min(columnSize, row.getListOfValue().size());
                for (int i = 0; i < size; ++i) {
                    Scalar preValue = row.getListOfValue().get(i);
                    SymbolType symbolType = this.definition.getListOfColumn().get(i).getValueType();
                    Scalar newValue = DataSet.stringToScalar(symbolType, preValue.asString());
                    row.getListOfValue().set(i, newValue);
                }
            }
        } else {
            LoggerWrapper.getLogger().warning("Can't update dataset types without defined definition and table.");
        }
    }

    private static Scalar stringToScalar(SymbolType type, String value) {
        PharmMLElement scalar;
        switch (type) {
            case ID: {
                scalar = new IdValue(value);
                break;
            }
            case REAL: {
                scalar = new RealValue(Double.valueOf(value));
                break;
            }
            case STRING: {
                scalar = new StringValue(value);
                break;
            }
            case INT: {
                scalar = new IntValue(Integer.valueOf(value));
                break;
            }
            case BOOLEAN: {
                scalar = BooleanValue.fromBoolean(Boolean.parseBoolean(value));
                break;
            }
            default: {
                scalar = null;
            }
        }
        return scalar;
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<HeaderColumnsDefinition>().addIfNotNull(this.definition).addIfNotNull((HeaderColumnsDefinition)((Object)this.externalFile)).addIfNotNull((HeaderColumnsDefinition)((Object)this.table));
    }
}

