/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.dataset;

import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.impl.LoggerWrapper;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DatasetRowType", propOrder={"scalarOrTable", "listOfValues"})
public class DatasetRow
extends PharmMLRootType {
    @XmlElementRefs(value={@XmlElementRef(name="Table", namespace="http://www.pharmml.org/pharmml/0.8/Dataset", type=JAXBElement.class, required=false), @XmlElementRef(name="Scalar", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false)})
    protected List<JAXBElement<?>> scalarOrTable;
    @XmlElementRef(name="Scalar", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false)
    protected List<Scalar> listOfValues;

    @Deprecated
    public List<JAXBElement<?>> getScalarOrTable() {
        if (this.scalarOrTable == null) {
            this.scalarOrTable = new ArrayList();
        }
        return this.scalarOrTable;
    }

    public List<Scalar> getListOfValue() {
        if (this.listOfValues == null) {
            this.listOfValues = new ArrayList<Scalar>();
        }
        return this.listOfValues;
    }

    public int size() {
        if (this.getUnmarshalVersion().equals((Object)PharmMLVersion.V0_2_1)) {
            return this.getScalarOrTable().size();
        }
        return this.getListOfValue().size();
    }

    protected void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        PharmMLVersion version = this.getUnmarshalVersion();
        switch (version) {
            case V0_2_1: {
                break;
            }
            default: {
                if (this.getScalarOrTable().size() <= 0) break;
                for (JAXBElement<?> scalOrTab : this.getScalarOrTable()) {
                    if (scalOrTab.getValue() instanceof Scalar) {
                        this.getListOfValue().add((Scalar)scalOrTab.getValue());
                        LoggerWrapper.getLogger().info("Moved 1 scalar from scalarOrTable attribute to scalar attribute in " + this);
                        continue;
                    }
                    LoggerWrapper.getLogger().warning("Skipping 1 element of type \"" + scalOrTab.getName() + " in the element " + this + ". No more used in version " + (Object)((Object)version));
                }
                this.getScalarOrTable().clear();
            }
        }
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<Scalar>().addIfNotNull(this.listOfValues);
    }
}

