/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.maths;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.MasterObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.dom.maths.Binoperator;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.ObjectFactory;
import eu.ddmore.libpharmml.dom.maths.Operand;
import eu.ddmore.libpharmml.dom.maths.ProbabilityFunction;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.dom.tags.MathExpression;
import eu.ddmore.libpharmml.impl.LoggerWrapper;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BinopType", propOrder={"content"})
public class Binop
extends PharmMLRootType
implements Operand,
ExpressionValue,
MathExpression,
LogicBinOperand {
    @XmlElementRefs(value={@XmlElementRef(name="Sum", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="ColumnRef", namespace="http://www.pharmml.org/pharmml/0.8/Dataset", type=JAXBElement.class, required=false), @XmlElementRef(name="Uniop", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="MatrixSelector", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="Scalar", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="FunctionCall", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="Constant", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="Delay", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="VectorSelector", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="Binop", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="Probability", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=JAXBElement.class, required=false), @XmlElementRef(name="Product", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="SymbRef", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="Realisation", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class), @XmlElementRef(name="Statsop", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class), @XmlElementRef(name="Naryop", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class), @XmlElementRef(name="PDF", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class), @XmlElementRef(name="CDF", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class), @XmlElementRef(name="HF", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class), @XmlElementRef(name="SF", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class)})
    protected List<JAXBElement<?>> content;
    @XmlAttribute(name="op", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String op;
    @XmlTransient
    protected Operand operand1;
    @XmlTransient
    protected Operand operand2;
    @XmlTransient
    protected Binoperator operator;

    public Binop() {
        this.init();
    }

    public Binop(Binoperator operator) {
        this();
        this.operator = operator;
    }

    public Binop(Binoperator operator, Operand operand1, Operand operand2) {
        this();
        this.operator = operator;
        this.operand1 = operand1;
        this.operand2 = operand2;
    }

    protected void init() {
        this.content = new ArrayList();
        this.content.add(null);
        this.content.add(null);
        this.op = null;
    }

    public Binoperator getOperator() {
        return this.operator;
    }

    public void setOperator(Binoperator operator) {
        this.operator = operator;
    }

    public Operand getOperand1() {
        return this.operand1;
    }

    public Operand getOperand2() {
        return this.operand2;
    }

    public void setOperand1(Operand operand) {
        this.operand1 = operand;
    }

    public void setOperand2(Operand operand) {
        this.operand2 = operand;
    }

    @Deprecated
    public String getOp() {
        if (this.operator != null) {
            return this.operator.getOperator();
        }
        return null;
    }

    @Deprecated
    public void setOp(String value) {
        this.setOperator(Binoperator.fromString(value));
    }

    public JAXBElement<Binop> toJAXBElement() {
        return MasterObjectFactory.MATHS_OF.createBinop(this);
    }

    protected void beforeMarshal(Marshaller m) {
        this.init();
        if (this.operand1 != null) {
            this.content.set(0, this.operand1.toJAXBElement());
        }
        if (this.operand2 != null) {
            this.content.set(1, this.operand2.toJAXBElement());
        }
        if (this.operator != null) {
            this.op = this.operator.getOperator();
        }
    }

    protected void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.content != null) {
            Object _operand;
            if (this.content.size() >= 1) {
                _operand = this.content.get(0).getValue();
                if (_operand instanceof ProbabilityFunction) {
                    try {
                        this.operand1 = new ProbabilityFunction.Adapter().unmarshal(this.content.get(0));
                    }
                    catch (Exception e) {
                        LoggerWrapper.getLogger().warning(_operand + " is not unmarshalled as it is not an Operand type.");
                    }
                } else if (_operand instanceof Operand) {
                    this.operand1 = (Operand)_operand;
                } else {
                    LoggerWrapper.getLogger().warning(_operand + " is not unmarshalled as it is not an Operand type.");
                }
            }
            if (this.content.size() >= 2) {
                _operand = this.content.get(1).getValue();
                if (_operand instanceof ProbabilityFunction) {
                    try {
                        this.operand2 = new ProbabilityFunction.Adapter().unmarshal(this.content.get(1));
                    }
                    catch (Exception e) {
                        LoggerWrapper.getLogger().warning(_operand + " is not unmarshalled as it is not an Operand type.");
                    }
                } else if (_operand instanceof Operand) {
                    this.operand2 = (Operand)_operand;
                } else {
                    LoggerWrapper.getLogger().warning(_operand + " is not unmarshalled as it is not an Operand type.");
                }
            }
        }
        if (this.op != null) {
            this.operator = Binoperator.fromString(this.op);
        }
    }

    @Override
    public String toString() {
        String string;
        if (this.operator == null) {
            return super.toString();
        }
        String superString = super.toString() + " [";
        String operand1String = this.operand1 instanceof Scalar ? ((Scalar)this.operand1).valueToString() : String.valueOf(this.operand1);
        String operand2String = this.operand2 instanceof Scalar ? ((Scalar)this.operand2).valueToString() : String.valueOf(this.operand2);
        switch (this.operator) {
            case ATAN2: {
                string = "atan2( " + operand1String + " , " + operand2String + " )";
                break;
            }
            case DIVIDE: {
                string = operand1String + " / " + operand2String;
                break;
            }
            case LOGX: {
                string = operand1String + "log " + operand2String;
                break;
            }
            case MAX: {
                string = "max{ " + operand1String + " , " + operand2String + " }";
                break;
            }
            case MIN: {
                string = "min{ " + operand1String + " , " + operand2String + " }";
                break;
            }
            case MINUS: {
                string = operand1String + " - " + operand2String;
                break;
            }
            case PLUS: {
                string = operand1String + " + " + operand2String;
                break;
            }
            case POWER: {
                string = operand1String + " ^ " + operand2String;
                break;
            }
            case REM: {
                string = operand1String + " % " + operand2String;
                break;
            }
            case ROOT: {
                string = operand2String + "root( " + operand1String + " )";
                break;
            }
            case TIMES: {
                string = operand1String + " x " + operand2String;
                break;
            }
            default: {
                string = "" + operand1String + (Object)((Object)this.operator) + operand2String;
            }
        }
        return superString + string + "]";
    }

    @Override
    protected List<TreeNode> listChildren() {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        if (this.operand1 instanceof TreeNode) {
            children.add((TreeNode)((Object)this.operand1));
        }
        if (this.operand2 instanceof TreeNode) {
            children.add((TreeNode)((Object)this.operand2));
        }
        return children;
    }

    @Override
    public String toMathExpression() {
        return new MathExpressionConverterToExpression().convert(this);
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<Binop> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createBinop(this);
    }
}

