/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.maths;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.MasterObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.MatrixCellValue;
import eu.ddmore.libpharmml.dom.commontypes.MatrixRowValue;
import eu.ddmore.libpharmml.dom.commontypes.OperationVariable;
import eu.ddmore.libpharmml.dom.commontypes.Rhs;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.dom.commontypes.VectorValue;
import eu.ddmore.libpharmml.dom.maths.EquationType;
import eu.ddmore.libpharmml.dom.maths.ObjectFactory;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="Equation")
public class Equation
extends EquationType
implements MatrixCellValue,
MatrixRowValue,
OperationVariable,
VectorValue {
    @Override
    public String asString() {
        return this.toString();
    }

    public static Equation fromRhs(Rhs rhs) {
        Equation eq = new Equation();
        eq.setBinop(rhs.getBinop());
        eq.setDelay(rhs.getDelay());
        eq.setDescription(rhs.getDescription());
        eq.setFunctionCall(rhs.getFunctionCall());
        eq.setId(rhs.getId());
        eq.setMatrixSelector(rhs.getMatrixSelector());
        eq.setMatrixUniop(rhs.getMatrixUniop());
        eq.setPiecewise(rhs.getPiecewise());
        eq.setProbability(rhs.getProbability());
        eq.setProduct(rhs.getProduct());
        if (rhs.getScalar() != null) {
            eq.setScalar(MasterObjectFactory.createScalar(rhs.getScalar()));
        }
        eq.setSum(rhs.getSum());
        eq.setSymbRef(rhs.getSymbRef());
        eq.setUniop(rhs.getUniop());
        eq.setVectorSelector(rhs.getVectorSelector());
        return eq;
    }

    public static Rhs toRhs(Equation eq) {
        Rhs rhs = new Rhs();
        if (eq.getScalar() != null) {
            rhs.setScalar((Scalar)eq.getScalar().getValue());
        } else {
            rhs.setBinop(eq.getBinop());
            rhs.setDelay(eq.getDelay());
            rhs.setDescription(eq.getDescription());
            rhs.setFunctionCall(eq.getFunctionCall());
            rhs.setId(eq.getId());
            rhs.setMatrixSelector(eq.getMatrixSelector());
            rhs.setMatrixUniop(eq.getMatrixUniop());
            rhs.setPiecewise(eq.getPiecewise());
            rhs.setProbability(eq.getProbability());
            rhs.setProduct(eq.getProduct());
            rhs.setSum(eq.getSum());
            rhs.setSymbRef(eq.getSymbRef());
            rhs.setUniop(eq.getUniop());
            rhs.setVectorSelector(eq.getVectorSelector());
        }
        return rhs;
    }

    public void dump() {
    }

    @Override
    public String toMathExpression() {
        return Equation.toRhs(this).toMathExpression();
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(Equation.toRhs(this));
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(Equation.toRhs(this));
    }

    public JAXBElement<Equation> toJAXBElementVectorValue() {
        return ObjectFactory.getInstance().createEquation(this);
    }
}

