/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.maths;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.MasterObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.FunctionDefinition;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.SymbolScope;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.FunctionArgumentType;
import eu.ddmore.libpharmml.dom.maths.ObjectFactory;
import eu.ddmore.libpharmml.dom.maths.Operand;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="FunctionCallType", propOrder={"symbRef", "functionArgument"})
public class FunctionCallType
extends PharmMLRootType
implements Operand,
ExpressionValue,
SymbolScope,
LogicBinOperand {
    @XmlElement(name="SymbRef", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", required=true)
    protected SymbolRef symbRef;
    @XmlElement(name="FunctionArgument")
    protected List<FunctionArgument> functionArgument;

    public FunctionCallType() {
    }

    public FunctionCallType(String symbolId) {
        SymbolRef sref;
        this.symbRef = sref = new SymbolRef(symbolId);
    }

    public FunctionCallType(FunctionDefinition fd) {
        this(fd.getSymbId());
    }

    public SymbolRef getSymbRef() {
        return this.symbRef;
    }

    public void setSymbRef(SymbolRef value) {
        this.symbRef = value;
    }

    public List<FunctionArgument> getListOfFunctionArgument() {
        if (this.functionArgument == null) {
            this.functionArgument = new ArrayList<FunctionArgument>();
        }
        return this.functionArgument;
    }

    @Deprecated
    public List<FunctionArgument> getFunctionArgument() {
        return this.getListOfFunctionArgument();
    }

    public FunctionArgument getFunctionArgument(String symbolId) {
        for (FunctionArgument fa : this.getListOfFunctionArgument()) {
            if (fa.getSymbId() == null || !fa.getSymbId().equals(symbolId)) continue;
            return fa;
        }
        return null;
    }

    public boolean containsFunctionArgument(String symbolId) {
        return this.getFunctionArgument(symbolId) != null;
    }

    public JAXBElement<FunctionCallType> toJAXBElement() {
        return MasterObjectFactory.MATHS_OF.createFunctionCall(this);
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<SymbolRef>().addIfNotNull(this.symbRef).addIfNotNull(this.functionArgument);
    }

    @Override
    public String toMathExpression() {
        return null;
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<FunctionCallType> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createFunctionCall(this);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class FunctionArgument
    extends FunctionArgumentType {
    }
}

