/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.maths;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.maths.LogicOperator;
import eu.ddmore.libpharmml.dom.maths.ObjectFactory;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.dom.tags.MathExpression;
import eu.ddmore.libpharmml.dom.tags.StructuralModelElement;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LogicBinOpType", propOrder={"content"})
public class LogicBinOp
extends PharmMLRootType
implements MathExpression,
StructuralModelElement,
LogicBinOperand {
    @XmlElementRefs(value={@XmlElementRef(name="Product", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="Constant", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="Naryop", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="Matrix", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="FunctionCall", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="Realisation", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="CDF", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="LogicUniop", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="MatrixSelector", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="CatRef", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="SF", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="ArmRef", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="Vector", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="PDF", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="SymbRef", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="Probability", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=JAXBElement.class, required=false), @XmlElementRef(name="Statsop", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="Uniop", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="Sum", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="VectorSelector", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="Scalar", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false), @XmlElementRef(name="LogicBinop", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="Binop", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="HF", namespace="http://www.pharmml.org/pharmml/0.8/Maths", type=JAXBElement.class, required=false), @XmlElementRef(name="ColumnRef", namespace="http://www.pharmml.org/pharmml/0.8/Dataset", type=JAXBElement.class, required=false), @XmlElementRef(name="Stage", namespace="http://www.pharmml.org/pharmml/0.8/TrialDesign", type=JAXBElement.class, required=false)})
    protected List<JAXBElement<?>> content;
    @XmlAttribute(name="op", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String op;

    public LogicBinOp() {
    }

    public LogicBinOp(LogicOperator op) {
        this.op = op.value();
    }

    public LogicBinOp(LogicOperator op, LogicBinOperand operand1, LogicBinOperand operand2) {
        this.op = op.value();
        if (operand1 != null) {
            this.getContent().add(operand1.toJAXBElementOfLogicBinOp());
        }
        if (operand2 != null) {
            this.getContent().add(operand2.toJAXBElementOfLogicBinOp());
        }
    }

    public List<JAXBElement<?>> getContent() {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        return this.content;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String value) {
        this.op = value;
    }

    @Override
    protected List<TreeNode> listChildren() {
        ChainedList<TreeNode> list = new ChainedList<TreeNode>(super.listChildren());
        for (JAXBElement<?> jaxbEl : this.getContent()) {
            if (!(jaxbEl.getValue() instanceof TreeNode)) continue;
            list.add((TreeNode)jaxbEl.getValue());
        }
        return list;
    }

    @Override
    public String toMathExpression() {
        return new MathExpressionConverterToExpression().convert(this);
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<LogicBinOp> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createLogicBinop(this);
    }
}

