/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.maths;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.commontypes.BooleanValue;
import eu.ddmore.libpharmml.dom.commontypes.FalseBoolean;
import eu.ddmore.libpharmml.dom.commontypes.ObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.TrueBoolean;
import eu.ddmore.libpharmml.dom.maths.Condition;
import eu.ddmore.libpharmml.dom.maths.LogicBinOp;
import eu.ddmore.libpharmml.dom.maths.LogicUniOp;
import eu.ddmore.libpharmml.dom.maths.Otherwise;
import eu.ddmore.libpharmml.dom.tags.MathExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LogicConditionType", propOrder={"logicBinop", "logicUniop", "_boolean", "otherwise"})
@XmlSeeAlso(value={Condition.class})
public class LogicCondition
extends PharmMLRootType
implements MathExpression {
    @XmlElement(name="LogicBinop")
    protected LogicBinOp logicBinop;
    @XmlElement(name="LogicUniop")
    protected LogicUniOp logicUniop;
    @XmlElementRef(name="Boolean", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=JAXBElement.class, required=false)
    protected JAXBElement<? extends BooleanValue> _boolean;
    @XmlElement(name="Otherwise")
    protected Otherwise otherwise;

    public LogicCondition() {
    }

    public LogicCondition(LogicBinOp logicBinop) {
        this.logicBinop = logicBinop;
    }

    public LogicCondition(LogicUniOp logicUniop) {
        this.logicUniop = logicUniop;
    }

    public LogicCondition(BooleanValue _boolean) {
        this._boolean = _boolean instanceof TrueBoolean ? ObjectFactory.getInstance().createTrue((TrueBoolean)_boolean) : (_boolean instanceof FalseBoolean ? ObjectFactory.getInstance().createFalse((FalseBoolean)_boolean) : ObjectFactory.getInstance().createBoolean(_boolean));
    }

    public LogicCondition(Otherwise otherwise) {
        this.otherwise = otherwise;
    }

    public LogicBinOp getLogicBinop() {
        return this.logicBinop;
    }

    public void setLogicBinop(LogicBinOp value) {
        this.logicBinop = value;
    }

    public LogicUniOp getLogicUniop() {
        return this.logicUniop;
    }

    public void setLogicUniop(LogicUniOp value) {
        this.logicUniop = value;
    }

    public JAXBElement<? extends BooleanValue> getBoolean() {
        return this._boolean;
    }

    public void setBoolean(JAXBElement<? extends BooleanValue> value) {
        this._boolean = value;
    }

    public Object getOtherwise() {
        return this.otherwise;
    }

    public void setOtherwise(Otherwise value) {
        this.otherwise = value;
    }

    public void setOtherwise(Object value) {
        this.otherwise = new Otherwise();
    }

    @Override
    protected List<TreeNode> listChildren() {
        ChainedList<TreeNode> list = new ChainedList<LogicBinOp>().addIfNotNull(this.logicBinop).addIfNotNull((LogicBinOp)((Object)this.logicUniop)).addIfNotNull((LogicBinOp)((Object)this.otherwise));
        if (this._boolean != null) {
            list.add(this._boolean.getValue());
        }
        return list;
    }

    @Override
    public String toMathExpression() {
        return null;
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }
}

