/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.maths;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.commontypes.MatrixSelector;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.Sequence;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.Vector;
import eu.ddmore.libpharmml.dom.commontypes.VectorSelector;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.Naryoperator;
import eu.ddmore.libpharmml.dom.maths.ObjectFactory;
import eu.ddmore.libpharmml.dom.maths.Operand;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NaryopType", propOrder={"content"})
public class Naryop
extends PharmMLRootType
implements ExpressionValue,
Operand,
LogicBinOperand {
    @XmlElements(value={@XmlElement(name="MatrixSelector", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=MatrixSelector.class), @XmlElement(name="SymbRef", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=SymbolRef.class), @XmlElement(name="Sequence", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=Sequence.class), @XmlElement(name="Vector", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=Vector.class), @XmlElement(name="VectorSelector", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=VectorSelector.class)})
    protected List<PharmMLRootType> content;
    @XmlAttribute(name="op", required=true)
    protected Naryoperator op;

    public Naryop() {
    }

    public Naryop(Naryoperator operator) {
        this.op = operator;
    }

    public List<PharmMLRootType> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<PharmMLRootType>();
        }
        return this.content;
    }

    public Naryoperator getOp() {
        return this.op;
    }

    public void setOp(Naryoperator value) {
        this.op = value;
    }

    public MatrixSelector createMatrixSelector() {
        MatrixSelector ms = new MatrixSelector();
        this.getContent().add(ms);
        return ms;
    }

    public MatrixSelector createMatrixSelector(SymbolRef symbolRef) {
        MatrixSelector ms = new MatrixSelector(symbolRef);
        this.getContent().add(ms);
        return ms;
    }

    public SymbolRef createSymbRef() {
        SymbolRef sref = new SymbolRef();
        this.getContent().add(sref);
        return sref;
    }

    public SymbolRef createSymbRef(String symbId) {
        SymbolRef sref = new SymbolRef(symbId);
        this.getContent().add(sref);
        return sref;
    }

    public SymbolRef createSymbRef(String symbId, String blkId) {
        SymbolRef sref = new SymbolRef(symbId, blkId);
        this.getContent().add(sref);
        return sref;
    }

    public Sequence createSequence() {
        Sequence seq = new Sequence();
        this.getContent().add(seq);
        return seq;
    }

    public Vector createVector() {
        Vector vector = new Vector();
        this.getContent().add(vector);
        return vector;
    }

    public VectorSelector createVectorSelector() {
        VectorSelector vs = new VectorSelector();
        this.getContent().add(vs);
        return vs;
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<TreeNode>(super.listChildren()).addIfNotNull(this.content);
    }

    public JAXBElement<Naryop> toJAXBElement() {
        return ObjectFactory.getInstance().createNaryop(this);
    }

    @Override
    public String toMathExpression() {
        return new MathExpressionConverterToExpression().convert(this);
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<Naryop> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createNaryop(this);
    }
}

