/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.maths;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.maths.Condition;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.ObjectFactory;
import eu.ddmore.libpharmml.dom.maths.Piece;
import eu.ddmore.libpharmml.dom.tags.MathExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PiecewiseType", propOrder={"listOfPiece"})
public class Piecewise
extends PharmMLElement
implements MathExpression {
    @XmlElement(name="Piece", required=true)
    protected List<Piece> listOfPiece;

    @Deprecated
    public List<Piece> getPiece() {
        return this.getListOfPiece();
    }

    public List<Piece> getListOfPiece() {
        if (this.listOfPiece == null) {
            this.listOfPiece = new ArrayList<Piece>();
        }
        return this.listOfPiece;
    }

    public Piece createPiece() {
        Piece piece = ObjectFactory.getInstance().createPieceType();
        this.getListOfPiece().add(piece);
        return piece;
    }

    public Piece createPiece(Condition condition, ExpressionValue value) {
        Piece piece = ObjectFactory.getInstance().createPieceType();
        this.getListOfPiece().add(piece);
        piece.setCondition(condition);
        piece.setValue(value);
        return piece;
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<Piece>().addIfNotNull(this.listOfPiece);
    }

    @Override
    public PharmMLElement clone() {
        return Piecewise.clone(Piecewise.class, this);
    }

    @Override
    public String toMathExpression() {
        return new MathExpressionConverterToExpression().convert(this);
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }
}

