/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.maths;

import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.MasterObjectFactory;
import eu.ddmore.libpharmml.dom.maths.Expression;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.ObjectFactory;
import eu.ddmore.libpharmml.dom.maths.Operand;
import eu.ddmore.libpharmml.dom.maths.Unioperator;
import eu.ddmore.libpharmml.dom.tags.LogicBinOperand;
import eu.ddmore.libpharmml.dom.tags.MathExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToExpression;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToMathML;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="UniopType")
public class Uniop
extends Expression
implements Operand,
ExpressionValue,
MathExpression,
LogicBinOperand {
    @XmlAttribute(name="op", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String op;
    @XmlTransient
    protected Unioperator operator;

    public Uniop() {
    }

    public Uniop(Unioperator operator, ExpressionValue value) {
        this.operator = operator;
        this.value = value;
    }

    @Deprecated
    public String getOp() {
        if (this.operator != null) {
            return this.operator.getOperator();
        }
        return null;
    }

    @Deprecated
    public void setOp(String value) {
        this.setOperator(Unioperator.fromString(value));
    }

    public Unioperator getOperator() {
        return this.operator;
    }

    public void setOperator(Unioperator operator) {
        this.operator = operator;
    }

    public JAXBElement<Uniop> toJAXBElement() {
        return MasterObjectFactory.MATHS_OF.createUniop(this);
    }

    private void init() {
        this.op = null;
    }

    protected void beforeMarshal(Marshaller m) {
        this.init();
        if (this.operator != null) {
            this.op = this.getMarshalVersion() != null && this.getMarshalVersion().isBetween(PharmMLVersion.V0_3, PharmMLVersion.V0_3_1) && this.operator.equals((Object)Unioperator.LOG) ? "ln" : this.operator.getOperator();
        }
    }

    protected void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.op != null) {
            this.operator = Unioperator.fromString(this.op);
        }
    }

    @Override
    public String toString() {
        String content = this.getValue().toString();
        StringBuilder sb = new StringBuilder();
        switch (this.operator) {
            case MINUS: {
                sb.append("- " + content);
                break;
            }
            default: {
                sb.append((Object)((Object)this.operator) + "(" + content + ")");
            }
        }
        return sb.toString();
    }

    @Override
    public String toMathExpression() {
        return new MathExpressionConverterToExpression().convert(this);
    }

    @Override
    public String toMathML() {
        return new MathExpressionConverterToMathML().convert(this);
    }

    @Override
    public String convert(MathExpressionConverter converter) {
        return converter.convert(this);
    }

    public JAXBElement<Uniop> toJAXBElementOfLogicBinOp() {
        return ObjectFactory.getInstance().createUniop(this);
    }
}

