/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.maths;

import eu.ddmore.libpharmml.impl.LoggerWrapper;

public enum Unioperator {
    ABS("abs"),
    EXP("exp"),
    FACTORIAL("factorial"),
    FACTLN("factln"),
    GAMMA("gamma"),
    GAMMALN("gammaln"),
    LOG("log"),
    LOG2("log2"),
    LOG10("log10"),
    LOGISTIC("logistic"),
    LOGIT("logit"),
    NORMCDF("normcdf"),
    PROBIT("probit"),
    MINUS("minus"),
    SQRT("sqrt"),
    HEAVISIDE("heaviside"),
    SIGN("sign"),
    SIN("sin"),
    COS("cos"),
    TAN("tan"),
    COT("cot"),
    ATAN2("atan2"),
    SEC("sec"),
    CSC("csc"),
    SINH("sinh"),
    COSH("cosh"),
    TANH("tanh"),
    SECH("sech"),
    CSCH("csch"),
    COTH("coth"),
    ARCSIN("arcsin"),
    ARCCOS("arccos"),
    ARCTAN("arctan"),
    ARCSEC("arcsec"),
    ARCCSC("arccsc"),
    ARCCOT("arccot"),
    ARCSINH("arcsinh"),
    ARCCOSH("arccosh"),
    ARCTANH("arctanh"),
    ARCSECH("arcsech"),
    ARCCSCH("arccsch"),
    ARCCOTH("arccoth"),
    FLOOR("floor"),
    CEILING("ceiling");

    private String operator;

    private Unioperator(String op) {
        this.operator = op;
    }

    public String getOperator() {
        return this.operator;
    }

    public String value() {
        return this.operator;
    }

    public static Unioperator fromString(String operator) {
        if (operator != null) {
            for (Unioperator enu : Unioperator.values()) {
                if (!operator.equals(enu.value())) continue;
                return enu;
            }
            if (operator.equals("ln")) {
                LoggerWrapper.getLogger().info("ln enum string value used as Unioperator.LOG");
                return LOG;
            }
        }
        return null;
    }
}

