/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.modeldefn;

import eu.ddmore.libpharmml.dom.commontypes.Name;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.SymbolType;
import eu.ddmore.libpharmml.dom.commontypes.VariableDefinition;
import eu.ddmore.libpharmml.dom.maths.ConditionalStatement;
import eu.ddmore.libpharmml.dom.maths.LogicBinOp;
import eu.ddmore.libpharmml.dom.modeldefn.CategoricalData;
import eu.ddmore.libpharmml.dom.modeldefn.ContinuousObservationModel;
import eu.ddmore.libpharmml.dom.modeldefn.Correlation;
import eu.ddmore.libpharmml.dom.modeldefn.CountData;
import eu.ddmore.libpharmml.dom.modeldefn.DesignParameter;
import eu.ddmore.libpharmml.dom.modeldefn.IndividualParameter;
import eu.ddmore.libpharmml.dom.modeldefn.Parameter;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomVariable;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import eu.ddmore.libpharmml.dom.modeldefn.SimpleParameter;
import eu.ddmore.libpharmml.dom.modeldefn.TimeToEventData;
import eu.ddmore.libpharmml.util.ChainedList;
import eu.ddmore.libpharmml.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CommonObservationModelType", propOrder={"name", "listOfElements"})
@XmlSeeAlso(value={ContinuousObservationModel.class, TimeToEventData.class, CategoricalData.class, CountData.class})
public abstract class CommonObservationModel
extends PharmMLRootType {
    @XmlElement(name="Name", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes")
    protected Name name;
    @XmlElements(value={@XmlElement(name="Correlation", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=Correlation.class, required=false), @XmlElement(name="ConditionalStatement", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=ConditionalStatement.class, required=false), @XmlElement(name="PopulationParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=PopulationParameter.class, required=false), @XmlElement(name="Parameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=Parameter.class, required=false), @XmlElement(name="SimpleParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=SimpleParameter.class, required=false), @XmlElement(name="AssignStatement", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=LogicBinOp.class, required=false), @XmlElement(name="IndividualParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=IndividualParameter.class, required=false), @XmlElement(name="DesignParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=DesignParameter.class, required=false), @XmlElement(name="RandomVariable", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=ParameterRandomVariable.class, required=false), @XmlElement(name="Variable", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=VariableDefinition.class, required=false)})
    protected List<PharmMLElement> listOfElements;

    public Name getName() {
        return this.name;
    }

    public void setName(Name value) {
        this.name = value;
    }

    public List<PharmMLElement> getListOfObservationModelElement() {
        if (this.listOfElements == null) {
            this.listOfElements = new ArrayList<PharmMLElement>();
        }
        return this.listOfElements;
    }

    public Collection<IndividualParameter> fetchIndividualParameters() {
        return Util.filter(this.listOfElements, IndividualParameter.class);
    }

    public Collection<PopulationParameter> fetchPopulationParameters() {
        return Util.filter(this.listOfElements, PopulationParameter.class);
    }

    public Collection<Parameter> fetchParameters() {
        return Util.filter(this.listOfElements, Parameter.class);
    }

    public Collection<ParameterRandomVariable> fetchParameterRandomVariables() {
        return Util.filter(this.listOfElements, ParameterRandomVariable.class);
    }

    public Collection<DesignParameter> fetchDesignParameters() {
        return Util.filter(this.listOfElements, DesignParameter.class);
    }

    public Collection<LogicBinOp> fetchAssignStatements() {
        return Util.filter(this.listOfElements, LogicBinOp.class);
    }

    public Collection<ConditionalStatement> fetchConditionalStatements() {
        return Util.filter(this.listOfElements, ConditionalStatement.class);
    }

    public Collection<Correlation> fetchCorrelations() {
        return Util.filter(this.listOfElements, Correlation.class);
    }

    public Collection<VariableDefinition> fetchVariables() {
        return Util.filter(this.listOfElements, VariableDefinition.class);
    }

    public Name createName(String name) {
        Name el;
        this.name = el = new Name();
        el.setValue(name);
        return el;
    }

    public VariableDefinition createVariable() {
        VariableDefinition el = new VariableDefinition();
        this.getListOfObservationModelElement().add(el);
        return el;
    }

    public VariableDefinition createVariable(String symbolId, SymbolType type) {
        VariableDefinition el = new VariableDefinition();
        this.getListOfObservationModelElement().add(el);
        el.setSymbId(symbolId);
        el.setSymbolType(type);
        return el;
    }

    public Correlation createCorrelation() {
        Correlation el = new Correlation();
        this.getListOfObservationModelElement().add(el);
        return el;
    }

    public Parameter createParameter() {
        Parameter param = new Parameter();
        this.getListOfObservationModelElement().add(param);
        return param;
    }

    public Parameter createParameter(String symbId) {
        Parameter param = this.createParameter();
        param.setSymbId(symbId);
        return param;
    }

    public IndividualParameter createIndividualParameter() {
        IndividualParameter param = new IndividualParameter();
        this.getListOfObservationModelElement().add(param);
        return param;
    }

    public IndividualParameter createIndividualParameter(String symbId) {
        IndividualParameter param = this.createIndividualParameter();
        param.setSymbId(symbId);
        return param;
    }

    public PopulationParameter createPopulationParameter() {
        PopulationParameter param = new PopulationParameter();
        this.getListOfObservationModelElement().add(param);
        return param;
    }

    public PopulationParameter createPopulationParameter(String symbId) {
        PopulationParameter param = this.createPopulationParameter();
        param.setSymbId(symbId);
        return param;
    }

    public DesignParameter createDesignParameter() {
        DesignParameter dp = new DesignParameter();
        this.getListOfObservationModelElement().add(dp);
        return dp;
    }

    public DesignParameter createDesignParameter(String symbId) {
        DesignParameter dp = this.createDesignParameter();
        dp.setSymbId(symbId);
        return dp;
    }

    public ParameterRandomVariable createParameterRandomVariable() {
        ParameterRandomVariable prv = new ParameterRandomVariable();
        this.getListOfObservationModelElement().add(prv);
        return prv;
    }

    public ParameterRandomVariable createParameterRandomVariable(String symbId) {
        ParameterRandomVariable prv = new ParameterRandomVariable();
        prv.setSymbId(symbId);
        this.getListOfObservationModelElement().add(prv);
        return prv;
    }

    protected void afterUnmarshal(Unmarshaller u, Object parent) {
    }

    protected void beforeMarshal(Marshaller m) {
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<TreeNode>(super.listChildren()).addIfNotNull(this.name).addIfNotNull(this.listOfElements);
    }
}

