/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.modeldefn;

import eu.ddmore.libpharmml.dom.MasterObjectFactory;
import eu.ddmore.libpharmml.dom.commontypes.Block;
import eu.ddmore.libpharmml.dom.commontypes.Name;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.maths.ConditionalStatement;
import eu.ddmore.libpharmml.dom.maths.LogicBinOp;
import eu.ddmore.libpharmml.dom.maths.LogicOperator;
import eu.ddmore.libpharmml.dom.modeldefn.Correlation;
import eu.ddmore.libpharmml.dom.modeldefn.DesignParameter;
import eu.ddmore.libpharmml.dom.modeldefn.IndividualParameter;
import eu.ddmore.libpharmml.dom.modeldefn.Parameter;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterModel;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomVariable;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import eu.ddmore.libpharmml.dom.modeldefn.SimpleParameter;
import eu.ddmore.libpharmml.util.ChainedList;
import eu.ddmore.libpharmml.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CommonParameterModelType", propOrder={"name", "listOfElements"})
@XmlSeeAlso(value={ParameterModel.class})
public abstract class CommonParameterModel
extends PharmMLRootType
implements Block {
    @XmlElement(name="Name", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes")
    protected Name name;
    @XmlElements(value={@XmlElement(name="Correlation", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=Correlation.class, required=false), @XmlElement(name="ConditionalStatement", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=ConditionalStatement.class, required=false), @XmlElement(name="PopulationParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=PopulationParameter.class, required=false), @XmlElement(name="Parameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=Parameter.class, required=false), @XmlElement(name="SimpleParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=SimpleParameter.class, required=false), @XmlElement(name="AssignStatement", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=LogicBinOp.class, required=false), @XmlElement(name="IndividualParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=IndividualParameter.class, required=false), @XmlElement(name="DesignParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=DesignParameter.class, required=false), @XmlElement(name="RandomVariable", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=ParameterRandomVariable.class, required=false)})
    protected List<PharmMLElement> listOfElements;
    @XmlAttribute(name="blkId", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String blkId;

    public Name getName() {
        return this.name;
    }

    public void setName(Name value) {
        this.name = value;
    }

    public List<PharmMLElement> getListOfParameterModelElements() {
        if (this.listOfElements == null) {
            this.listOfElements = new ArrayList<PharmMLElement>();
        }
        return this.listOfElements;
    }

    public Collection<IndividualParameter> fetchIndividualParameters() {
        return Util.filter(this.listOfElements, IndividualParameter.class);
    }

    public Collection<PopulationParameter> fetchPopulationParameters() {
        return Util.filter(this.listOfElements, PopulationParameter.class);
    }

    public Collection<Parameter> fetchParameters() {
        return Util.filter(this.listOfElements, Parameter.class);
    }

    public Collection<ParameterRandomVariable> fetchParameterRandomVariables() {
        return Util.filter(this.listOfElements, ParameterRandomVariable.class);
    }

    public Collection<DesignParameter> fetchDesignParameters() {
        return Util.filter(this.listOfElements, DesignParameter.class);
    }

    public Collection<LogicBinOp> fetchAssignStatements() {
        return Util.filter(this.listOfElements, LogicBinOp.class);
    }

    public Collection<ConditionalStatement> fetchConditionalStatements() {
        return Util.filter(this.listOfElements, ConditionalStatement.class);
    }

    public Collection<Correlation> fetchCorrelations() {
        return Util.filter(this.listOfElements, Correlation.class);
    }

    public Parameter createParameter() {
        Parameter param = new Parameter();
        this.getListOfParameterModelElements().add(param);
        return param;
    }

    public Parameter createParameter(String symbId) {
        Parameter param = this.createParameter();
        param.setSymbId(symbId);
        return param;
    }

    public IndividualParameter createIndividualParameter() {
        IndividualParameter param = new IndividualParameter();
        this.getListOfParameterModelElements().add(param);
        return param;
    }

    public IndividualParameter createIndividualParameter(String symbId) {
        IndividualParameter param = this.createIndividualParameter();
        param.setSymbId(symbId);
        return param;
    }

    public PopulationParameter createPopulationParameter() {
        PopulationParameter param = new PopulationParameter();
        this.getListOfParameterModelElements().add(param);
        return param;
    }

    public PopulationParameter createPopulationParameter(String symbId) {
        PopulationParameter param = this.createPopulationParameter();
        param.setSymbId(symbId);
        return param;
    }

    public DesignParameter createDesignParameter() {
        DesignParameter dp = new DesignParameter();
        this.getListOfParameterModelElements().add(dp);
        return dp;
    }

    public DesignParameter createDesignParameter(String symbId) {
        DesignParameter dp = this.createDesignParameter();
        dp.setSymbId(symbId);
        return dp;
    }

    public ParameterRandomVariable createParameterRandomVariable() {
        ParameterRandomVariable prv = new ParameterRandomVariable();
        this.getListOfParameterModelElements().add(prv);
        return prv;
    }

    public ParameterRandomVariable createParameterRandomVariable(String symbId) {
        ParameterRandomVariable prv = new ParameterRandomVariable();
        prv.setSymbId(symbId);
        this.getListOfParameterModelElements().add(prv);
        return prv;
    }

    public Correlation createCorrelation() {
        Correlation c = new Correlation();
        this.getListOfParameterModelElements().add(c);
        return c;
    }

    public LogicBinOp createAssignStatement() {
        LogicBinOp as = new LogicBinOp(LogicOperator.EQ);
        this.getListOfParameterModelElements().add(as);
        return as;
    }

    public LogicBinOp createAssignStatement(SymbolRef lhs) {
        LogicBinOp as = new LogicBinOp(LogicOperator.EQ);
        as.getContent().add(MasterObjectFactory.COMMONTYPES_OF.createSymbRef(lhs));
        this.getListOfParameterModelElements().add(as);
        return as;
    }

    public ConditionalStatement createConditionalStatement() {
        ConditionalStatement cs = new ConditionalStatement();
        this.getListOfParameterModelElements().add(cs);
        return cs;
    }

    @Override
    public String getBlkId() {
        return this.blkId;
    }

    @Override
    public void setBlkId(String value) {
        this.blkId = value;
    }

    @Override
    protected List<TreeNode> listChildren() {
        ChainedList<TreeNode> list = new ChainedList<TreeNode>(super.listChildren()).addIfNotNull(this.name).addIfNotNull(this.listOfElements);
        return list;
    }
}

