/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.modeldefn;

import eu.ddmore.libpharmml.dom.commontypes.Block;
import eu.ddmore.libpharmml.dom.commontypes.DerivativeVariable;
import eu.ddmore.libpharmml.dom.commontypes.FunctionDefinition;
import eu.ddmore.libpharmml.dom.commontypes.Name;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.SymbolType;
import eu.ddmore.libpharmml.dom.commontypes.VariableDefinition;
import eu.ddmore.libpharmml.dom.maths.ConditionalStatement;
import eu.ddmore.libpharmml.dom.maths.LogicBinOp;
import eu.ddmore.libpharmml.dom.modeldefn.IndividualParameter;
import eu.ddmore.libpharmml.dom.modeldefn.Parameter;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomVariable;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import eu.ddmore.libpharmml.dom.modeldefn.SimpleParameter;
import eu.ddmore.libpharmml.dom.modeldefn.pkmacro.PKMacroList;
import eu.ddmore.libpharmml.util.ChainedList;
import eu.ddmore.libpharmml.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="StructuralModelType", propOrder={"name", "listOfElements"})
public class StructuralModel
extends PharmMLRootType
implements Block {
    @XmlElement(name="Name", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes")
    protected Name name;
    @XmlAttribute(name="blkId", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String blkId;
    @XmlElements(value={@XmlElement(name="CommonVariable", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", required=false), @XmlElement(name="Variable", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=VariableDefinition.class, required=false), @XmlElement(name="DerivativeVariable", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=DerivativeVariable.class, required=false), @XmlElement(name="ConditionalStatement", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=ConditionalStatement.class, required=false), @XmlElement(name="PopulationParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=PopulationParameter.class, required=false), @XmlElement(name="Parameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=Parameter.class, required=false), @XmlElement(name="SimpleParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=SimpleParameter.class, required=false), @XmlElement(name="PKmacros", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=PKMacroList.class, required=false), @XmlElement(name="AssignStatement", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=LogicBinOp.class, required=false), @XmlElement(name="IndividualParameter", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=IndividualParameter.class, required=false), @XmlElement(name="FunctionDefinition", namespace="http://www.pharmml.org/pharmml/0.8/CommonTypes", type=FunctionDefinition.class, required=false), @XmlElement(name="RandomVariable", namespace="http://www.pharmml.org/pharmml/0.8/ModelDefinition", type=ParameterRandomVariable.class, required=false)})
    protected List<PharmMLElement> listOfElements;

    public List<PharmMLElement> getListOfStructuralModelElements() {
        if (this.listOfElements == null) {
            this.listOfElements = new ArrayList<PharmMLElement>();
        }
        return this.listOfElements;
    }

    public Collection<PKMacroList> fetchPKMacroLists() {
        return Util.filter(this.listOfElements, PKMacroList.class);
    }

    public Collection<VariableDefinition> fetchVariables() {
        return Util.filter(this.listOfElements, VariableDefinition.class);
    }

    public Collection<DerivativeVariable> fetchDerivativeVariables() {
        return Util.filter(this.listOfElements, DerivativeVariable.class);
    }

    public Collection<IndividualParameter> fetchIndividualParameters() {
        return Util.filter(this.listOfElements, IndividualParameter.class);
    }

    public Collection<PopulationParameter> fetchPopulationParameters() {
        return Util.filter(this.listOfElements, PopulationParameter.class);
    }

    public Collection<Parameter> fetchParameters() {
        return Util.filter(this.listOfElements, Parameter.class);
    }

    public Collection<LogicBinOp> fetchAssignStatements() {
        return Util.filter(this.listOfElements, LogicBinOp.class);
    }

    public Collection<ConditionalStatement> fetchConditionalStatements() {
        return Util.filter(this.listOfElements, ConditionalStatement.class);
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name value) {
        this.name = value;
    }

    @Override
    public String getBlkId() {
        return this.blkId;
    }

    @Override
    public void setBlkId(String value) {
        this.blkId = value;
    }

    public PKMacroList createPKMacroList() {
        PKMacroList macros = new PKMacroList();
        this.getListOfStructuralModelElements().add(macros);
        return macros;
    }

    @Deprecated
    public SimpleParameter createSimpleParameter() {
        SimpleParameter param = new SimpleParameter();
        this.getListOfStructuralModelElements().add(param);
        return param;
    }

    @Deprecated
    public SimpleParameter createSimpleParameter(String symbId) {
        SimpleParameter param = this.createSimpleParameter();
        param.setSymbId(symbId);
        return param;
    }

    public IndividualParameter createIndividualParameter() {
        IndividualParameter param = new IndividualParameter();
        this.getListOfStructuralModelElements().add(param);
        return param;
    }

    public PopulationParameter createPopulationParameter() {
        PopulationParameter param = new PopulationParameter();
        this.getListOfStructuralModelElements().add(param);
        return param;
    }

    public VariableDefinition createVariable() {
        VariableDefinition var = new VariableDefinition();
        this.getListOfStructuralModelElements().add(var);
        return var;
    }

    public VariableDefinition createVariable(String symbId, SymbolType symbolType) {
        VariableDefinition var = this.createVariable();
        var.setSymbId(symbId);
        var.setSymbolType(symbolType);
        return var;
    }

    public DerivativeVariable createDerivativeVariable() {
        DerivativeVariable var = new DerivativeVariable();
        this.getListOfStructuralModelElements().add(var);
        return var;
    }

    public DerivativeVariable createDerivativeVariable(String symbId, SymbolType symbolType) {
        DerivativeVariable var = this.createDerivativeVariable();
        var.setSymbId(symbId);
        var.setSymbolType(symbolType);
        return var;
    }

    public LogicBinOp createAssignStatement() {
        LogicBinOp as = new LogicBinOp();
        this.getListOfStructuralModelElements().add(as);
        return as;
    }

    public ConditionalStatement createConditionalStatement() {
        ConditionalStatement cs = new ConditionalStatement();
        this.getListOfStructuralModelElements().add(cs);
        return cs;
    }

    public Parameter createParameter() {
        Parameter param = new Parameter();
        this.getListOfStructuralModelElements().add(param);
        return param;
    }

    public Parameter createParameter(String symbId) {
        Parameter param = new Parameter(symbId);
        this.getListOfStructuralModelElements().add(param);
        return param;
    }

    public FunctionDefinition createFunctionDefinition() {
        FunctionDefinition el = new FunctionDefinition();
        this.getListOfStructuralModelElements().add(el);
        return el;
    }

    public FunctionDefinition createFunctionDefinition(String symbId, SymbolType type) {
        FunctionDefinition el = this.createFunctionDefinition();
        el.setSymbId(symbId);
        el.setSymbolType(type);
        return el;
    }

    @Override
    protected List<TreeNode> listChildren() {
        ChainedList<TreeNode> list = new ChainedList<TreeNode>(super.listChildren()).addIfNotNull(this.name).addIfNotNull(this.listOfElements);
        return list;
    }
}

