/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.modeldefn.pkmacro;

import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.Rhs;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.modeldefn.pkmacro.MacroValue;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"listOfValue"})
public abstract class PKMacro
extends PharmMLRootType {
    @XmlElement(name="Value", type=MacroValue.class, required=true)
    protected List<MacroValue> listOfValue;

    public List<MacroValue> getListOfValue() {
        if (this.listOfValue == null) {
            this.listOfValue = new ArrayList<MacroValue>();
        }
        return this.listOfValue;
    }

    public Rhs getValue(String argument) {
        for (MacroValue value : this.getListOfValue()) {
            if (!argument.equals(PKMacro.resolveArgument(value))) continue;
            return value.getAssign();
        }
        return null;
    }

    private static String resolveArgument(MacroValue value) {
        if (value.getArgument() != null) {
            return value.getArgument();
        }
        if (value.getSymbRef() != null) {
            return value.getSymbRef().getSymbIdRef();
        }
        return null;
    }

    public MacroValue createValue(SymbolRef symbRef) {
        MacroValue value = new MacroValue(symbRef);
        this.getListOfValue().add(value);
        return value;
    }

    public MacroValue createValue(String argument, Rhs assignment) {
        MacroValue value = new MacroValue(argument, assignment);
        this.getListOfValue().add(value);
        return value;
    }

    public abstract String getName();

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName() + "(");
        Iterator<MacroValue> it = this.getListOfValue().iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<MacroValue>().addIfNotNull(this.listOfValue);
    }
}

