/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.modeldefn.pkmacro;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public class TransferRate {
    private Integer from;
    private Integer to;
    private static final String[] stringPatterns = new String[]{"^k([0-9])([0-9])$", "^k([0-9][0-9])([0-9][0-9])$", "^k_([0-9])_([0-9])$", "^k_([0-9][0-9])_([0-9][0-9])$"};

    public TransferRate(Integer from, Integer to) {
        this.from = from;
        this.to = to;
    }

    public TransferRate(String transferRate) {
        for (String stringPattern : stringPatterns) {
            Pattern p = Pattern.compile(stringPattern);
            Matcher m = p.matcher(transferRate);
            if (!m.find()) continue;
            this.from = Integer.valueOf(m.group(1));
            this.to = Integer.valueOf(m.group(2));
            break;
        }
        if (this.from == null || this.to == null) {
            throw new IllegalArgumentException("String \"" + transferRate + "\" is not a valid transfer rate");
        }
    }

    public static boolean isValid(String transferRate) {
        for (String stringPattern : stringPatterns) {
            Pattern p = Pattern.compile(stringPattern);
            Matcher m = p.matcher(transferRate);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public Integer getFrom() {
        return this.from;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public Integer getTo() {
        return this.to;
    }

    public void setTo(Integer to) {
        this.to = to;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("k");
        if (this.from > 9 || this.to > 9) {
            sb.append("_");
            sb.append(String.format("%02d", this.from));
            sb.append("_");
            sb.append(String.format("%02d", this.to));
        } else {
            sb.append(this.from);
            sb.append(this.to);
        }
        return sb.toString();
    }
}

