/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.modellingsteps;

import eu.ddmore.libpharmml.dom.commontypes.Name;
import eu.ddmore.libpharmml.dom.commontypes.OidRef;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.dataset.ExternalFile;
import eu.ddmore.libpharmml.dom.modellingsteps.Compute;
import eu.ddmore.libpharmml.dom.modellingsteps.Cost;
import eu.ddmore.libpharmml.dom.modellingsteps.FIM;
import eu.ddmore.libpharmml.dom.modellingsteps.FIMtype;
import eu.ddmore.libpharmml.dom.modellingsteps.Method;
import eu.ddmore.libpharmml.dom.modellingsteps.OptimalDesignOpType;
import eu.ddmore.libpharmml.dom.modellingsteps.OptimalDesignOperation;
import eu.ddmore.libpharmml.dom.modellingsteps.OptimiseOn;
import eu.ddmore.libpharmml.dom.modellingsteps.Prior;
import eu.ddmore.libpharmml.dom.modellingsteps.SoftwareSettings;
import eu.ddmore.libpharmml.dom.modellingsteps.TargetToolReference;
import eu.ddmore.libpharmml.dom.modellingsteps.ToEstimate;
import eu.ddmore.libpharmml.dom.tags.PharmMLObject;
import eu.ddmore.libpharmml.util.ChainedList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OptimalDesignStepType", propOrder={"targetToolReference", "parametersToEstimate", "optimiseOn", "fim", "method", "cost", "priorInformation", "compute", "listOfSoftwareSettings", "listOfOperation", "listOfOutputFile"})
public class OptimalDesignStep
extends PharmMLRootType
implements PharmMLObject {
    @XmlElement(name="TargetToolReference")
    protected TargetToolReference targetToolReference;
    @XmlElement(name="ParametersToEstimate")
    protected ToEstimate parametersToEstimate;
    @XmlElement(name="OptimiseOn")
    protected OptimiseOn optimiseOn;
    @XmlElement(name="FIM")
    protected FIM fim;
    @XmlElement(name="Method")
    protected Method method;
    @XmlElement(name="Cost")
    protected Cost cost;
    @XmlElement(name="PriorInformation")
    protected Prior priorInformation;
    @XmlElement(name="Compute")
    protected Compute compute;
    @XmlElement(name="SoftwareSettings")
    protected List<SoftwareSettings> listOfSoftwareSettings;
    @XmlElement(name="Operation", required=true)
    protected List<OptimalDesignOperation> listOfOperation;
    @XmlElement(name="OutputFile")
    protected List<ExternalFile> listOfOutputFile;
    @XmlAttribute(name="oid", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String oid;

    public OptimalDesignStep() {
    }

    public OptimalDesignStep(String oid) {
        this.oid = oid;
    }

    public TargetToolReference getTargetToolReference() {
        return this.targetToolReference;
    }

    public void setTargetToolReference(TargetToolReference value) {
        this.targetToolReference = value;
    }

    public ToEstimate getParametersToEstimate() {
        return this.parametersToEstimate;
    }

    public void setParametersToEstimate(ToEstimate value) {
        this.parametersToEstimate = value;
    }

    public OptimiseOn getOptimiseOn() {
        return this.optimiseOn;
    }

    public void setOptimiseOn(OptimiseOn value) {
        this.optimiseOn = value;
    }

    public FIM getFIM() {
        return this.fim;
    }

    public void setFIM(FIM value) {
        this.fim = value;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method value) {
        this.method = value;
    }

    public Cost getCost() {
        return this.cost;
    }

    public void setCost(Cost value) {
        this.cost = value;
    }

    public Prior getPriorInformation() {
        return this.priorInformation;
    }

    public void setPriorInformation(Prior value) {
        this.priorInformation = value;
    }

    public Compute getCompute() {
        return this.compute;
    }

    public void setCompute(Compute value) {
        this.compute = value;
    }

    @Deprecated
    public SoftwareSettings getSoftwareSettings() {
        if (this.getListOfSoftwareSettings().size() > 0) {
            return this.getListOfSoftwareSettings().get(0);
        }
        return null;
    }

    @Deprecated
    public void setSoftwareSettings(SoftwareSettings value) {
        this.getListOfSoftwareSettings().clear();
        this.getListOfSoftwareSettings().add(value);
    }

    public List<SoftwareSettings> getListOfSoftwareSettings() {
        if (this.listOfSoftwareSettings == null) {
            this.listOfSoftwareSettings = new ArrayList<SoftwareSettings>();
        }
        return this.listOfSoftwareSettings;
    }

    public List<OptimalDesignOperation> getListOfOperation() {
        if (this.listOfOperation == null) {
            this.listOfOperation = new ArrayList<OptimalDesignOperation>();
        }
        return this.listOfOperation;
    }

    public List<ExternalFile> getListOfOutputFile() {
        if (this.listOfOutputFile == null) {
            this.listOfOutputFile = new ArrayList<ExternalFile>();
        }
        return this.listOfOutputFile;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public void setOid(String value) {
        this.oid = value;
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<TreeNode>(super.listChildren()).addIfNotNull(this.targetToolReference).addIfNotNull(this.parametersToEstimate).addIfNotNull(this.optimiseOn).addIfNotNull(this.fim).addIfNotNull(this.method).addIfNotNull(this.cost).addIfNotNull(this.priorInformation).addIfNotNull(this.compute).addIfNotNull(this.listOfSoftwareSettings).addIfNotNull(this.listOfOperation).addIfNotNull(this.listOfOutputFile);
    }

    public TargetToolReference createTargetToolReference() {
        TargetToolReference el;
        this.targetToolReference = el = new TargetToolReference();
        return el;
    }

    public TargetToolReference createTargetToolReference(String oidRef) {
        TargetToolReference el = new TargetToolReference();
        el.setOidRef(new OidRef(oidRef));
        this.targetToolReference = el;
        return el;
    }

    public OptimiseOn createOptimiseOn() {
        OptimiseOn el;
        this.optimiseOn = el = new OptimiseOn();
        return el;
    }

    public FIM createFim() {
        FIM el;
        this.fim = el = new FIM();
        return el;
    }

    @Deprecated
    public FIM createFim(String symbId) {
        FIM el = new FIM();
        el.setSymbId(symbId);
        this.fim = el;
        return el;
    }

    public FIM createFim(FIMtype type) {
        FIM el;
        this.fim = el = new FIM(type);
        return el;
    }

    public Method createMethod() {
        Method el;
        this.method = el = new Method();
        return el;
    }

    public Cost createCost() {
        Cost el;
        this.cost = el = new Cost();
        return el;
    }

    public Prior createPriorInformation() {
        Prior el;
        this.priorInformation = el = new Prior();
        return el;
    }

    public Prior createPriorInformation(String symbId) {
        Prior el = new Prior();
        el.setSymbId(symbId);
        this.priorInformation = el;
        return el;
    }

    public Compute createCompute() {
        Compute el;
        this.compute = el = new Compute();
        return el;
    }

    public SoftwareSettings createSoftwareSettings() {
        SoftwareSettings el = new SoftwareSettings();
        this.getListOfSoftwareSettings().add(el);
        return el;
    }

    public OptimalDesignOperation createOperation() {
        OptimalDesignOperation el = new OptimalDesignOperation();
        this.getListOfOperation().add(el);
        return el;
    }

    public OptimalDesignOperation createOperation(Integer order, OptimalDesignOpType opType) {
        OptimalDesignOperation el = new OptimalDesignOperation(order, opType);
        this.getListOfOperation().add(el);
        return el;
    }

    public OptimalDesignOperation createOperation(Integer order, OptimalDesignOpType opType, Name name) {
        OptimalDesignOperation el = new OptimalDesignOperation(order, opType, name);
        this.getListOfOperation().add(el);
        return el;
    }

    public ToEstimate createParametersToEstimate() {
        ToEstimate el;
        this.parametersToEstimate = el = new ToEstimate();
        return el;
    }

    public ExternalFile createOutputFile() {
        ExternalFile el = new ExternalFile();
        this.getListOfOutputFile().add(el);
        return el;
    }

    public ExternalFile createOutputFile(String oid, String path, String format, String delimiter) {
        ExternalFile el = new ExternalFile(oid, path, format, delimiter);
        this.getListOfOutputFile().add(el);
        return el;
    }
}

