/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.probonto;

import eu.ddmore.libpharmml.IErrorHandler;
import eu.ddmore.libpharmml.dom.AbstractTreeNode;
import eu.ddmore.libpharmml.dom.probonto.DistributionName;
import eu.ddmore.libpharmml.dom.probonto.DistributionParameter;
import eu.ddmore.libpharmml.dom.probonto.IProbOntoDistribution;
import eu.ddmore.libpharmml.dom.probonto.ParameterName;
import java.util.Set;

class Util {
    Util() {
    }

    static void validateProbOnto(IProbOntoDistribution probOnto, IErrorHandler errorHandler) {
        DistributionName name = probOnto.getName();
        if (name != null) {
            ParameterName[] requiredParamArray;
            for (ParameterName requiredParam : requiredParamArray = name.requiredParameters()) {
                if (probOnto.containsParameter(requiredParam)) continue;
                errorHandler.handleError("undef", "Parameter \"" + requiredParam.value() + "\" is missing in distribution +\"" + (Object)((Object)name) + "\".", (AbstractTreeNode)((Object)probOnto));
            }
            Set<ParameterName> allowedParamSet = name.allowedParameters();
            for (DistributionParameter distribParam : probOnto.getListOfParameter()) {
                if (distribParam.getName() == null || allowedParamSet.contains((Object)distribParam.getName())) continue;
                errorHandler.handleError("undef", "Parameter \"" + (Object)((Object)distribParam.getName()) + "\" does not exist for distribution " + (Object)((Object)name) + ".", (AbstractTreeNode)((Object)probOnto));
            }
        }
    }
}

