/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.dom.trialdesign;

import eu.ddmore.libpharmml.IErrorHandler;
import eu.ddmore.libpharmml.dom.commontypes.OidRef;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.tags.PharmMLObject;
import eu.ddmore.libpharmml.dom.tags.ReferenceContainer;
import eu.ddmore.libpharmml.dom.trialdesign.ArmDefinition;
import eu.ddmore.libpharmml.dom.trialdesign.EpochDefinition;
import eu.ddmore.libpharmml.dom.trialdesign.SegmentDefinition;
import eu.ddmore.libpharmml.util.ChainedList;
import eu.ddmore.libpharmml.validation.SymbolResolver;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CellDefnType", propOrder={"epochRef", "armRef", "segmentRef"})
@Deprecated
public class CellDefinition
extends PharmMLRootType
implements PharmMLObject,
ReferenceContainer {
    @XmlElement(name="EpochRef", required=true)
    protected OidRef epochRef;
    @XmlElement(name="ArmRef", required=true)
    protected List<OidRef> armRef;
    @XmlElement(name="SegmentRef", required=true)
    protected List<OidRef> segmentRef;
    @XmlAttribute(name="oid", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String oid;

    public OidRef getEpochRef() {
        return this.epochRef;
    }

    public void setEpochRef(OidRef value) {
        this.epochRef = value;
    }

    public List<OidRef> getArmRef() {
        if (this.armRef == null) {
            this.armRef = new ArrayList<OidRef>();
        }
        return this.armRef;
    }

    public List<OidRef> getSegmentRef() {
        if (this.segmentRef == null) {
            this.segmentRef = new ArrayList<OidRef>();
        }
        return this.segmentRef;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public void setOid(String value) {
        this.oid = value;
    }

    @Override
    protected List<TreeNode> listChildren() {
        return new ChainedList<OidRef>().addIfNotNull(this.epochRef).addIfNotNull(this.armRef).addIfNotNull(this.segmentRef);
    }

    @Override
    public void validateReferences(SymbolResolver sr, IErrorHandler errorHandler) {
        PharmMLObject object;
        String oid;
        if (this.getEpochRef() != null && this.getEpochRef().getOidRef() != null) {
            String oidRef = this.getEpochRef().getOidRef();
            if (sr.containsObject(oidRef)) {
                PharmMLObject object2 = sr.getObject(oidRef);
                if (!(object2 instanceof EpochDefinition)) {
                    sr.handleIncompatibleObject(this.getEpochRef(), object2, this);
                }
            } else {
                sr.handleUnresolvedObject(this.getEpochRef());
            }
        }
        for (OidRef oidref : this.getArmRef()) {
            oid = oidref.getOidRef();
            if (oid == null) continue;
            if (sr.containsObject(oid)) {
                object = sr.getObject(oid);
                if (object instanceof ArmDefinition) continue;
                sr.handleIncompatibleObject(oidref, object, this);
                continue;
            }
            sr.handleUnresolvedObject(oidref);
        }
        for (OidRef oidref : this.getSegmentRef()) {
            oid = oidref.getOidRef();
            if (oid == null) continue;
            if (sr.containsObject(oid)) {
                object = sr.getObject(oid);
                if (object instanceof SegmentDefinition) continue;
                sr.handleIncompatibleObject(oidref, object, this);
                continue;
            }
            sr.handleUnresolvedObject(oidref);
        }
    }
}

