/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.IdFactory;
import eu.ddmore.libpharmml.dom.Identifiable;
import eu.ddmore.libpharmml.validation.exceptions.DuplicateIdentifierException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdFactoryImpl
implements IdFactory {
    private final Map<String, Identifiable> table = new Hashtable<String, Identifiable>();
    private AtomicInteger lastIndex = new AtomicInteger(0);
    private static final String patternString = "^i(\\d+)$";
    private static final Pattern idPattern = Pattern.compile("^i(\\d+)$");

    @Override
    public void storeIdentifiable(Identifiable element) throws DuplicateIdentifierException {
        String indexString;
        Integer index;
        String id = element.getId();
        if (this.table.containsKey(id) && !this.table.get(id).equals(element)) {
            throw new DuplicateIdentifierException(this.table.get(id));
        }
        Matcher matcher = idPattern.matcher(id);
        if (matcher.matches() && (index = Integer.valueOf(indexString = matcher.group(1))) > this.lastIndex.intValue()) {
            this.lastIndex.set(index);
        }
        this.table.put(id, element);
    }

    @Override
    public String generateAndStoreIdentifiable(Identifiable element) {
        element.setId("i" + this.lastIndex.incrementAndGet());
        return element.getId();
    }

    @Override
    public Identifiable getIdentifiable(String id) {
        if (this.table.containsKey(id)) {
            return this.table.get(id);
        }
        return null;
    }

    @Override
    public boolean exists(String id) {
        return this.table.containsKey(id);
    }

    @Override
    public Set<Identifiable> getListOfIdentifiable() {
        return new HashSet<Identifiable>(this.table.values());
    }
}

