/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.ILibPharmML;
import eu.ddmore.libpharmml.IMarshaller;
import eu.ddmore.libpharmml.IPharmMLResource;
import eu.ddmore.libpharmml.IPharmMLValidator;
import eu.ddmore.libpharmml.IdFactory;
import eu.ddmore.libpharmml.dom.PharmML;
import eu.ddmore.libpharmml.dom.commontypes.Name;
import eu.ddmore.libpharmml.dom.commontypes.SymbolType;
import eu.ddmore.libpharmml.dom.commontypes.VariableDefinition;
import eu.ddmore.libpharmml.dom.modeldefn.ModelDefinition;
import eu.ddmore.libpharmml.dom.modeldefn.ObjectFactory;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterModel;
import eu.ddmore.libpharmml.dom.modeldefn.StructuralModel;
import eu.ddmore.libpharmml.impl.IdFactoryImpl;
import eu.ddmore.libpharmml.impl.MarshalListener;
import eu.ddmore.libpharmml.impl.MarshallerImpl;
import eu.ddmore.libpharmml.impl.PharmMLResourceImpl;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import eu.ddmore.libpharmml.impl.UnmarshalListener;
import eu.ddmore.libpharmml.impl.ValidationReportFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public class LibPharmMLImpl
implements ILibPharmML {
    private static final String DEFAULT_NAME = "Stub Model";
    private static final String DEFAULT_STRUCT_MDL_NAME = "main";
    private IMarshaller marshaller;
    private IPharmMLValidator validator;

    @Override
    public void save(OutputStream opStr, IPharmMLResource resource) {
        if (resource.getDom().getWrittenVersion() == null) {
            throw new RuntimeException("writtenVersion attribute must be set to the root element.");
        }
        IdFactory idFactory = resource.getIdFactory();
        PharmMLVersion version = PharmMLVersion.getEnum(resource.getDom().getWrittenVersion());
        if (version == null) {
            throw new RuntimeException("Unknown or unsupported PharmML written version (" + resource.getDom().getWrittenVersion() + ")");
        }
        MarshalListener mListener = new MarshalListener(version, idFactory);
        mListener.autosetId(resource.getParameter("pharmmlresource.param.autoset_id"));
        mListener.describeVariables(resource.getParameter("pharmmlresource.param.describe_variables"));
        this.marshaller.marshall(resource.getDom(), opStr, mListener);
    }

    @Override
    public IPharmMLResource createDomFromResource(InputStream inStr) {
        ValidationReportFactory repFact = new ValidationReportFactory();
        this.marshaller.setErrorHandler(repFact);
        try {
            byte[] data = MarshallerImpl.toByteArray(inStr);
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            PharmMLVersion currentDocVersion = MarshallerImpl.parseVersion(bais);
            bais.reset();
            IdFactoryImpl idFactory = new IdFactoryImpl();
            PharmML dom = this.marshaller.unmarshall(bais, currentDocVersion, new UnmarshalListener(currentDocVersion, idFactory, repFact));
            PharmMLResourceImpl retVal = new PharmMLResourceImpl(dom, repFact.createReport(), idFactory);
            return retVal;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public IPharmMLResource createDom() {
        return this.createDom(PharmMLVersion.DEFAULT);
    }

    @Override
    public IPharmMLResource createDom(PharmMLVersion version) {
        eu.ddmore.libpharmml.dom.ObjectFactory fact = eu.ddmore.libpharmml.dom.ObjectFactory.getInstance();
        eu.ddmore.libpharmml.dom.commontypes.ObjectFactory commonFact = eu.ddmore.libpharmml.dom.commontypes.ObjectFactory.getInstance();
        PharmML dom = fact.createPharmML();
        dom.setWrittenVersion(version.getValue());
        Name name = commonFact.createNameType();
        name.setValue(DEFAULT_NAME);
        dom.setName(name);
        ObjectFactory mdefnFact = new ObjectFactory();
        ModelDefinition mdt = mdefnFact.createModelDefinitionType();
        ParameterModel pm = mdefnFact.createParameterModelType();
        pm.setBlkId("p1");
        StructuralModel structModel = mdefnFact.createStructuralModelType();
        structModel.setBlkId(DEFAULT_STRUCT_MDL_NAME);
        VariableDefinition varType = commonFact.createVariableDefinitionType();
        varType.setSymbId("x");
        varType.setSymbolType(SymbolType.REAL);
        structModel.getListOfStructuralModelElements().add(varType);
        mdt.getListOfParameterModel().add(pm);
        mdt.getListOfStructuralModel().add(structModel);
        mdefnFact.createModelDefinition(mdt);
        dom.setModelDefinition(mdt);
        ValidationReportFactory repFact = new ValidationReportFactory();
        return new PharmMLResourceImpl(dom, repFact.createReport(), new IdFactoryImpl());
    }

    @Override
    public void setValidator(IPharmMLValidator validator) {
        this.validator = validator;
    }

    @Override
    public IPharmMLValidator getValidator() {
        return this.validator;
    }

    @Override
    public void setMarshaller(IMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public IMarshaller getMarshaller() {
        return this.marshaller;
    }
}

