/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.IdFactory;
import eu.ddmore.libpharmml.MathExpressionConverter;
import eu.ddmore.libpharmml.dom.Identifiable;
import eu.ddmore.libpharmml.dom.commontypes.Assignable;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.Symbol;
import eu.ddmore.libpharmml.dom.tags.AdaptedClass;
import eu.ddmore.libpharmml.exceptions.AnnotationException;
import eu.ddmore.libpharmml.impl.LoggerWrapper;
import eu.ddmore.libpharmml.impl.MathExpressionConverterToExpression;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import eu.ddmore.libpharmml.impl.Utils;
import eu.ddmore.libpharmml.util.annotations.HasElementRenamed;
import eu.ddmore.libpharmml.util.annotations.HasElementsRenamed;
import eu.ddmore.libpharmml.util.annotations.RenamedElement;
import eu.ddmore.libpharmml.validation.exceptions.DuplicateIdentifierException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.bind.Marshaller;

public class MarshalListener
extends Marshaller.Listener {
    PharmMLVersion marshalVersion;
    private IdFactory idFactory;
    private boolean autoset_id = true;
    private boolean describe_variables = false;
    private static MathExpressionConverter descriptionConverter = new MathExpressionConverterToExpression();

    public MarshalListener(PharmMLVersion version, IdFactory idFactory) {
        this.marshalVersion = version;
        this.idFactory = idFactory;
    }

    public PharmMLVersion getMarshalVersion() {
        return this.marshalVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeMarshal(Object source) {
        this.checkForRenamedElements(source);
        if (source instanceof Identifiable && this.marshalVersion.isEqualOrLaterThan(PharmMLVersion.V0_6)) {
            Identifiable identifiable;
            if (((Identifiable)source).getId() == null && this.autoset_id) {
                identifiable = (Identifiable)source;
                String id = this.idFactory.generateAndStoreIdentifiable(identifiable);
                LoggerWrapper.getLogger().info("Assigning id \"" + id + "\" to " + source.getClass() + ".");
            } else if (((Identifiable)source).getId() != null) {
                try {
                    if (source instanceof AdaptedClass) {
                        Object pojo = ((AdaptedClass)source).getUnmappedObject();
                        if (!(pojo instanceof Identifiable)) throw new RuntimeException("POJO doesn't implement Identifiable while adapted class does, or is null");
                        identifiable = (Identifiable)pojo;
                    } else {
                        identifiable = (Identifiable)source;
                    }
                    this.idFactory.storeIdentifiable(identifiable);
                }
                catch (DuplicateIdentifierException e) {
                    LoggerWrapper.getLogger().warning("Attempt to store a duplicate identifier (" + e.getDuplicate().getId() + ").");
                }
            }
        }
        if (!this.describe_variables || !(source instanceof Symbol) || !(source instanceof Assignable) || !(source instanceof PharmMLRootType)) return;
        StringBuilder sb = new StringBuilder();
        sb.append(((Symbol)source).getSymbId());
        sb.append(" = ");
        sb.append(descriptionConverter.convert(((Assignable)source).getAssign()));
        ((PharmMLRootType)source).createDescription(sb.toString());
    }

    protected final void checkForRenamedElements(Object source) {
        Class<?> _class = source.getClass();
        this.checkForRenamedElements(_class, source);
    }

    private void checkForRenamedElements(Class<?> _class, Object source) {
        Class<?> superclass;
        Annotation annotation;
        if (_class.isAnnotationPresent(HasElementRenamed.class)) {
            annotation = _class.getAnnotation(HasElementRenamed.class);
            this.handleAnnotation((HasElementRenamed)annotation, _class, source);
        }
        if (_class.isAnnotationPresent(HasElementsRenamed.class)) {
            annotation = _class.getAnnotation(HasElementsRenamed.class);
            this.handleAnnotation((HasElementsRenamed)annotation, _class, source);
        }
        if ((superclass = _class.getSuperclass()) != null) {
            this.checkForRenamedElements(superclass, source);
        }
    }

    private void handleAnnotation(HasElementRenamed hasElRenamedAnnot, Class<?> _class, Object source) {
        try {
            String transientField = hasElRenamedAnnot.transientField();
            ArrayList<PharmMLVersion> versionList = new ArrayList<PharmMLVersion>();
            HashMap<PharmMLVersion, String> versionToField = new HashMap<PharmMLVersion, String>();
            for (RenamedElement renamedEl : hasElRenamedAnnot.mappedFields()) {
                versionList.add(renamedEl.since());
                versionToField.put(renamedEl.since(), renamedEl.field());
                Utils.eraseField(source, _class, renamedEl.field());
            }
            Collections.sort(versionList, Collections.reverseOrder());
            for (PharmMLVersion version : versionList) {
                if (!this.marshalVersion.isEqualOrLaterThan(version)) continue;
                String mappedField = (String)versionToField.get((Object)version);
                Utils.copyField(source, _class, transientField, mappedField, false);
                LoggerWrapper.getLogger().info("Using " + mappedField + " as " + transientField + " in " + source);
                break;
            }
        }
        catch (NoSuchFieldException e) {
            throw new AnnotationException(source, e.getLocalizedMessage() + " does not exist.");
        }
    }

    private void handleAnnotation(HasElementsRenamed annotation, Class<?> _class, Object source) {
        for (HasElementRenamed elRenamedAnnot : annotation.value()) {
            this.handleAnnotation(elRenamedAnnot, _class, source);
        }
    }

    public void afterMarshal(Object source) {
        super.afterMarshal(source);
    }

    public void autosetId(boolean b) {
        this.autoset_id = b;
    }

    public void describeVariables(boolean b) {
        this.describe_variables = b;
    }
}

